/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.favoritesTreeView.FavoritesListener;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.favoritesTreeView.FavoritesViewSelectInTarget;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ArrayUtil;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FavoritesProjectViewPane
extends AbstractProjectViewPane {
    @NonNls
    public static final String ID = "Favorites";
    private FavoritesTreeViewPanel myViewPanel;
    private final FavoritesManager myFavoritesManager;
    private static final Logger LOG = Logger.getInstance(FavoritesProjectViewPane.class);

    protected FavoritesProjectViewPane(@NotNull Project project, @NotNull FavoritesManager favoritesManager) {
        if (project == null) {
            FavoritesProjectViewPane.$$$reportNull$$$0(0);
        }
        if (favoritesManager == null) {
            FavoritesProjectViewPane.$$$reportNull$$$0(1);
        }
        super(project);
        this.myFavoritesManager = favoritesManager;
        FavoritesListener favoritesListener = new FavoritesListener(){
            private boolean enabled = true;

            @Override
            public void rootsChanged() {
            }

            @Override
            public void listAdded(String listName) {
                this.refreshMySubIdsAndSelect(listName);
            }

            @Override
            public void listRemoved(String listName) {
                String selectedSubId = FavoritesProjectViewPane.this.getSubId();
                this.refreshMySubIdsAndSelect(selectedSubId);
            }

            private void refreshMySubIdsAndSelect(String listName) {
                if (!this.enabled) {
                    return;
                }
                try {
                    this.enabled = false;
                    ProjectView projectView = ProjectView.getInstance(FavoritesProjectViewPane.this.myProject);
                    projectView.removeProjectPane(FavoritesProjectViewPane.this);
                    projectView.addProjectPane(FavoritesProjectViewPane.this);
                    if (!FavoritesProjectViewPane.this.myFavoritesManager.getAvailableFavoritesListNames().contains(listName)) {
                        listName = null;
                    }
                    projectView.changeView(FavoritesProjectViewPane.ID, listName);
                }
                finally {
                    this.enabled = true;
                }
            }
        };
        this.myFavoritesManager.addFavoritesListener(favoritesListener, this);
    }

    @Override
    public String getTitle() {
        return ID;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Toolwindows.ToolWindowFavorites;
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            FavoritesProjectViewPane.$$$reportNull$$$0(2);
        }
        return ID;
    }

    @Override
    public JComponent createComponent() {
        String subId = this.getSubId();
        LOG.assertTrue(subId != null, (Object)this.getSubIds());
        this.myViewPanel = new FavoritesTreeViewPanel(this.myProject);
        this.myTree = this.myViewPanel.getTree();
        this.setTreeBuilder(this.myViewPanel.getBuilder());
        this.myTreeStructure = this.myViewPanel.getFavoritesTreeStructure();
        this.installComparator();
        this.enableDnD();
        return this.myViewPanel;
    }

    @Override
    public void dispose() {
        this.myViewPanel = null;
        super.dispose();
    }

    @Override
    @NotNull
    public String[] getSubIds() {
        String[] stringArray = ArrayUtil.toStringArray(this.myFavoritesManager.getAvailableFavoritesListNames());
        if (stringArray == null) {
            FavoritesProjectViewPane.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String getPresentableSubIdName(@NotNull String subId) {
        if (subId == null) {
            FavoritesProjectViewPane.$$$reportNull$$$0(4);
        }
        String string = subId;
        if (string == null) {
            FavoritesProjectViewPane.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public ActionCallback updateFromRoot(boolean restoreExpandedPaths) {
        ActionCallback actionCallback = ((FavoritesViewTreeBuilder)this.getTreeBuilder()).updateFromRootCB();
        if (actionCallback == null) {
            FavoritesProjectViewPane.$$$reportNull$$$0(6);
        }
        return actionCallback;
    }

    @Override
    public void select(Object object, VirtualFile file2, boolean requestFocus) {
        if (!(object instanceof PsiElement)) {
            return;
        }
        VirtualFile virtualFile = PsiUtilBase.getVirtualFile((PsiElement)((PsiElement)object));
        String list2 = FavoritesViewSelectInTarget.findSuitableFavoritesList(virtualFile, this.myProject, this.getSubId());
        if (list2 == null) {
            return;
        }
        if (!list2.equals(this.getSubId())) {
            ProjectView.getInstance(this.myProject).changeView(ID, list2);
        }
        this.myViewPanel.selectElement(object, virtualFile, requestFocus);
    }

    @Override
    public int getWeight() {
        return 4;
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new FavoritesViewSelectInTarget(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "favoritesManager";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/favoritesTreeView/FavoritesProjectViewPane";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/favoritesTreeView/FavoritesProjectViewPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubIds";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableSubIdName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "updateFromRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableSubIdName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

