/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickChangeColorSchemeAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            QuickChangeColorSchemeAction.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            QuickChangeColorSchemeAction.$$$reportNull$$$0(1);
        }
        EditorColorsScheme current = EditorColorsManager.getInstance().getGlobalScheme();
        for (EditorColorsScheme scheme2 : EditorColorsManager.getInstance().getAllSchemes()) {
            QuickChangeColorSchemeAction.addScheme(group, current, scheme2, false);
        }
    }

    private static void addScheme(DefaultActionGroup group, EditorColorsScheme current, final EditorColorsScheme scheme2, final boolean addScheme) {
        group.add((AnAction)new DumbAwareAction(SchemeManager.getDisplayName((Scheme)scheme2), "", scheme2 == current ? ourCurrentAction : ourNotCurrentAction){

            public void actionPerformed(@Nullable AnActionEvent e) {
                if (addScheme) {
                    EditorColorsManager.getInstance().addColorsScheme(scheme2);
                }
                EditorColorsManager.getInstance().setGlobalScheme(scheme2);
                QuickChangeColorSchemeAction.changeLafIfNecessary(ColorUtil.isDark((Color)scheme2.getDefaultBackground()));
            }
        });
    }

    public static void changeLafIfNecessary(boolean isDarkEditorTheme) {
        final String propKey = "change.laf.on.editor.theme.change";
        String value = PropertiesComponent.getInstance().getValue(propKey);
        if ("false".equals(value)) {
            return;
        }
        boolean applyAlways = "true".equals(value);
        DialogWrapper.DoNotAskOption.Adapter doNotAskOption = new DialogWrapper.DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected) {
                    PropertiesComponent.getInstance().setValue(propKey, Boolean.toString(exitCode == 0));
                }
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }
        };
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        LafManager lafManager = LafManager.getInstance();
        if (isDarkEditorTheme && !UIUtil.isUnderDarcula()) {
            if (applyAlways || Messages.showYesNoDialog((String)ApplicationBundle.message((String)"color.scheme.theme.change.confirmation", (Object[])new Object[]{"dark", productName}), (String)ApplicationBundle.message((String)"color.scheme.theme.change.confirmation.title", (Object[])new Object[]{productName}), (String)Messages.YES_BUTTON, (String)Messages.NO_BUTTON, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption) == 0) {
                lafManager.setCurrentLookAndFeel((UIManager.LookAndFeelInfo)new DarculaLookAndFeelInfo());
                lafManager.updateUI();
                SwingUtilities.invokeLater(DarculaInstaller::install);
            }
        } else if (!isDarkEditorTheme && UIUtil.isUnderDarcula() && lafManager instanceof LafManagerImpl && (applyAlways || Messages.showYesNoDialog((String)ApplicationBundle.message((String)"color.scheme.theme.change.confirmation", (Object[])new Object[]{"bright", productName}), (String)ApplicationBundle.message((String)"color.scheme.theme.change.confirmation.title", (Object[])new Object[]{productName}), (String)Messages.YES_BUTTON, (String)Messages.NO_BUTTON, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption) == 0)) {
            lafManager.setCurrentLookAndFeel(((LafManagerImpl)lafManager).getDefaultLaf());
            lafManager.updateUI();
            SwingUtilities.invokeLater(DarculaInstaller::uninstall);
        }
    }

    protected boolean isEnabled() {
        return EditorColorsManager.getInstance().getAllSchemes().length > 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "group";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/actions/QuickChangeColorSchemeAction";
        objectArray[2] = "fillActions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

