/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.Content;
import com.intellij.history.core.StreamUtil;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.PutSystemLabelChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.util.Producer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeSet {
    private final long myId;
    @Nullable
    private String myName;
    private final long myTimestamp;
    private final List<Change> myChanges;
    private volatile boolean isLocked = false;

    public ChangeSet(long id, long timestamp) {
        this.myId = id;
        this.myTimestamp = timestamp;
        this.myChanges = new ArrayList<Change>();
    }

    public ChangeSet(DataInput in) throws IOException {
        this.myId = DataInputOutputUtil.readLONG((DataInput)in);
        this.myName = StreamUtil.readStringOrNull(in);
        this.myTimestamp = DataInputOutputUtil.readTIME((DataInput)in);
        int count = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<Change> changes = new ArrayList<Change>(count);
        while (count-- > 0) {
            changes.add(StreamUtil.readChange(in));
        }
        this.myChanges = Collections.unmodifiableList(changes);
        this.isLocked = true;
    }

    public void write(DataOutput out) throws IOException {
        LocalHistoryLog.LOG.assertTrue(this.isLocked, (Object)"Changeset should be locked");
        DataInputOutputUtil.writeLONG((DataOutput)out, (long)this.myId);
        StreamUtil.writeStringOrNull(out, this.myName);
        DataInputOutputUtil.writeTIME((DataOutput)out, (long)this.myTimestamp);
        DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myChanges.size());
        for (Change c : this.myChanges) {
            StreamUtil.writeChange(out, c);
        }
    }

    public void setName(@Nullable String name) {
        this.myName = name;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    public void lock() {
        this.isLocked = true;
    }

    @Nullable
    public String getLabel() {
        return (String)this.accessChanges(() -> {
            for (Change each : this.myChanges) {
                if (!(each instanceof PutLabelChange)) continue;
                return ((PutLabelChange)each).getName();
            }
            return null;
        });
    }

    public int getLabelColor() {
        return (Integer)this.accessChanges(() -> {
            for (Change each : this.myChanges) {
                if (!(each instanceof PutSystemLabelChange)) continue;
                return ((PutSystemLabelChange)each).getColor();
            }
            return -1;
        });
    }

    public void addChange(Change c) {
        LocalHistoryLog.LOG.assertTrue(!this.isLocked, (Object)"Changeset is already locked");
        this.accessChanges(() -> this.myChanges.add(c));
    }

    public List<Change> getChanges() {
        return (List)this.accessChanges(() -> {
            if (this.isLocked) {
                return this.myChanges;
            }
            return Collections.unmodifiableList(new ArrayList<Change>(this.myChanges));
        });
    }

    public boolean isEmpty() {
        return (Boolean)this.accessChanges(() -> this.myChanges.isEmpty());
    }

    public boolean affectsPath(String paths) {
        return (Boolean)this.accessChanges(() -> {
            for (Change c : this.myChanges) {
                if (!c.affectsPath(paths)) continue;
                return true;
            }
            return false;
        });
    }

    public boolean isCreationalFor(String path) {
        return (Boolean)this.accessChanges(() -> {
            for (Change c : this.myChanges) {
                if (!c.isCreationalFor(path)) continue;
                return true;
            }
            return false;
        });
    }

    public List<Content> getContentsToPurge() {
        return (List)this.accessChanges(() -> {
            ArrayList<Content> result2 = new ArrayList<Content>();
            for (Change c : this.myChanges) {
                result2.addAll(c.getContentsToPurge());
            }
            return result2;
        });
    }

    public boolean isContentChangeOnly() {
        return (Boolean)this.accessChanges(() -> this.myChanges.size() == 1 && this.getFirstChange() instanceof ContentChange);
    }

    public boolean isLabelOnly() {
        return (Boolean)this.accessChanges(() -> this.myChanges.size() == 1 && this.getFirstChange() instanceof PutLabelChange);
    }

    public Change getFirstChange() {
        return (Change)this.accessChanges(() -> this.myChanges.get(0));
    }

    public Change getLastChange() {
        return (Change)this.accessChanges(() -> this.myChanges.get(this.myChanges.size() - 1));
    }

    public List<String> getAffectedPaths() {
        return (List)this.accessChanges(() -> {
            SmartList result2 = new SmartList();
            for (Change each : this.myChanges) {
                if (!(each instanceof StructuralChange)) continue;
                result2.add(((StructuralChange)each).getPath());
            }
            return result2;
        });
    }

    public String toString() {
        return (String)this.accessChanges(() -> this.myChanges.toString());
    }

    public long getId() {
        return this.myId;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeSet change = (ChangeSet)o;
        return this.myId == change.myId;
    }

    public final int hashCode() {
        return (int)(this.myId ^ this.myId >>> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(ChangeVisitor v) throws ChangeVisitor.StopVisitingException {
        if (this.isLocked) {
            this.doAccept(v);
            return;
        }
        List<Change> list2 = this.myChanges;
        synchronized (list2) {
            this.doAccept(v);
        }
    }

    private void doAccept(ChangeVisitor v) throws ChangeVisitor.StopVisitingException {
        v.begin(this);
        for (Change c : ContainerUtil.iterateBackward(this.myChanges)) {
            c.accept(v);
        }
        v.end(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T accessChanges(@NotNull Producer<T> func) {
        if (func == null) {
            ChangeSet.$$$reportNull$$$0(0);
        }
        if (this.isLocked) {
            return (T)func.produce();
        }
        List<Change> list2 = this.myChanges;
        synchronized (list2) {
            return (T)func.produce();
        }
    }

    private void accessChanges(@NotNull Runnable func) {
        if (func == null) {
            ChangeSet.$$$reportNull$$$0(1);
        }
        this.accessChanges(() -> {
            if (func == null) {
                ChangeSet.$$$reportNull$$$0(2);
            }
            func.run();
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "func";
        objectArray2[1] = "com/intellij/history/core/changes/ChangeSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accessChanges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$accessChanges$14";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

