/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Block;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.Nullable;

public class LeafBlockWrapper
extends AbstractBlockWrapper {
    private static final int CONTAIN_LINE_FEEDS = 4;
    private static final int READ_ONLY = 8;
    private static final int LEAF = 16;
    private final int mySymbolsAtTheLastLine;
    private LeafBlockWrapper myPreviousBlock;
    private LeafBlockWrapper myNextBlock;
    private SpacingImpl mySpaceProperty;

    public LeafBlockWrapper(Block block, @Nullable CompositeBlockWrapper parent, WhiteSpace whiteSpaceBefore, FormattingDocumentModel model, CommonCodeStyleSettings.IndentOptions options, LeafBlockWrapper previousTokenBlock, boolean isReadOnly) {
        this(block, parent, whiteSpaceBefore, model, options, previousTokenBlock, isReadOnly, block.getTextRange());
    }

    public LeafBlockWrapper(Block block, CompositeBlockWrapper parent, WhiteSpace whiteSpaceBefore, FormattingDocumentModel model, CommonCodeStyleSettings.IndentOptions options, LeafBlockWrapper previousTokenBlock, boolean isReadOnly, TextRange textRange) {
        super(block, whiteSpaceBefore, parent, textRange);
        this.myPreviousBlock = previousTokenBlock;
        int lastLineNumber = model.getLineNumber(textRange.getEndOffset());
        int flagsValue = this.myFlags;
        boolean containsLineFeeds = model.getLineNumber(textRange.getStartOffset()) != lastLineNumber;
        flagsValue |= containsLineFeeds ? 4 : 0;
        int start = containsLineFeeds ? model.getLineStartOffset(lastLineNumber) : textRange.getStartOffset();
        int symbols = 0;
        CharSequence text2 = model.getDocument().getCharsSequence();
        for (int i = start; i < textRange.getEndOffset(); ++i) {
            if (text2.charAt(i) == '\t') {
                symbols += options.TAB_SIZE;
                continue;
            }
            ++symbols;
        }
        this.mySymbolsAtTheLastLine = symbols;
        flagsValue |= isReadOnly ? 8 : 0;
        boolean isLeaf = block.isLeaf();
        this.myFlags = flagsValue |= isLeaf ? 16 : 0;
    }

    public final boolean containsLineFeeds() {
        return (this.myFlags & 4) != 0;
    }

    public int getSymbolsAtTheLastLine() {
        return this.mySymbolsAtTheLastLine;
    }

    @Override
    public LeafBlockWrapper getPreviousBlock() {
        return this.myPreviousBlock;
    }

    public LeafBlockWrapper getNextBlock() {
        return this.myNextBlock;
    }

    public void setNextBlock(LeafBlockWrapper nextBlock) {
        this.myNextBlock = nextBlock;
    }

    @Override
    protected boolean indentAlreadyUsedBefore(AbstractBlockWrapper child) {
        return false;
    }

    @Override
    public IndentData getNumberOfSymbolsBeforeBlock() {
        int spaces = this.getWhiteSpace().getSpaces();
        int indentSpaces = this.getWhiteSpace().getIndentSpaces();
        if (this.getWhiteSpace().containsLineFeeds()) {
            return new IndentData(indentSpaces, spaces);
        }
        for (LeafBlockWrapper current = this.getPreviousBlock(); current != null; current = current.getPreviousBlock()) {
            spaces += current.getWhiteSpace().getSpaces();
            spaces += current.getSymbolsAtTheLastLine();
            indentSpaces += current.getWhiteSpace().getIndentSpaces();
            if (current.getWhiteSpace().containsLineFeeds()) break;
        }
        return new IndentData(indentSpaces, spaces);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myPreviousBlock = null;
        this.myNextBlock = null;
        this.mySpaceProperty = null;
    }

    public SpacingImpl getSpaceProperty() {
        return this.mySpaceProperty;
    }

    public IndentData calculateOffset(CommonCodeStyleSettings.IndentOptions options) {
        if (this.myIndentFromParent != null) {
            AbstractBlockWrapper firstIndentedParent = this.findFirstIndentedParent();
            IndentData indentData = new IndentData(this.myIndentFromParent.getIndentSpaces(), this.myIndentFromParent.getSpaces());
            if (firstIndentedParent == null) {
                return indentData;
            }
            WhiteSpace whiteSpace = firstIndentedParent.getWhiteSpace();
            return new IndentData(whiteSpace.getIndentOffset(), whiteSpace.getSpaces()).add(indentData);
        }
        if (this.myParent == null) {
            return new IndentData(0);
        }
        if (this.getIndent().isAbsolute()) {
            this.setCanUseFirstChildIndentAsBlockIndent(false);
            AbstractBlockWrapper current = this;
            while (current != null && current.getStartOffset() == this.getStartOffset()) {
                current.setCanUseFirstChildIndentAsBlockIndent(false);
                current = current.myParent;
            }
        }
        return this.myParent.getChildOffset(this, options, this.getStartOffset());
    }

    public void setSpaceProperty(@Nullable SpacingImpl currentSpaceProperty) {
        this.mySpaceProperty = currentSpaceProperty;
    }

    @Nullable
    public IndentInfo calcIndentFromParent() {
        AbstractBlockWrapper firstIndentedParent = this.findFirstIndentedParent();
        WhiteSpace mySpace = this.getWhiteSpace();
        if (firstIndentedParent != null) {
            WhiteSpace parentSpace = firstIndentedParent.getWhiteSpace();
            return new IndentInfo(0, mySpace.getIndentOffset() - parentSpace.getIndentOffset(), mySpace.getSpaces() - parentSpace.getSpaces());
        }
        return null;
    }

    public final boolean isLeaf() {
        return (this.myFlags & 0x10) != 0;
    }

    public boolean contains(int offset) {
        return this.myStart < offset && this.myEnd > offset;
    }

    public TextRange getTextRange() {
        return new TextRange(this.myStart, this.myEnd);
    }

    public boolean isEndOfCodeBlock() {
        ASTNode node = this.getNode();
        return node != null && node.getTextLength() == 1 && node.getChars().charAt(0) == '}';
    }
}

