/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.testframework.ui.TestsOutputConsolePrinter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestProxyPrinterProvider {
    private final TestProxyFilterProvider myFilterProvider;
    private final BaseTestsOutputConsoleView myTestOutputConsoleView;

    public TestProxyPrinterProvider(@NotNull BaseTestsOutputConsoleView testsOutputConsoleView, @NotNull TestProxyFilterProvider filterProvider) {
        if (testsOutputConsoleView == null) {
            TestProxyPrinterProvider.$$$reportNull$$$0(0);
        }
        if (filterProvider == null) {
            TestProxyPrinterProvider.$$$reportNull$$$0(1);
        }
        this.myTestOutputConsoleView = testsOutputConsoleView;
        this.myFilterProvider = filterProvider;
    }

    @Nullable
    public Printer getPrinterByType(@NotNull String nodeType, @NotNull String nodeName, @Nullable String nodeArguments) {
        Filter filter;
        if (nodeType == null) {
            TestProxyPrinterProvider.$$$reportNull$$$0(2);
        }
        if (nodeName == null) {
            TestProxyPrinterProvider.$$$reportNull$$$0(3);
        }
        if ((filter = this.myFilterProvider.getFilter(nodeType, nodeName, nodeArguments)) != null && !Disposer.isDisposed((Disposable)this.myTestOutputConsoleView)) {
            return new HyperlinkPrinter(this.myTestOutputConsoleView, HyperlinkPrinter.ERROR_CONTENT_TYPE, filter);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsOutputConsoleView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrinterByType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HyperlinkPrinter
    extends TestsOutputConsolePrinter {
        public static final Condition<ConsoleViewContentType> ERROR_CONTENT_TYPE = contentType -> ConsoleViewContentType.ERROR_OUTPUT == contentType;
        private static final String NL = "\n";
        private final Condition<ConsoleViewContentType> myContentTypeCondition;
        private final Filter myFilter;

        public HyperlinkPrinter(@NotNull BaseTestsOutputConsoleView testsOutputConsoleView, @NotNull Condition<ConsoleViewContentType> contentTypeCondition, @NotNull Filter filter) {
            if (testsOutputConsoleView == null) {
                HyperlinkPrinter.$$$reportNull$$$0(0);
            }
            if (contentTypeCondition == null) {
                HyperlinkPrinter.$$$reportNull$$$0(1);
            }
            if (filter == null) {
                HyperlinkPrinter.$$$reportNull$$$0(2);
            }
            super(testsOutputConsoleView, testsOutputConsoleView.getProperties(), null);
            this.myContentTypeCondition = contentTypeCondition;
            this.myFilter = filter;
        }

        @Override
        public void print(String text2, ConsoleViewContentType contentType) {
            if (contentType == null || !this.myContentTypeCondition.value((Object)contentType)) {
                this.defaultPrint(text2, contentType);
                return;
            }
            text2 = StringUtil.replace((String)text2, (String)"\r\n", (String)NL, (boolean)false);
            StringTokenizer tokenizer = new StringTokenizer(text2, NL, true);
            while (tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken();
                if (NL.equals(line)) {
                    this.defaultPrint(line, contentType);
                    continue;
                }
                this.printLine(line, contentType);
            }
        }

        private void defaultPrint(String text2, ConsoleViewContentType contentType) {
            super.print(text2, contentType);
        }

        private void printLine(@NotNull String line, @NotNull ConsoleViewContentType contentType) {
            Filter.Result result2;
            if (line == null) {
                HyperlinkPrinter.$$$reportNull$$$0(3);
            }
            if (contentType == null) {
                HyperlinkPrinter.$$$reportNull$$$0(4);
            }
            try {
                result2 = this.myFilter.applyFilter(line, line.length());
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + this.myFilter + " to '" + line + "'", t);
            }
            if (result2 != null) {
                List<Filter.ResultItem> items = HyperlinkPrinter.sort(result2.getResultItems());
                int lastOffset = 0;
                for (Filter.ResultItem item : items) {
                    this.defaultPrint(line.substring(lastOffset, item.getHighlightStartOffset()), contentType);
                    String linkText = line.substring(item.getHighlightStartOffset(), item.getHighlightEndOffset());
                    this.printHyperlink(linkText, item.getHyperlinkInfo());
                    lastOffset = item.getHighlightEndOffset();
                }
                this.defaultPrint(line.substring(lastOffset), contentType);
            } else {
                this.defaultPrint(line, contentType);
            }
        }

        @NotNull
        private static List<Filter.ResultItem> sort(@NotNull List<Filter.ResultItem> items) {
            if (items == null) {
                HyperlinkPrinter.$$$reportNull$$$0(5);
            }
            if (items.size() <= 1) {
                List<Filter.ResultItem> list2 = items;
                if (list2 == null) {
                    HyperlinkPrinter.$$$reportNull$$$0(6);
                }
                return list2;
            }
            ArrayList<Filter.ResultItem> copy = new ArrayList<Filter.ResultItem>(items);
            Collections.sort(copy, Comparator.comparingInt(Filter.ResultItem::getHighlightStartOffset));
            ArrayList<Filter.ResultItem> arrayList = copy;
            if (arrayList == null) {
                HyperlinkPrinter.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testsOutputConsoleView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentTypeCondition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sort";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "printLine";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "sort";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

