/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.testIntegration.TestFramework;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class TestIconProvider
extends IconProvider {
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        TestFramework[] testFrameworks;
        if (element == null) {
            TestIconProvider.$$$reportNull$$$0(0);
        }
        for (TestFramework framework : testFrameworks = (TestFramework[])Extensions.getExtensions((ExtensionPointName)TestFramework.EXTENSION_NAME)) {
            try {
                if (!framework.isIgnoredMethod(element)) continue;
                Icon ignoredTestIcon = AllIcons.RunConfigurations.IgnoredTest;
                LayeredIcon icon = new LayeredIcon(new Icon[]{ignoredTestIcon, PlatformIcons.PUBLIC_ICON});
                icon.setIcon(PlatformIcons.PUBLIC_ICON, 1, ignoredTestIcon.getIconWidth(), 0);
                return icon;
            }
            catch (AbstractMethodError ignoredTestIcon) {
                // empty catch block
            }
        }
        for (TestFramework framework : testFrameworks) {
            try {
                if (!framework.isTestMethod(element)) continue;
                LayeredIcon mark = new LayeredIcon(new Icon[]{PlatformIcons.METHOD_ICON, AllIcons.RunConfigurations.TestMark, PlatformIcons.PUBLIC_ICON});
                mark.setIcon(PlatformIcons.PUBLIC_ICON, 2, PlatformIcons.METHOD_ICON.getIconWidth(), 0);
                return mark;
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/testframework/TestIconProvider", "getIcon"));
    }
}

