/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ColoredProcessHandler
extends KillableProcessHandler
implements AnsiEscapeDecoder.ColoredTextAcceptor {
    private final AnsiEscapeDecoder myAnsiEscapeDecoder;
    private final List<AnsiEscapeDecoder.ColoredTextAcceptor> myColoredTextListeners;

    public ColoredProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            ColoredProcessHandler.$$$reportNull$$$0(0);
        }
        super(commandLine);
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        this.myColoredTextListeners = ContainerUtil.newArrayList();
        this.setShouldKillProcessSoftly(false);
    }

    public ColoredProcessHandler(@NotNull Process process2, String commandLine) {
        if (process2 == null) {
            ColoredProcessHandler.$$$reportNull$$$0(1);
        }
        super(process2, commandLine);
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        this.myColoredTextListeners = ContainerUtil.newArrayList();
        this.setShouldKillProcessSoftly(false);
    }

    public ColoredProcessHandler(@NotNull Process process2, String commandLine, @NotNull Charset charset) {
        if (process2 == null) {
            ColoredProcessHandler.$$$reportNull$$$0(2);
        }
        if (charset == null) {
            ColoredProcessHandler.$$$reportNull$$$0(3);
        }
        super(process2, commandLine, charset);
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        this.myColoredTextListeners = ContainerUtil.newArrayList();
        this.setShouldKillProcessSoftly(false);
    }

    public final void notifyTextAvailable(@NotNull String text2, @NotNull Key outputType) {
        if (text2 == null) {
            ColoredProcessHandler.$$$reportNull$$$0(4);
        }
        if (outputType == null) {
            ColoredProcessHandler.$$$reportNull$$$0(5);
        }
        this.myAnsiEscapeDecoder.escapeText(text2, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
    }

    public void coloredTextAvailable(@NotNull String text2, @NotNull Key attributes) {
        if (text2 == null) {
            ColoredProcessHandler.$$$reportNull$$$0(6);
        }
        if (attributes == null) {
            ColoredProcessHandler.$$$reportNull$$$0(7);
        }
        this.textAvailable(text2, attributes);
        this.notifyColoredListeners(text2, attributes);
    }

    protected void notifyColoredListeners(String text2, Key attributes) {
        for (AnsiEscapeDecoder.ColoredTextAcceptor listener2 : this.myColoredTextListeners) {
            listener2.coloredTextAvailable(text2, attributes);
        }
    }

    public void addColoredTextListener(AnsiEscapeDecoder.ColoredTextAcceptor listener2) {
        this.myColoredTextListeners.add(listener2);
    }

    public void removeColoredTextListener(AnsiEscapeDecoder.ColoredTextAcceptor listener2) {
        this.myColoredTextListeners.remove(listener2);
    }

    protected void textAvailable(String text2, Key attributes) {
        super.notifyTextAvailable(text2, attributes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/process/ColoredProcessHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyTextAvailable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "coloredTextAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

