/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.execution.impl.RunDialogBase;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunDialog
extends DialogWrapper
implements RunDialogBase {
    private final Project myProject;
    private final RunConfigurable myConfigurable;
    private JComponent myCenterPanel;
    @NonNls
    public static final String HELP_ID = "reference.dialogs.rundebug";
    private final Executor myExecutor;

    public RunDialog(Project project, Executor executor) {
        super(project, true);
        this.myProject = project;
        this.myExecutor = executor;
        String title = executor.getId();
        this.setTitle(title);
        this.setOKButtonText(executor.getStartActionText());
        this.setOKButtonIcon(executor.getIcon());
        this.myConfigurable = new RunConfigurable(project, this);
        this.init();
        this.myConfigurable.reset();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), new ApplyAction(), this.getHelpAction()};
        if (actionArray == null) {
            RunDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(HELP_ID);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.execution.impl.RunDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myCenterPanel);
    }

    protected void doOKAction() {
        try {
            this.myConfigurable.apply();
        }
        catch (ConfigurationException e) {
            Messages.showMessageDialog((Project)this.myProject, (String)e.getMessage(), (String)ExecutionBundle.message((String)"invalid.data.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        this.myCenterPanel = this.myConfigurable.createComponent();
        return this.myCenterPanel;
    }

    protected void dispose() {
        this.myConfigurable.disposeUIResources();
        super.dispose();
    }

    public static boolean editConfiguration(Project project, @NotNull RunnerAndConfigurationSettings configuration, String title) {
        if (configuration == null) {
            RunDialog.$$$reportNull$$$0(1);
        }
        return RunDialog.editConfiguration(project, configuration, title, null);
    }

    public static boolean editConfiguration(@NotNull ExecutionEnvironment environment, @NotNull String title) {
        if (environment == null) {
            RunDialog.$$$reportNull$$$0(2);
        }
        if (title == null) {
            RunDialog.$$$reportNull$$$0(3);
        }
        return RunDialog.editConfiguration(environment.getProject(), environment.getRunnerAndConfigurationSettings(), title, environment.getExecutor());
    }

    public static boolean editConfiguration(Project project, @NotNull RunnerAndConfigurationSettings configuration, String title, final @Nullable Executor executor) {
        if (configuration == null) {
            RunDialog.$$$reportNull$$$0(4);
        }
        SingleConfigurationConfigurable configurable = SingleConfigurationConfigurable.editSettings(configuration, executor);
        SingleConfigurableEditor dialog2 = new SingleConfigurableEditor(project, (Configurable)configurable, DialogWrapper.IdeModalityType.IDE){
            {
                super(arg0, arg1, arg2);
                if (executor != null) {
                    this.setOKButtonText(executor.getActionName());
                    this.setOKButtonIcon(executor.getIcon());
                }
            }
        };
        dialog2.setTitle(title);
        return dialog2.showAndGet();
    }

    public static SingleConfigurableEditor editShortenClasspathSetting(RunnerAndConfigurationSettings settings, String title) {
        SingleConfigurationConfigurable configurable = SingleConfigurationConfigurable.editSettings(settings, null);
        SingleConfigurableEditor dialog2 = new SingleConfigurableEditor(settings.getConfiguration().getProject(), (Configurable)configurable, DialogWrapper.IdeModalityType.IDE){

            @Override
            public JComponent getPreferredFocusedComponent() {
                List labeledComponents = UIUtil.findComponentsOfType((JComponent)this.getContentPanel(), LabeledComponent.class);
                String shortenLabelText = ExecutionBundle.message((String)"application.configuration.shorten.command.line.label", (Object[])new Object[0]).replace("\u001b", "");
                for (LabeledComponent component : labeledComponents) {
                    JComponent cp;
                    if (!shortenLabelText.equals(component.getRawText()) || !((cp = component.getComponent()) instanceof ComboBox)) continue;
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ComboPopup popup2 = ((ComboBox)cp).getPopup();
                        if (popup2 != null && cp.isShowing()) {
                            popup2.show();
                        }
                    });
                    return cp;
                }
                return super.getPreferredFocusedComponent();
            }
        };
        dialog2.setTitle(title);
        return dialog2;
    }

    @Override
    public Executor getExecutor() {
        return this.myExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/RunDialog";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/RunDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "editConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ApplyAction
    extends AbstractAction {
        public ApplyAction() {
            super(ExecutionBundle.message((String)"apply.action.name", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                RunDialog.this.myConfigurable.apply();
            }
            catch (ConfigurationException e) {
                Messages.showMessageDialog((Project)RunDialog.this.myProject, (String)e.getMessage(), (String)ExecutionBundle.message((String)"invalid.data.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            }
        }
    }
}

