/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.util.function.LongConsumer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class TransferToEDTQueueTestAction
extends DumbAwareAction {
    private JFrame frame;

    public TransferToEDTQueueTestAction() {
        super("Test TransferToEDTQueue performance");
    }

    public void actionPerformed(AnActionEvent event) {
        if (this.frame == null) {
            JLabel label2 = new JLabel("Set a threshold in ms to join subtasks");
            label2.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
            SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 200, 1);
            JSpinner spinner = new JSpinner(model);
            JButton button = new JButton("Start");
            button.addActionListener(started -> {
                button.setEnabled(false);
                spinner.setEnabled(false);
                label2.setText("Task started");
                new Task(1000L, model.getNumber().intValue(), time -> {
                    label2.setText("Task done in " + time + " ms");
                    spinner.setEnabled(true);
                    button.setEnabled(true);
                }).run();
            });
            int ten = JBUI.scale((int)10);
            JPanel panel2 = new JPanel(new BorderLayout(ten, 0));
            panel2.setBorder(JBUI.Borders.empty((int)10));
            panel2.add("Center", spinner);
            panel2.add("East", button);
            this.frame = new JFrame(event.getPresentation().getText());
            this.frame.setDefaultCloseOperation(2);
            this.frame.add("Center", panel2);
            this.frame.add("South", label2);
            this.frame.setAlwaysOnTop(true);
            this.frame.setResizable(false);
            this.frame.pack();
        }
        this.frame.setVisible(true);
        this.frame.requestFocus();
    }

    private static final class Task
    implements Runnable {
        private final TransferToEDTQueue<Runnable> queue;
        private final LongConsumer consumer;
        private final long startTime;
        private final long blockTime;
        private long blockCount;

        /*
         * WARNING - void declaration
         */
        Task(long blockTime, int threshold, @NotNull LongConsumer longConsumer) {
            void consumer;
            if (longConsumer == null) {
                Task.$$$reportNull$$$0(0);
            }
            this.queue = threshold <= 0 ? null : TransferToEDTQueue.createRunnableMerger((String)"TestAction", (int)threshold);
            this.consumer = consumer;
            this.startTime = System.nanoTime();
            this.blockTime = blockTime;
            this.blockCount = 5000000000L / blockTime;
        }

        @Override
        public void run() {
            long duration;
            --this.blockCount;
            long started = System.nanoTime();
            while ((duration = System.nanoTime() - started) <= this.blockTime) {
            }
            if (this.blockCount <= 0L) {
                this.consumer.accept((System.nanoTime() - this.startTime) / 1000000L);
            } else if (this.queue != null) {
                this.queue.offer((Object)this);
            } else {
                EventQueue.invokeLater(this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/diagnostic/TransferToEDTQueueTestAction$Task", "<init>"));
        }
    }
}

