/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.AbstractBundle;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.DefaultLiveTemplatesProvider;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.CompoundScheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import kotlin.Lazy;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="TemplateSettings", storages={@Storage(value="templates.xml"), @Storage(value="other.xml", deprecated=true)}, additionalExportFile="templates")
public class TemplateSettings
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(TemplateSettings.class);
    @NonNls
    public static final String USER_GROUP_NAME = "user";
    @NonNls
    private static final String TEMPLATE_SET = "templateSet";
    @NonNls
    private static final String GROUP = "group";
    @NonNls
    public static final String TEMPLATE = "template";
    public static final char SPACE_CHAR = ' ';
    public static final char TAB_CHAR = '\t';
    public static final char ENTER_CHAR = '\n';
    public static final char DEFAULT_CHAR = 'D';
    public static final char CUSTOM_CHAR = 'C';
    public static final char NONE_CHAR = 'N';
    @NonNls
    private static final String SPACE = "SPACE";
    @NonNls
    private static final String TAB = "TAB";
    @NonNls
    private static final String ENTER = "ENTER";
    @NonNls
    private static final String CUSTOM = "CUSTOM";
    @NonNls
    private static final String NONE = "NONE";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String SHORTCUT = "shortcut";
    @NonNls
    private static final String VARIABLE = "variable";
    @NonNls
    private static final String EXPRESSION = "expression";
    @NonNls
    private static final String DEFAULT_VALUE = "defaultValue";
    @NonNls
    private static final String ALWAYS_STOP_AT = "alwaysStopAt";
    @NonNls
    static final String CONTEXT = "context";
    @NonNls
    private static final String TO_REFORMAT = "toReformat";
    @NonNls
    private static final String TO_SHORTEN_FQ_NAMES = "toShortenFQNames";
    @NonNls
    private static final String USE_STATIC_IMPORT = "useStaticImport";
    @NonNls
    private static final String DEACTIVATED = "deactivated";
    @NonNls
    private static final String RESOURCE_BUNDLE = "resource-bundle";
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String ID = "id";
    static final String TEMPLATES_DIR_PATH = "templates";
    private final MultiMap<String, TemplateImpl> myTemplates;
    private final Map<String, Template> myTemplatesById;
    private final Map<TemplateKey, TemplateImpl> myDefaultTemplates;
    private int myMaxKeyLength;
    private final SchemeManager<TemplateGroup> mySchemeManager;
    private State myState;
    private TemplateKey myLastSelectedTemplate;

    public TemplateSettings(@NotNull SchemeManagerFactory schemeManagerFactory) {
        if (schemeManagerFactory == null) {
            TemplateSettings.$$$reportNull$$$0(0);
        }
        this.myTemplates = MultiMap.createLinked();
        this.myTemplatesById = new LinkedHashMap<String, Template>();
        this.myDefaultTemplates = new LinkedHashMap<TemplateKey, TemplateImpl>();
        this.myMaxKeyLength = 0;
        this.myState = new State();
        this.mySchemeManager = schemeManagerFactory.create(TEMPLATES_DIR_PATH, new BaseSchemeProcessor<TemplateGroup, TemplateGroup>(){

            @Override
            @Nullable
            public TemplateGroup readScheme(@NotNull Element element, boolean duringLoad) {
                TemplateGroup group;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((group = TemplateSettings.this.readTemplateFile(element, element.getAttributeValue(TemplateSettings.GROUP), false, false, this.getClass().getClassLoader())) != null) {
                    group.setModified(false);
                }
                return group;
            }

            @Override
            public void beforeReloaded(@NotNull SchemeManager<TemplateGroup> schemeManager2) {
                if (schemeManager2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (TemplateGroup group : schemeManager2.getAllSchemes()) {
                    schemeManager2.removeScheme(group);
                }
                TemplateSettings.this.myTemplates.clear();
                TemplateSettings.this.myDefaultTemplates.clear();
            }

            @Override
            public void reloaded(@NotNull SchemeManager<TemplateGroup> schemeManager2, @NotNull Collection<? extends TemplateGroup> groups) {
                if (schemeManager2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (groups == null) {
                    1.$$$reportNull$$$0(3);
                }
                for (TemplateGroup templateGroup : groups) {
                    for (TemplateImpl template : templateGroup.getElements()) {
                        TemplateSettings.this.addTemplateImpl(template);
                    }
                }
                TemplateSettings.this.loadDefaultLiveTemplates();
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull TemplateGroup template) {
                if (template == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (template.isModified()) {
                    SchemeState schemeState = SchemeState.POSSIBLY_CHANGED;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return schemeState;
                }
                for (TemplateImpl t : template.getElements()) {
                    if (!TemplateSettings.this.differsFromDefault(t)) continue;
                    SchemeState schemeState = SchemeState.POSSIBLY_CHANGED;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    return schemeState;
                }
                SchemeState schemeState = SchemeState.NON_PERSISTENT;
                if (schemeState == null) {
                    1.$$$reportNull$$$0(7);
                }
                return schemeState;
            }

            @NotNull
            public Element writeScheme(@NotNull TemplateGroup template) {
                if (template == null) {
                    1.$$$reportNull$$$0(8);
                }
                Element templateSetElement = new Element(TemplateSettings.TEMPLATE_SET);
                List elements = template.getElements();
                if (!elements.isEmpty()) {
                    boolean isGroupAttributeAdded = false;
                    Lazy<Map<String, TemplateContextType>> idToType = TemplateContext.getIdToType();
                    for (TemplateImpl t : elements) {
                        TemplateImpl defaultTemplate = TemplateSettings.this.getDefaultTemplate(t);
                        if (defaultTemplate != null && t.equals(defaultTemplate) && t.contextsEqual(defaultTemplate)) continue;
                        if (!isGroupAttributeAdded) {
                            isGroupAttributeAdded = true;
                            templateSetElement.setAttribute(TemplateSettings.GROUP, template.getName());
                        }
                        templateSetElement.addContent(TemplateSettings.serializeTemplate(t, defaultTemplate, idToType));
                    }
                }
                template.setModified(false);
                Element element = templateSetElement;
                if (element == null) {
                    1.$$$reportNull$$$0(9);
                }
                return element;
            }

            @Override
            public void initScheme(@NotNull TemplateGroup scheme2) {
                if (scheme2 == null) {
                    1.$$$reportNull$$$0(10);
                }
                for (TemplateImpl template : scheme2.getElements()) {
                    TemplateSettings.this.addTemplateImpl(template);
                }
            }

            @Override
            public void onSchemeAdded(@NotNull TemplateGroup scheme2) {
                if (scheme2 == null) {
                    1.$$$reportNull$$$0(11);
                }
                for (TemplateImpl template : scheme2.getElements()) {
                    TemplateSettings.this.addTemplateImpl(template);
                }
            }

            @Override
            public void onSchemeDeleted(@NotNull TemplateGroup scheme2) {
                if (scheme2 == null) {
                    1.$$$reportNull$$$0(12);
                }
                for (TemplateImpl template : scheme2.getElements()) {
                    TemplateSettings.this.removeTemplate(template);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "schemeManager";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "groups";
                        break;
                    }
                    case 4: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = TemplateSettings.TEMPLATE;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateSettings$1";
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateSettings$1";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getState";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "writeScheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "readScheme";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "beforeReloaded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "reloaded";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getState";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: {
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "writeScheme";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "initScheme";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "onSchemeAdded";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "onSchemeDeleted";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        for (TemplateGroup group : this.mySchemeManager.loadSchemes()) {
            for (TemplateImpl template : group.getElements()) {
                this.addTemplateImpl(template);
            }
        }
        this.loadDefaultLiveTemplates();
    }

    public static TemplateSettings getInstance() {
        return (TemplateSettings)ServiceManager.getService(TemplateSettings.class);
    }

    private boolean differsFromDefault(TemplateImpl t) {
        TemplateImpl def = this.getDefaultTemplate(t);
        return def == null || !t.equals(def) || !t.contextsEqual(def);
    }

    @Nullable
    public TemplateImpl getDefaultTemplate(TemplateImpl t) {
        return this.myDefaultTemplates.get(TemplateKey.keyOf(t));
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state2) {
        if (state2 == null) {
            TemplateSettings.$$$reportNull$$$0(1);
        }
        this.myState = state2;
        this.applyNewDeletedTemplates();
    }

    void applyNewDeletedTemplates() {
        for (TemplateKey templateKey : this.myState.deletedKeys) {
            if (templateKey.groupName == null) {
                for (TemplateImpl template : new ArrayList(this.myTemplates.get((Object)templateKey.key))) {
                    this.removeTemplate(template);
                }
                continue;
            }
            TemplateImpl toDelete = this.getTemplate(templateKey.key, templateKey.groupName);
            if (toDelete == null) continue;
            this.removeTemplate(toDelete);
        }
    }

    @Nullable
    public String getLastSelectedTemplateKey() {
        return this.myLastSelectedTemplate != null ? this.myLastSelectedTemplate.key : null;
    }

    @Nullable
    public String getLastSelectedTemplateGroup() {
        return this.myLastSelectedTemplate != null ? this.myLastSelectedTemplate.groupName : null;
    }

    public void setLastSelectedTemplate(@Nullable String group, @Nullable String key) {
        this.myLastSelectedTemplate = group == null ? null : new TemplateKey(group, key);
    }

    public Collection<? extends TemplateImpl> getTemplatesAsList() {
        return this.myTemplates.values();
    }

    public TemplateImpl[] getTemplates() {
        Collection all = this.myTemplates.values();
        return all.toArray(new TemplateImpl[0]);
    }

    public char getDefaultShortcutChar() {
        return this.myState.defaultShortcut;
    }

    public void setDefaultShortcutChar(char defaultShortcutChar) {
        this.myState.defaultShortcut = defaultShortcutChar;
    }

    public Collection<TemplateImpl> getTemplates(@NonNls String key) {
        return this.myTemplates.get((Object)key);
    }

    @Nullable
    public TemplateImpl getTemplate(@NonNls String key, String group) {
        Collection templates = this.myTemplates.get((Object)key);
        for (TemplateImpl template : templates) {
            if (!template.getGroupName().equals(group)) continue;
            return template;
        }
        return null;
    }

    public Template getTemplateById(@NonNls String id) {
        return this.myTemplatesById.get(id);
    }

    public int getMaxKeyLength() {
        return this.myMaxKeyLength;
    }

    public void addTemplate(Template template) {
        this.clearPreviouslyRegistered(template);
        this.addTemplateImpl(template);
        TemplateImpl templateImpl = (TemplateImpl)template;
        String groupName = templateImpl.getGroupName();
        TemplateGroup group = this.mySchemeManager.findSchemeByName(groupName);
        if (group == null) {
            group = new TemplateGroup(groupName);
            this.mySchemeManager.addScheme(group);
        }
        group.addElement(templateImpl);
    }

    private void clearPreviouslyRegistered(Template template) {
        TemplateImpl existing = this.getTemplate(template.getKey(), ((TemplateImpl)template).getGroupName());
        if (existing != null) {
            LOG.info("Template with key " + template.getKey() + " and id " + template.getId() + " already registered");
            TemplateGroup group = this.mySchemeManager.findSchemeByName(existing.getGroupName());
            if (group != null) {
                group.removeElement(existing);
                if (group.isEmpty()) {
                    this.mySchemeManager.removeScheme(group);
                }
            }
            this.myTemplates.remove((Object)template.getKey(), (Object)existing);
        }
    }

    private void addTemplateImpl(@NotNull Template template) {
        TemplateImpl templateImpl;
        if (template == null) {
            TemplateSettings.$$$reportNull$$$0(2);
        }
        if (this.getTemplate((templateImpl = (TemplateImpl)template).getKey(), templateImpl.getGroupName()) == null) {
            this.myTemplates.putValue((Object)template.getKey(), (Object)templateImpl);
        }
        this.myMaxKeyLength = Math.max(this.myMaxKeyLength, template.getKey().length());
        this.myState.deletedKeys.remove(TemplateKey.keyOf((TemplateImpl)template));
    }

    private void addTemplateById(Template template) {
        String id;
        if (!this.myTemplatesById.containsKey(template.getId()) && (id = template.getId()) != null) {
            this.myTemplatesById.put(id, template);
        }
    }

    public void removeTemplate(@NotNull Template template) {
        if (template == null) {
            TemplateSettings.$$$reportNull$$$0(3);
        }
        this.myTemplates.remove((Object)template.getKey(), (Object)((TemplateImpl)template));
        TemplateGroup group = this.mySchemeManager.findSchemeByName(((TemplateImpl)template).getGroupName());
        if (group != null) {
            group.removeElement((TemplateImpl)template);
            if (group.isEmpty()) {
                this.mySchemeManager.removeScheme(group);
            }
        }
    }

    @NotNull
    private static TemplateImpl createTemplate(@NotNull String key, String string, @NotNull String group, String description, @Nullable String shortcut, String id) {
        if (key == null) {
            TemplateSettings.$$$reportNull$$$0(4);
        }
        if (group == null) {
            TemplateSettings.$$$reportNull$$$0(5);
        }
        TemplateImpl template = new TemplateImpl(key, string, group, false);
        template.setId(id);
        template.setDescription(description);
        if (TAB.equals(shortcut)) {
            template.setShortcutChar('\t');
        } else if (ENTER.equals(shortcut)) {
            template.setShortcutChar('\n');
        } else if (SPACE.equals(shortcut)) {
            template.setShortcutChar(' ');
        } else if (NONE.equals(shortcut)) {
            template.setShortcutChar('N');
        } else {
            template.setShortcutChar('D');
        }
        TemplateImpl templateImpl = template;
        if (templateImpl == null) {
            TemplateSettings.$$$reportNull$$$0(6);
        }
        return templateImpl;
    }

    private void loadDefaultLiveTemplates() {
        try {
            for (DefaultLiveTemplatesProvider provider : (DefaultLiveTemplatesProvider[])DefaultLiveTemplatesProvider.EP_NAME.getExtensions()) {
                for (String defTemplate : provider.getDefaultLiveTemplateFiles()) {
                    this.readDefTemplate(provider, defTemplate, true);
                }
                try {
                    String[] hidden = provider.getHiddenLiveTemplateFiles();
                    if (hidden == null) continue;
                    for (String s : hidden) {
                        this.readDefTemplate(provider, s, false);
                    }
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void readDefTemplate(DefaultLiveTemplatesProvider provider, String defTemplate, boolean registerTemplate) throws JDOMException, InvalidDataException, IOException {
        TemplateGroup group;
        InputStream inputStream = DecodeDefaultsUtil.getDefaultsInputStream(provider, defTemplate);
        if (inputStream != null && (group = this.readTemplateFile(JdomKt.loadElement((InputStream)inputStream), TemplateSettings.getDefaultTemplateName(defTemplate), true, registerTemplate, provider.getClass().getClassLoader())) != null && group.getReplace() != null) {
            for (TemplateImpl template : this.myTemplates.get((Object)group.getReplace())) {
                this.removeTemplate(template);
            }
        }
    }

    private static String getDefaultTemplateName(String defTemplate) {
        return defTemplate.substring(defTemplate.lastIndexOf(47) + 1);
    }

    @Nullable
    private TemplateGroup readTemplateFile(@NotNull Element element, @NonNls String defGroupName, boolean isDefault, boolean registerTemplate, @NotNull ClassLoader classLoader) {
        Object existingScheme;
        if (element == null) {
            TemplateSettings.$$$reportNull$$$0(7);
        }
        if (classLoader == null) {
            TemplateSettings.$$$reportNull$$$0(8);
        }
        if (!TEMPLATE_SET.equals(element.getName())) {
            LOG.error("Ignore invalid template scheme: " + JDOMUtil.writeElement((Element)element));
            return null;
        }
        String groupName = element.getAttributeValue(GROUP);
        if (StringUtil.isEmpty((String)groupName)) {
            groupName = defGroupName;
        }
        Object result2 = new TemplateGroup(groupName, element.getAttributeValue("REPLACE"));
        LinkedHashMap<String, TemplateImpl> created = new LinkedHashMap<String, TemplateImpl>();
        for (Element child : element.getChildren(TEMPLATE)) {
            boolean defaultTemplateModified;
            TemplateImpl template;
            try {
                template = TemplateSettings.readTemplateFromElement(groupName, child, classLoader);
            }
            catch (Exception e) {
                LOG.warn("failed to load template " + element.getAttributeValue(NAME), (Throwable)e);
                continue;
            }
            if (isDefault) {
                this.myDefaultTemplates.put(TemplateKey.keyOf(template), template);
            }
            TemplateImpl existing = this.getTemplate(template.getKey(), template.getGroupName());
            boolean bl = defaultTemplateModified = isDefault && (this.myState.deletedKeys.contains(TemplateKey.keyOf(template)) || this.myTemplatesById.containsKey(template.getId()) || existing != null);
            if (!defaultTemplateModified) {
                created.put(template.getKey(), template);
            }
            if (!isDefault || existing == null) continue;
            existing.getTemplateContext().setDefaultContext(template.getTemplateContext());
        }
        if (registerTemplate && (existingScheme = this.mySchemeManager.findSchemeByName(((CompoundScheme)result2).getName())) != null) {
            result2 = existingScheme;
        }
        existingScheme = created.values().iterator();
        while (existingScheme.hasNext()) {
            TemplateImpl template = (TemplateImpl)existingScheme.next();
            if (registerTemplate) {
                this.clearPreviouslyRegistered(template);
                this.addTemplateImpl(template);
            }
            this.addTemplateById(template);
            ((CompoundScheme)result2).addElement(template);
        }
        if (registerTemplate && (existingScheme = this.mySchemeManager.findSchemeByName(((CompoundScheme)result2).getName())) == null && !((CompoundScheme)result2).isEmpty()) {
            this.mySchemeManager.addScheme((TemplateGroup)result2, false);
        }
        return ((CompoundScheme)result2).isEmpty() ? null : result2;
    }

    public static TemplateImpl readTemplateFromElement(String groupName, @NotNull Element element, @NotNull ClassLoader classLoader) {
        String description;
        if (element == null) {
            TemplateSettings.$$$reportNull$$$0(9);
        }
        if (classLoader == null) {
            TemplateSettings.$$$reportNull$$$0(10);
        }
        String name = element.getAttributeValue(NAME);
        String value = element.getAttributeValue(VALUE);
        String resourceBundle = element.getAttributeValue(RESOURCE_BUNDLE);
        String key = element.getAttributeValue(KEY);
        String id = element.getAttributeValue(ID);
        if (resourceBundle != null && key != null) {
            ResourceBundle bundle = AbstractBundle.getResourceBundle((String)resourceBundle, (ClassLoader)classLoader);
            description = bundle.getString(key);
        } else {
            description = element.getAttributeValue(DESCRIPTION);
        }
        String shortcut = element.getAttributeValue(SHORTCUT);
        TemplateImpl template = TemplateSettings.createTemplate(name, value, groupName, description, shortcut, id);
        template.setToReformat(Boolean.parseBoolean(element.getAttributeValue(TO_REFORMAT)));
        template.setToShortenLongNames(Boolean.parseBoolean(element.getAttributeValue(TO_SHORTEN_FQ_NAMES)));
        template.setDeactivated(Boolean.parseBoolean(element.getAttributeValue(DEACTIVATED)));
        String useStaticImport = element.getAttributeValue(USE_STATIC_IMPORT);
        if (useStaticImport != null) {
            template.setValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE, Boolean.parseBoolean(useStaticImport));
        }
        for (Element e : element.getChildren(VARIABLE)) {
            String variableName = e.getAttributeValue(NAME);
            String expression = e.getAttributeValue(EXPRESSION);
            String defaultValue = e.getAttributeValue(DEFAULT_VALUE);
            boolean isAlwaysStopAt = Boolean.parseBoolean(e.getAttributeValue(ALWAYS_STOP_AT));
            template.addVariable(variableName, expression, defaultValue, isAlwaysStopAt);
        }
        Element context = element.getChild(CONTEXT);
        if (context != null) {
            template.getTemplateContext().readTemplateContext(context);
        }
        return template;
    }

    @NotNull
    public static Element serializeTemplate(@NotNull TemplateImpl template, @Nullable TemplateImpl defaultTemplate, @NotNull Lazy<Map<String, TemplateContextType>> idToType) {
        if (template == null) {
            TemplateSettings.$$$reportNull$$$0(11);
        }
        if (idToType == null) {
            TemplateSettings.$$$reportNull$$$0(12);
        }
        Element element = new Element(TEMPLATE);
        String id = template.getId();
        if (id != null) {
            element.setAttribute(ID, id);
        }
        element.setAttribute(NAME, template.getKey());
        element.setAttribute(VALUE, template.getString());
        if (template.getShortcutChar() == '\t') {
            element.setAttribute(SHORTCUT, TAB);
        } else if (template.getShortcutChar() == '\n') {
            element.setAttribute(SHORTCUT, ENTER);
        } else if (template.getShortcutChar() == ' ') {
            element.setAttribute(SHORTCUT, SPACE);
        } else if (template.getShortcutChar() == 'N') {
            element.setAttribute(SHORTCUT, NONE);
        }
        if (template.getDescription() != null) {
            element.setAttribute(DESCRIPTION, template.getDescription());
        }
        element.setAttribute(TO_REFORMAT, Boolean.toString(template.isToReformat()));
        element.setAttribute(TO_SHORTEN_FQ_NAMES, Boolean.toString(template.isToShortenLongNames()));
        if (template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE) != Template.getDefaultValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE)) {
            element.setAttribute(USE_STATIC_IMPORT, Boolean.toString(template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE)));
        }
        if (template.isDeactivated()) {
            element.setAttribute(DEACTIVATED, Boolean.toString(true));
        }
        for (int i = 0; i < template.getVariableCount(); ++i) {
            Element variableElement = new Element(VARIABLE);
            variableElement.setAttribute(NAME, template.getVariableNameAt(i));
            variableElement.setAttribute(EXPRESSION, template.getExpressionStringAt(i));
            variableElement.setAttribute(DEFAULT_VALUE, template.getDefaultValueStringAt(i));
            variableElement.setAttribute(ALWAYS_STOP_AT, Boolean.toString(template.isAlwaysStopAt(i)));
            element.addContent(variableElement);
        }
        Element contextElement = template.getTemplateContext().writeTemplateContext(defaultTemplate == null ? null : defaultTemplate.getTemplateContext(), idToType);
        if (contextElement != null) {
            element.addContent(contextElement);
        }
        Element element2 = element;
        if (element2 == null) {
            TemplateSettings.$$$reportNull$$$0(13);
        }
        return element2;
    }

    public void setTemplates(@NotNull List<TemplateGroup> newGroups) {
        if (newGroups == null) {
            TemplateSettings.$$$reportNull$$$0(14);
        }
        this.myTemplates.clear();
        this.myState.deletedKeys.clear();
        for (TemplateImpl template : this.myDefaultTemplates.values()) {
            this.myState.deletedKeys.add(TemplateKey.keyOf(template));
        }
        this.myMaxKeyLength = 0;
        SmartList schemes = new SmartList();
        for (TemplateGroup group : newGroups) {
            if (group.isEmpty()) continue;
            schemes.add(group);
            for (TemplateImpl template : group.getElements()) {
                this.clearPreviouslyRegistered(template);
                this.addTemplateImpl(template);
            }
        }
        this.mySchemeManager.setSchemes((List<TemplateGroup>)schemes);
    }

    public List<TemplateGroup> getTemplateGroups() {
        return this.mySchemeManager.getAllSchemes();
    }

    public List<TemplateImpl> collectMatchingCandidates(String key, @Nullable Character shortcutChar, boolean hasArgument) {
        Collection<TemplateImpl> templates = this.getTemplates(key);
        ArrayList<TemplateImpl> candidates = new ArrayList<TemplateImpl>();
        for (TemplateImpl template : templates) {
            if (template.isDeactivated() || shortcutChar != null && this.getShortcutChar(template) != shortcutChar.charValue() || hasArgument && !template.hasArgument()) continue;
            candidates.add(template);
        }
        return candidates;
    }

    public char getShortcutChar(TemplateImpl template) {
        char c = template.getShortcutChar();
        return c == 'D' ? this.getDefaultShortcutChar() : c;
    }

    public List<TemplateKey> getDeletedTemplates() {
        return this.myState.deletedKeys;
    }

    public void reset() {
        this.myState.deletedKeys.clear();
        this.loadDefaultLiveTemplates();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeManagerFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = TEMPLATE;
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEY;
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = GROUP;
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateSettings";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplate";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateImpl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeTemplate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 6: 
            case 13: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readTemplateFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readTemplateFromElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "serializeTemplate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setTemplates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TemplateKey {
        private String groupName;
        private String key;

        public TemplateKey() {
        }

        private TemplateKey(String groupName, String key) {
            this.groupName = groupName;
            this.key = key;
        }

        public static TemplateKey keyOf(TemplateImpl template) {
            return new TemplateKey(template.getGroupName(), template.getKey());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateKey that = (TemplateKey)o;
            return Comparing.equal((String)this.groupName, (String)that.groupName) && Comparing.equal((String)this.key, (String)that.key);
        }

        public int hashCode() {
            int result2 = this.groupName != null ? this.groupName.hashCode() : 0;
            result2 = 31 * result2 + (this.key != null ? this.key.hashCode() : 0);
            return result2;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String toString() {
            return this.getKey() + "@" + this.getGroupName();
        }
    }

    static final class State {
        @OptionTag(nameAttribute="", valueAttribute="shortcut", converter=ShortcutConverter.class)
        public char defaultShortcut = (char)9;
        public List<TemplateKey> deletedKeys = new SmartList();

        State() {
        }
    }

    static final class ShortcutConverter
    extends Converter<Character> {
        ShortcutConverter() {
        }

        @Nullable
        public Character fromString(@NotNull String shortcut) {
            if (shortcut == null) {
                ShortcutConverter.$$$reportNull$$$0(0);
            }
            return Character.valueOf((char)(TemplateSettings.TAB.equals(shortcut) ? 9 : (TemplateSettings.ENTER.equals(shortcut) ? 10 : (TemplateSettings.CUSTOM.equals(shortcut) ? 67 : (TemplateSettings.NONE.equals(shortcut) ? 78 : 32)))));
        }

        @NotNull
        public String toString(@NotNull Character shortcut) {
            if (shortcut == null) {
                ShortcutConverter.$$$reportNull$$$0(1);
            }
            String string = shortcut.charValue() == '\t' ? TemplateSettings.TAB : (shortcut.charValue() == '\n' ? TemplateSettings.ENTER : (shortcut.charValue() == 'C' ? TemplateSettings.CUSTOM : (shortcut.charValue() == 'N' ? TemplateSettings.NONE : TemplateSettings.SPACE)));
            if (string == null) {
                ShortcutConverter.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = TemplateSettings.SHORTCUT;
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateSettings$ShortcutConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateSettings$ShortcutConverter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

