/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.CachedAnnotators;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitor;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionUtil;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultHighlightVisitorBasedInspection
extends GlobalSimpleInspectionTool {
    private final boolean highlightErrorElements;
    private final boolean runAnnotators;

    public DefaultHighlightVisitorBasedInspection(boolean highlightErrorElements, boolean runAnnotators) {
        this.highlightErrorElements = highlightErrorElements;
        this.runAnnotators = runAnnotators;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    public void checkFile(@NotNull PsiFile originalFile, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (originalFile == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(2);
        }
        if (problemsHolder == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(3);
        }
        if (globalContext == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(4);
        }
        if (problemDescriptionsProcessor == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(5);
        }
        for (Pair<PsiFile, HighlightInfo> pair : DefaultHighlightVisitorBasedInspection.runGeneralHighlighting(originalFile, this.highlightErrorElements, this.runAnnotators, problemsHolder.isOnTheFly())) {
            PsiElement element;
            PsiFile file2 = (PsiFile)pair.first;
            HighlightInfo info = (HighlightInfo)pair.second;
            TextRange range2 = new TextRange(info.startOffset, info.endOffset);
            for (element = file2.findElementAt(info.startOffset); element != null && !element.getTextRange().contains(range2); element = element.getParent()) {
            }
            if (element == null) {
                element = file2;
            }
            if (SuppressionUtil.inspectionResultSuppressed(element, (InspectionProfileEntry)this)) continue;
            GlobalInspectionUtil.createProblem(element, info, range2.shiftRight(-element.getNode().getStartOffset()), info.getProblemGroup(), manager, problemDescriptionsProcessor, globalContext);
        }
    }

    public static List<Pair<PsiFile, HighlightInfo>> runGeneralHighlighting(PsiFile file2, boolean highlightErrorElements, boolean runAnnotators, boolean isOnTheFly) {
        MyPsiElementVisitor visitor2 = new MyPsiElementVisitor(highlightErrorElements, runAnnotators, isOnTheFly);
        file2.accept((PsiElementVisitor)visitor2);
        return new ArrayList<Pair<PsiFile, HighlightInfo>>(visitor2.result);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GENERAL_GROUP_NAME;
        if (string == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyPsiElementVisitor
    extends PsiElementVisitor {
        private final boolean highlightErrorElements;
        private final boolean runAnnotators;
        private final List<Pair<PsiFile, HighlightInfo>> result = new ArrayList<Pair<PsiFile, HighlightInfo>>();

        public MyPsiElementVisitor(boolean highlightErrorElements, boolean runAnnotators, boolean isOnTheFly) {
            this.highlightErrorElements = highlightErrorElements;
            this.runAnnotators = runAnnotators;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitFile(PsiFile file2) {
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            Project project = file2.getProject();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
            if (document == null) {
                return;
            }
            DaemonProgressIndicator progress = new DaemonProgressIndicator();
            progress.start();
            try {
                TextEditorHighlightingPassRegistrarEx passRegistrarEx = TextEditorHighlightingPassRegistrarEx.getInstanceEx(project);
                List<TextEditorHighlightingPass> passes = passRegistrarEx.instantiateMainPasses(file2, document, HighlightInfoProcessor.getEmpty());
                List gpasses = ContainerUtil.collect(passes.iterator(), (FilteringIterator.InstanceOf)FilteringIterator.instanceOf(GeneralHighlightingPass.class));
                for (GeneralHighlightingPass gpass : gpasses) {
                    gpass.setHighlightVisitorProducer((NotNullProducer<HighlightVisitor[]>)((NotNullProducer)() -> {
                        gpass.incVisitorUsageCount(1);
                        DefaultHighlightVisitor visitor2 = new DefaultHighlightVisitor(project, this.highlightErrorElements, this.runAnnotators, true, (CachedAnnotators)ServiceManager.getService((Project)project, CachedAnnotators.class));
                        return new HighlightVisitor[]{visitor2};
                    }));
                }
                for (TextEditorHighlightingPass pass : gpasses) {
                    pass.doCollectInformation(progress);
                    List<HighlightInfo> infos = pass.getInfos();
                    for (HighlightInfo info : infos) {
                        if (info == null || info.getSeverity().compareTo(HighlightSeverity.INFORMATION) <= 0) continue;
                        this.result.add((Pair<PsiFile, HighlightInfo>)Pair.create((Object)file2, (Object)info));
                    }
                }
            }
            finally {
                progress.stop();
            }
        }
    }

    public static class SyntaxErrorInspection
    extends DefaultHighlightVisitorBasedInspection {
        public SyntaxErrorInspection() {
            super(true, false);
        }

        @Nls
        @NotNull
        public String getDisplayName() {
            if ("Syntax error" == null) {
                SyntaxErrorInspection.$$$reportNull$$$0(0);
            }
            return "Syntax error";
        }

        @NotNull
        public String getShortName() {
            if ("SyntaxError" == null) {
                SyntaxErrorInspection.$$$reportNull$$$0(1);
            }
            return "SyntaxError";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection$SyntaxErrorInspection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class AnnotatorBasedInspection
    extends DefaultHighlightVisitorBasedInspection {
        private static final String ANNOTATOR_SHORT_NAME = "Annotator";

        public AnnotatorBasedInspection() {
            super(false, true);
        }

        @Nls
        @NotNull
        public String getDisplayName() {
            String string = this.getShortName();
            if (string == null) {
                AnnotatorBasedInspection.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getShortName() {
            if (ANNOTATOR_SHORT_NAME == null) {
                AnnotatorBasedInspection.$$$reportNull$$$0(1);
            }
            return ANNOTATOR_SHORT_NAME;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection$AnnotatorBasedInspection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

