/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.XmlClosingTagInsertHandler;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlTagNameProvider;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class TagNameReferenceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static LookupElement[] getTagNameVariants(@NotNull XmlTag tag, String prefix) {
        if (tag == null) {
            TagNameReferenceCompletionProvider.$$$reportNull$$$0(0);
        }
        ArrayList<LookupElement> elements = new ArrayList<LookupElement>();
        for (XmlTagNameProvider tagNameProvider : (XmlTagNameProvider[])XmlTagNameProvider.EP_NAME.getExtensions()) {
            tagNameProvider.addTagNameVariants(elements, tag, prefix);
        }
        return elements.toArray(LookupElement.EMPTY_ARRAY);
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            TagNameReferenceCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            TagNameReferenceCompletionProvider.$$$reportNull$$$0(2);
        }
        LegacyCompletionContributor.processReferences(parameters2, result2, (PairConsumer<PsiReference, CompletionResultSet>)((PairConsumer)(reference, set2) -> {
            TagNameReference tagNameReference;
            if (reference instanceof TagNameReference) {
                TagNameReferenceCompletionProvider.collectCompletionVariants((TagNameReference)reference, (Consumer<LookupElement>)set2);
            } else if (reference instanceof SchemaPrefixReference && (tagNameReference = ((SchemaPrefixReference)reference).getTagNameReference()) != null && !tagNameReference.isStartTagFlag()) {
                set2.consume(TagNameReferenceCompletionProvider.createClosingTagLookupElement((XmlTag)tagNameReference.getElement(), true, tagNameReference.getNameElement()));
            }
        }));
    }

    public static void collectCompletionVariants(TagNameReference tagNameReference, Consumer<LookupElement> consumer) {
        PsiElement element = tagNameReference.getElement();
        if (element instanceof XmlTag) {
            if (!tagNameReference.isStartTagFlag()) {
                consumer.consume((Object)TagNameReferenceCompletionProvider.createClosingTagLookupElement((XmlTag)element, false, tagNameReference.getNameElement()));
            } else {
                XmlTag tag = (XmlTag)element;
                for (LookupElement variant : TagNameReferenceCompletionProvider.getTagNameVariants(tag, tag.getNamespacePrefix())) {
                    consumer.consume((Object)variant);
                }
            }
        }
    }

    public static LookupElement createClosingTagLookupElement(XmlTag tag, boolean includePrefix, ASTNode nameElement) {
        LookupElementBuilder builder2 = LookupElementBuilder.create((String)(includePrefix || !nameElement.getText().contains(":") ? tag.getName() : tag.getLocalName()));
        return LookupElementDecorator.withInsertHandler(TailTypeDecorator.withTail(AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)builder2), TailType.createSimpleTailType((char)'>')), (InsertHandler)XmlClosingTagInsertHandler.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/TagNameReferenceCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagNameVariants";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

