/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;

class ActionTracker {
    private boolean myActionsHappened;
    private final Editor myEditor;
    private final Project myProject;
    private boolean myIgnoreDocumentChanges;

    ActionTracker(Editor editor, Disposable parentDisposable) {
        this.myEditor = editor;
        this.myProject = editor.getProject();
        ActionManager.getInstance().addAnActionListener((AnActionListener)new AnActionListener.Adapter(){

            public void beforeEditorTyping(char c, DataContext dataContext) {
                ActionTracker.this.myActionsHappened = true;
            }

            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                ActionTracker.this.myActionsHappened = true;
            }
        }, parentDisposable);
        this.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!ActionTracker.this.myIgnoreDocumentChanges) {
                    ActionTracker.this.myActionsHappened = true;
                }
            }
        }, parentDisposable);
    }

    void ignoreCurrentDocumentChange() {
        final CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if (commandProcessor.getCurrentCommand() == null) {
            return;
        }
        this.myIgnoreDocumentChanges = true;
        commandProcessor.addCommandListener(new CommandListener(){

            public void commandFinished(CommandEvent event) {
                commandProcessor.removeCommandListener((CommandListener)this);
                ActionTracker.this.myIgnoreDocumentChanges = false;
            }
        });
    }

    boolean hasAnythingHappened() {
        return this.myActionsHappened || DumbService.getInstance((Project)this.myProject).isDumb() || this.myEditor.isDisposed() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid();
    }
}

