/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.XmlName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluatedXmlNameImpl
implements EvaluatedXmlName {
    private static final Key<CachedValue<Map<String, List<String>>>> NAMESPACE_PROVIDER_KEY = Key.create((String)"NamespaceProvider");
    private static final Map<EvaluatedXmlNameImpl, EvaluatedXmlNameImpl> ourInterned = ContainerUtil.newConcurrentMap();
    private final XmlName myXmlName;
    private final String myNamespaceKey;
    private final boolean myEqualToParent;

    private EvaluatedXmlNameImpl(@NotNull XmlName xmlName, @Nullable String namespaceKey, boolean equalToParent) {
        if (xmlName == null) {
            EvaluatedXmlNameImpl.$$$reportNull$$$0(0);
        }
        this.myXmlName = xmlName;
        this.myNamespaceKey = namespaceKey;
        this.myEqualToParent = equalToParent;
    }

    @NotNull
    public final String getLocalName() {
        String string = this.myXmlName.getLocalName();
        if (string == null) {
            EvaluatedXmlNameImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public final XmlName getXmlName() {
        return this.myXmlName;
    }

    @Override
    public final EvaluatedXmlName evaluateChildName(@NotNull XmlName name) {
        if (name == null) {
            EvaluatedXmlNameImpl.$$$reportNull$$$0(2);
        }
        String namespaceKey = name.getNamespaceKey();
        boolean equalToParent = Comparing.equal((String)namespaceKey, (String)this.myNamespaceKey);
        if (namespaceKey == null) {
            namespaceKey = this.myNamespaceKey;
        }
        return EvaluatedXmlNameImpl.createEvaluatedXmlName(name, namespaceKey, equalToParent);
    }

    public String toString() {
        return (this.myNamespaceKey == null ? "" : this.myNamespaceKey + " : ") + this.myXmlName.getLocalName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EvaluatedXmlNameImpl)) {
            return false;
        }
        EvaluatedXmlNameImpl that = (EvaluatedXmlNameImpl)o;
        if (this.myEqualToParent != that.myEqualToParent) {
            return false;
        }
        if (this.myNamespaceKey != null ? !this.myNamespaceKey.equals(that.myNamespaceKey) : that.myNamespaceKey != null) {
            return false;
        }
        return this.myXmlName.equals(that.myXmlName);
    }

    public int hashCode() {
        int result2 = this.myXmlName.hashCode();
        result2 = 31 * result2 + (this.myNamespaceKey != null ? this.myNamespaceKey.hashCode() : 0);
        result2 = 31 * result2 + (this.myEqualToParent ? 1 : 0);
        return result2;
    }

    public final boolean isNamespaceAllowed(DomFileElement element, String namespace) {
        if (this.myNamespaceKey == null || this.myEqualToParent) {
            return true;
        }
        XmlFile file = element.getFile();
        return EvaluatedXmlNameImpl.isNamespaceAllowed(namespace, this.getAllowedNamespaces(file));
    }

    @NotNull
    private List<String> getAllowedNamespaces(XmlFile file) {
        CachedValue value = (CachedValue)file.getUserData(NAMESPACE_PROVIDER_KEY);
        if (value == null) {
            value = CachedValuesManager.getManager(file.getProject()).createCachedValue(() -> {
                ConcurrentMap map = ConcurrentFactoryMap.createMap(key -> {
                    DomFileDescription<?> description = DomManager.getDomManager(file.getProject()).getDomFileDescription(file);
                    if (description == null) {
                        return Collections.emptyList();
                    }
                    return description.getAllowedNamespaces((String)key, file);
                });
                return CachedValueProvider.Result.create(map, file);
            }, false);
            file.putUserData(NAMESPACE_PROVIDER_KEY, value);
        }
        List list = (List)((Map)value.getValue()).get(this.myNamespaceKey);
        assert (list != null);
        List list2 = list;
        if (list2 == null) {
            EvaluatedXmlNameImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private static boolean isNamespaceAllowed(String namespace, List<String> list) {
        return list.contains(namespace) || StringUtil.isEmpty((String)namespace) && list.isEmpty();
    }

    @Override
    public final boolean isNamespaceAllowed(String namespace, XmlFile file, boolean qualified) {
        return this.myNamespaceKey == null || this.myEqualToParent && !qualified || EvaluatedXmlNameImpl.isNamespaceAllowed(namespace, this.getNamespaceList(file));
    }

    @Override
    @NotNull
    @NonNls
    public final String getNamespace(@NotNull XmlElement parentElement, XmlFile file) {
        List<String> strings;
        if (parentElement == null) {
            EvaluatedXmlNameImpl.$$$reportNull$$$0(4);
        }
        String xmlElementNamespace = EvaluatedXmlNameImpl.getXmlElementNamespace(parentElement);
        if (!(this.myNamespaceKey == null || this.myEqualToParent || (strings = this.getAllowedNamespaces(file)).isEmpty() || strings.contains(xmlElementNamespace))) {
            String string = strings.get(0);
            if (string == null) {
                EvaluatedXmlNameImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = xmlElementNamespace;
        if (string == null) {
            EvaluatedXmlNameImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static String getXmlElementNamespace(XmlElement parentElement) {
        if (parentElement instanceof XmlTag) {
            return ((XmlTag)parentElement).getNamespace();
        }
        if (parentElement instanceof XmlAttribute) {
            return ((XmlAttribute)parentElement).getNamespace();
        }
        if (parentElement instanceof XmlFile) {
            XmlTag tag;
            XmlDocument document = ((XmlFile)parentElement).getDocument();
            if (document != null && (tag = document.getRootTag()) != null) {
                return tag.getNamespace();
            }
            return "";
        }
        throw new AssertionError((Object)("Can't get namespace of " + parentElement));
    }

    private List<String> getNamespaceList(XmlFile file) {
        return this.getAllowedNamespaces(file);
    }

    public static EvaluatedXmlNameImpl createEvaluatedXmlName(@NotNull XmlName xmlName, @Nullable String namespaceKey, boolean equalToParent) {
        EvaluatedXmlNameImpl name;
        EvaluatedXmlNameImpl interned;
        if (xmlName == null) {
            EvaluatedXmlNameImpl.$$$reportNull$$$0(7);
        }
        if ((interned = ourInterned.get(name = new EvaluatedXmlNameImpl(xmlName, namespaceKey, equalToParent))) != null) {
            return interned;
        }
        ourInterned.put(name, name);
        return name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/EvaluatedXmlNameImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/EvaluatedXmlNameImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedNamespaces";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "evaluateChildName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluatedXmlName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

