/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.VcsAnnotation;
import com.intellij.openapi.vcs.annotate.VcsCacheableAnnotationProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsAnnotationCachedProxy
implements AnnotationProvider {
    private final VcsHistoryCache myCache;
    private final AbstractVcs myVcs;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.history.VcsAnnotationCachedProxy");
    private final AnnotationProvider myAnnotationProvider;

    public VcsAnnotationCachedProxy(@NotNull AbstractVcs vcs, @NotNull AnnotationProvider provider) {
        if (vcs == null) {
            VcsAnnotationCachedProxy.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            VcsAnnotationCachedProxy.$$$reportNull$$$0(1);
        }
        assert (provider instanceof VcsCacheableAnnotationProvider);
        this.myVcs = vcs;
        this.myCache = ProjectLevelVcsManager.getInstance(vcs.getProject()).getVcsHistoryCache();
        this.myAnnotationProvider = provider;
    }

    @Override
    public FileAnnotation annotate(final VirtualFile file) throws VcsException {
        DiffProvider diffProvider = this.myVcs.getDiffProvider();
        VcsRevisionNumber currentRevision = diffProvider.getCurrentRevision(file);
        return this.annotate(file, currentRevision, true, new ThrowableComputable<FileAnnotation, VcsException>(){

            public FileAnnotation compute() throws VcsException {
                return VcsAnnotationCachedProxy.this.myAnnotationProvider.annotate(file);
            }
        });
    }

    @Override
    public FileAnnotation annotate(final VirtualFile file, final VcsFileRevision revision) throws VcsException {
        return this.annotate(file, revision.getRevisionNumber(), false, new ThrowableComputable<FileAnnotation, VcsException>(){

            public FileAnnotation compute() throws VcsException {
                return VcsAnnotationCachedProxy.this.myAnnotationProvider.annotate(file, revision);
            }
        });
    }

    @Override
    public boolean isCaching() {
        return true;
    }

    private FileAnnotation annotate(VirtualFile file, VcsRevisionNumber revisionNumber, boolean currentRevision, ThrowableComputable<FileAnnotation, VcsException> delegate) throws VcsException {
        FileAnnotation fileAnnotation;
        AnnotationProvider annotationProvider = this.myAnnotationProvider;
        FilePath filePath2 = VcsUtil.getFilePath(file);
        VcsCacheableAnnotationProvider cacheableAnnotationProvider = (VcsCacheableAnnotationProvider)((Object)annotationProvider);
        VcsAnnotation vcsAnnotation = null;
        if (revisionNumber != null) {
            Object cachedData = this.myCache.get(filePath2, this.myVcs.getKeyInstanceMethod(), revisionNumber);
            vcsAnnotation = (VcsAnnotation)ObjectUtils.tryCast((Object)cachedData, VcsAnnotation.class);
        }
        if (vcsAnnotation != null) {
            VcsHistoryProvider historyProvider = this.myVcs.getVcsHistoryProvider();
            VcsAbstractHistorySession history = this.getHistory(revisionNumber, filePath2, historyProvider, vcsAnnotation.getFirstRevision());
            if (history == null) {
                return null;
            }
            ContentRevision fileContent = this.myVcs.getDiffProvider().createFileContent(revisionNumber, file);
            FileAnnotation restored = cacheableAnnotationProvider.restore(vcsAnnotation, history, fileContent.getContent(), currentRevision, revisionNumber);
            if (restored != null) {
                return restored;
            }
        }
        if ((vcsAnnotation = cacheableAnnotationProvider.createCacheable(fileAnnotation = (FileAnnotation)delegate.compute())) == null) {
            return fileAnnotation;
        }
        if (revisionNumber != null) {
            this.myCache.put(filePath2, this.myVcs.getKeyInstanceMethod(), revisionNumber, vcsAnnotation);
        }
        if (this.myVcs.getVcsHistoryProvider() instanceof VcsCacheableHistorySessionFactory) {
            this.loadHistoryInBackgroundToCache(revisionNumber, filePath2, vcsAnnotation);
        }
        return fileAnnotation;
    }

    private void loadHistoryInBackgroundToCache(VcsRevisionNumber revisionNumber, FilePath filePath2, VcsAnnotation vcsAnnotation) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.getHistory(revisionNumber, filePath2, this.myVcs.getVcsHistoryProvider(), vcsAnnotation.getFirstRevision());
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        });
    }

    private VcsAbstractHistorySession getHistory(VcsRevisionNumber revision, FilePath filePath2, VcsHistoryProvider historyProvider, @Nullable VcsRevisionNumber firstRevision) throws VcsException {
        VcsAbstractHistorySession sessionFor;
        boolean historyCacheSupported = historyProvider instanceof VcsCacheableHistorySessionFactory;
        if (historyCacheSupported) {
            VcsFileRevision recentRevision;
            VcsCacheableHistorySessionFactory cacheableHistorySessionFactory = (VcsCacheableHistorySessionFactory)((Object)historyProvider);
            Object cachedSession = this.myCache.getMaybePartial(filePath2, this.myVcs.getKeyInstanceMethod(), cacheableHistorySessionFactory);
            if (cachedSession != null && !((VcsAbstractHistorySession)cachedSession).getRevisionList().isEmpty() && (recentRevision = ((VcsAbstractHistorySession)cachedSession).getRevisionList().get(0)).getRevisionNumber().compareTo(revision) >= 0 && (firstRevision == null || ((VcsAbstractHistorySession)cachedSession).getHistoryAsMap().containsKey(firstRevision))) {
                return cachedSession;
            }
        }
        if ((sessionFor = firstRevision != null ? this.limitedHistory(filePath2, firstRevision) : (VcsAbstractHistorySession)historyProvider.createSessionFor(filePath2)) != null && historyCacheSupported) {
            VcsCacheableHistorySessionFactory cacheableHistorySessionFactory = (VcsCacheableHistorySessionFactory)((Object)historyProvider);
            FilePath correctedPath = cacheableHistorySessionFactory.getUsedFilePath(sessionFor);
            this.myCache.put(filePath2, correctedPath, this.myVcs.getKeyInstanceMethod(), sessionFor, cacheableHistorySessionFactory, firstRevision == null);
        }
        return sessionFor;
    }

    @Override
    public boolean isAnnotationValid(@NotNull VcsFileRevision rev) {
        if (rev == null) {
            VcsAnnotationCachedProxy.$$$reportNull$$$0(2);
        }
        return this.myAnnotationProvider.isAnnotationValid(rev);
    }

    private VcsAbstractHistorySession limitedHistory(FilePath filePath2, final @NotNull VcsRevisionNumber firstNumber) throws VcsException {
        if (firstNumber == null) {
            VcsAnnotationCachedProxy.$$$reportNull$$$0(3);
        }
        final VcsAbstractHistorySession[] result2 = new VcsAbstractHistorySession[1];
        final VcsException[] exc = new VcsException[1];
        try {
            this.myVcs.getVcsHistoryProvider().reportAppendableHistory(filePath2, new VcsAppendableHistorySessionPartner(){

                @Override
                public void reportCreatedEmptySession(VcsAbstractHistorySession session) {
                    result2[0] = session;
                }

                @Override
                public void acceptRevision(VcsFileRevision revision) {
                    result2[0].appendRevision(revision);
                    if (firstNumber.equals(revision.getRevisionNumber())) {
                        throw new ProcessCanceledException();
                    }
                }

                @Override
                public void reportException(VcsException exception) {
                    exc[0] = exception;
                }

                @Override
                public void finished() {
                }

                @Override
                public void beforeRefresh() {
                }

                @Override
                public void forceRefresh() {
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        if (exc[0] != null) {
            throw exc[0];
        }
        return result2[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rev";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstNumber";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/history/VcsAnnotationCachedProxy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnnotationValid";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "limitedHistory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

