/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.dialogs;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class AgreementDialog
extends DialogWrapper {
    private final Font myFont = new Font("SansSerif", 0, 12);
    private final ResourceBundle myBundle = ResourceBundle.getBundle("messages.LicenseCommonBundle");
    private final String myText;
    private JCheckBox myAcceptCheckBox;
    private boolean myOK = false;

    public AgreementDialog(String text, String programName) {
        super(null, false, true);
        this.getPeer().setAppIcons();
        this.myText = text;
        String title = programName != null ? MessageFormat.format(this.myBundle.getString("license.agreement.title.for"), programName) : this.myBundle.getString("license.agreement.title");
        this.setTitle(title);
        this.init();
        this.getOKAction().setEnabled(false);
    }

    @Override
    protected void doOKAction() {
        this.myOK = true;
        super.doOKAction();
    }

    @Override
    protected JComponent createNorthPanel() {
        String text = this.myBundle.getString("license.agreement.prompt");
        JLabel licensePrompt = new JLabel(text);
        licensePrompt.setFocusable(false);
        licensePrompt.setFont(this.myFont);
        licensePrompt.setBorder((Border)JBUI.Borders.empty((int)10, (int)20, (int)10, (int)5));
        return JBUI.Panels.simplePanel().addToCenter((Component)new JPanel()).addToLeft((Component)licensePrompt);
    }

    public boolean isAgreed() {
        return this.myOK && this.myAcceptCheckBox.isSelected();
    }

    @Override
    protected JComponent createCenterPanel() {
        JTextArea licenseTextArea = new JTextArea(this.myText, 20, 50);
        licenseTextArea.getCaret().setDot(0);
        licenseTextArea.setFont(this.myFont);
        licenseTextArea.setLineWrap(true);
        licenseTextArea.setWrapStyleWord(true);
        licenseTextArea.setEditable(false);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(licenseTextArea);
        JPanel agreePanel = new JPanel(new GridLayout(1, 1));
        agreePanel.setBorder((Border)JBUI.Borders.empty((int)10, (int)5, (int)5, (int)5));
        this.myAcceptCheckBox = new JCheckBox(this.myBundle.getString("license.agreement.accept.checkbox"));
        this.myAcceptCheckBox.setMnemonic(this.myAcceptCheckBox.getText().charAt(0));
        this.myAcceptCheckBox.setFont(this.myFont);
        agreePanel.add(this.myAcceptCheckBox);
        this.myAcceptCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AgreementDialog.this.getOKAction().setEnabled(AgreementDialog.this.myAcceptCheckBox.isSelected());
            }
        });
        return JBUI.Panels.simplePanel().addToCenter((Component)scrollPane).addToBottom((Component)agreePanel);
    }
}

