/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import org.jetbrains.annotations.NotNull;

public class UITheme {
    private String name;
    private boolean dark;
    private String author;
    private String id;
    private Map<String, Object> ui;
    private Map<String, Object> icons;

    private UITheme() {
    }

    public String getName() {
        return this.name;
    }

    public boolean isDark() {
        return this.dark;
    }

    public String getAuthor() {
        return this.author;
    }

    public static UITheme loadFromJson(InputStream stream, @NotNull String themeId) throws IOException {
        if (themeId == null) {
            UITheme.$$$reportNull$$$0(0);
        }
        UITheme theme = (UITheme)new ObjectMapper().readValue(stream, UITheme.class);
        theme.id = themeId;
        return theme;
    }

    public String getId() {
        return this.id;
    }

    public void applyProperties(UIDefaults defaults) {
        if (this.ui == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.ui.entrySet()) {
            UITheme.apply(entry.getKey(), entry.getValue(), defaults);
        }
    }

    private static void apply(String key, Object value, UIDefaults defaults) {
        if (value instanceof HashMap) {
            for (Map.Entry o : ((HashMap)value).entrySet()) {
                UITheme.apply(key + "." + (String)o.getKey(), o.getValue(), defaults);
            }
        } else {
            value = UITheme.parseValue(key, value.toString());
            if (key.startsWith("*.")) {
                String tail = key.substring(1);
                Object finalValue = value;
                ((UIDefaults)defaults.clone()).entrySet().forEach(e -> {
                    if (e.getKey() instanceof String && ((String)e.getKey()).endsWith(tail)) {
                        defaults.put(e.getKey(), finalValue);
                    }
                });
            } else {
                defaults.put(key, value);
            }
        }
    }

    public static Object parseValue(String key, @NotNull String value) {
        if (value == null) {
            UITheme.$$$reportNull$$$0(1);
        }
        if ("null".equals(value)) {
            return null;
        }
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        if (key.endsWith("Insets") || key.endsWith("padding")) {
            return UITheme.parseInsets(value);
        }
        if (key.endsWith("Border") || key.endsWith("border")) {
            try {
                if (StringUtil.split((String)value, (String)",").size() == 4) {
                    return new BorderUIResource.EmptyBorderUIResource(UITheme.parseInsets(value));
                }
                return Class.forName(value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Icon icon;
            if (key.endsWith("Size")) {
                return UITheme.parseSize(value);
            }
            if (key.endsWith("Width")) {
                return UITheme.getInteger(value);
            }
            if (key.endsWith("grayFilter")) {
                return UITheme.parseGrayFilter(value);
            }
            Color color = UITheme.parseColor(value);
            Integer invVal = UITheme.getInteger(value);
            Icon icon2 = icon = value.startsWith("AllIcons.") ? IconLoader.getIcon((String)value) : null;
            if (color != null) {
                return new ColorUIResource(color);
            }
            if (invVal != null) {
                return invVal;
            }
            if (icon != null) {
                return new IconUIResource(icon);
            }
        }
        return value;
    }

    private static Insets parseInsets(String value) {
        List numbers = StringUtil.split((String)value, (String)",");
        return new JBInsets(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1)), Integer.parseInt((String)numbers.get(2)), Integer.parseInt((String)numbers.get(3))).asUIResource();
    }

    private static UIUtil.GrayFilter parseGrayFilter(String value) {
        List numbers = StringUtil.split((String)value, (String)",");
        return new UIUtil.GrayFilter(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1)), Integer.parseInt((String)numbers.get(2))).asUIResource();
    }

    private static Color parseColor(String value) {
        if (value != null && value.length() == 8) {
            Color color = ColorUtil.fromHex((String)value.substring(0, 6));
            try {
                int alpha = Integer.parseInt(value.substring(6, 8), 16);
                return new ColorUIResource(new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return ColorUtil.fromHex((String)value, null);
    }

    private static Integer getInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Dimension parseSize(String value) {
        List numbers = StringUtil.split((String)value, (String)",");
        return new JBDimension(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1))).asUIResource();
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setDark(boolean dark) {
        this.dark = dark;
    }

    private void setAuthor(String author) {
        this.author = author;
    }

    private void setUi(Map<String, Object> ui) {
        this.ui = ui;
    }

    private void setIcons(Map<String, Object> icons) {
        this.icons = icons;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/ui/UITheme";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadFromJson";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

