/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommandLineState
implements RunProfileState {
    private TextConsoleBuilder myConsoleBuilder;
    private final ExecutionEnvironment myEnvironment;

    protected CommandLineState(ExecutionEnvironment environment) {
        this.myEnvironment = environment;
        if (this.myEnvironment != null) {
            Project project = this.myEnvironment.getProject();
            GlobalSearchScope searchScope = SearchScopeProvider.createSearchScope(project, this.myEnvironment.getRunProfile());
            this.myConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project, searchScope);
        }
    }

    public ExecutionEnvironment getEnvironment() {
        return this.myEnvironment;
    }

    public RunnerSettings getRunnerSettings() {
        return this.myEnvironment.getRunnerSettings();
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        ExecutionTarget executionTarget = this.myEnvironment.getExecutionTarget();
        if (executionTarget == null) {
            CommandLineState.$$$reportNull$$$0(0);
        }
        return executionTarget;
    }

    public void addConsoleFilters(Filter ... filters) {
        this.myConsoleBuilder.filters(filters);
    }

    @Override
    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            CommandLineState.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            CommandLineState.$$$reportNull$$$0(2);
        }
        ProcessHandler processHandler = this.startProcess();
        ConsoleView console = this.createConsole(executor);
        if (console != null) {
            console.attachToProcess(processHandler);
        }
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult(console, processHandler, this.createActions(console, processHandler, executor));
        if (defaultExecutionResult == null) {
            CommandLineState.$$$reportNull$$$0(3);
        }
        return defaultExecutionResult;
    }

    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor) throws ExecutionException {
        TextConsoleBuilder builder;
        if (executor == null) {
            CommandLineState.$$$reportNull$$$0(4);
        }
        return (builder = this.getConsoleBuilder()) != null ? builder.getConsole() : null;
    }

    @NotNull
    protected abstract ProcessHandler startProcess() throws ExecutionException;

    @NotNull
    protected AnAction[] createActions(ConsoleView console, ProcessHandler processHandler) {
        AnAction[] anActionArray = this.createActions(console, processHandler, null);
        if (anActionArray == null) {
            CommandLineState.$$$reportNull$$$0(5);
        }
        return anActionArray;
    }

    @NotNull
    protected AnAction[] createActions(ConsoleView console, ProcessHandler processHandler, Executor executor) {
        if (console == null || !console.canPause() || executor != null && !DefaultRunExecutor.EXECUTOR_ID.equals(executor.getId())) {
            if (AnAction.EMPTY_ARRAY == null) {
                CommandLineState.$$$reportNull$$$0(6);
            }
            return AnAction.EMPTY_ARRAY;
        }
        AnAction[] anActionArray = new AnAction[]{new PauseOutputAction(console, processHandler)};
        if (anActionArray == null) {
            CommandLineState.$$$reportNull$$$0(7);
        }
        return anActionArray;
    }

    public TextConsoleBuilder getConsoleBuilder() {
        return this.myConsoleBuilder;
    }

    public void setConsoleBuilder(TextConsoleBuilder consoleBuilder) {
        this.myConsoleBuilder = consoleBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/CommandLineState";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionTarget";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/CommandLineState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class PauseOutputAction
    extends ToggleAction
    implements DumbAware {
        private final ConsoleView myConsole;
        private final ProcessHandler myProcessHandler;

        public PauseOutputAction(ConsoleView console, ProcessHandler processHandler) {
            super(ExecutionBundle.message("run.configuration.pause.output.action.name", new Object[0]), null, AllIcons.Actions.Pause);
            this.myConsole = console;
            this.myProcessHandler = processHandler;
        }

        @Override
        public boolean isSelected(AnActionEvent event) {
            return this.myConsole.isOutputPaused();
        }

        @Override
        public void setSelected(AnActionEvent event, boolean flag) {
            this.myConsole.setOutputPaused(flag);
            ApplicationManager.getApplication().invokeLater(() -> this.update(event));
        }

        @Override
        public void update(@NotNull AnActionEvent event) {
            boolean isRunning;
            if (event == null) {
                PauseOutputAction.$$$reportNull$$$0(0);
            }
            super.update(event);
            Presentation presentation = event.getPresentation();
            boolean bl = isRunning = this.myProcessHandler != null && !this.myProcessHandler.isProcessTerminated();
            if (isRunning) {
                presentation.setEnabled(true);
            } else {
                if (!this.myConsole.canPause()) {
                    presentation.setEnabled(false);
                    return;
                }
                if (!this.myConsole.hasDeferredOutput()) {
                    presentation.setEnabled(false);
                } else {
                    presentation.setEnabled(true);
                    this.myConsole.performWhenNoDeferredOutput(() -> {
                        if (event == null) {
                            PauseOutputAction.$$$reportNull$$$0(1);
                        }
                        this.update(event);
                    });
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/execution/configurations/CommandLineState$PauseOutputAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$update$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

