/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.ZipUtil");

    private ZipUtil() {
    }

    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file, @NotNull String relativeName, @Nullable Set<String> writtenItemRelativePaths, @Nullable FileFilter fileFilter) throws IOException {
        if (zos == null) {
            ZipUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ZipUtil.$$$reportNull$$$0(1);
        }
        if (relativeName == null) {
            ZipUtil.$$$reportNull$$$0(2);
        }
        return ZipUtil.addFileToZip(zos, file, relativeName, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file, @NotNull String relativeName, @Nullable Set<String> writtenItemRelativePaths, @Nullable FileFilter fileFilter, @NotNull FileContentProcessor contentProcessor) throws IOException {
        if (zos == null) {
            ZipUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ZipUtil.$$$reportNull$$$0(4);
        }
        if (relativeName == null) {
            ZipUtil.$$$reportNull$$$0(5);
        }
        if (contentProcessor == null) {
            ZipUtil.$$$reportNull$$$0(6);
        }
        while (!relativeName.isEmpty() && relativeName.charAt(0) == '/') {
            relativeName = relativeName.substring(1);
        }
        boolean isDir = file.isDirectory();
        if (isDir && !StringUtil.endsWithChar(relativeName, '/')) {
            relativeName = relativeName + "/";
        }
        if (fileFilter != null && !FileUtil.isFilePathAcceptable(file, fileFilter)) {
            return false;
        }
        if (writtenItemRelativePaths != null && !writtenItemRelativePaths.add(relativeName)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add " + file + " as " + relativeName);
        }
        long size = isDir ? 0L : file.length();
        ZipEntry e = new ZipEntry(relativeName);
        e.setTime(file.lastModified());
        if (size == 0L) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        }
        zos.putNextEntry(e);
        if (!isDir) {
            InputStream is = contentProcessor.getContent(file);
            try {
                FileUtil.copy(is, zos);
            }
            finally {
                is.close();
            }
        }
        zos.closeEntry();
        return true;
    }

    public static boolean addFileOrDirRecursively(@NotNull ZipOutputStream jarOutputStream, @Nullable File jarFile, @NotNull File file, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        if (jarOutputStream == null) {
            ZipUtil.$$$reportNull$$$0(7);
        }
        if (file == null) {
            ZipUtil.$$$reportNull$$$0(8);
        }
        if (relativePath == null) {
            ZipUtil.$$$reportNull$$$0(9);
        }
        if (file.isDirectory()) {
            return ZipUtil.addDirToZipRecursively(jarOutputStream, jarFile, file, relativePath, fileFilter, writtenItemRelativePaths);
        }
        return ZipUtil.addFileToZip(jarOutputStream, file, relativePath, writtenItemRelativePaths, fileFilter);
    }

    public static boolean addDirToZipRecursively(@NotNull ZipOutputStream outputStream, @Nullable File jarFile, @NotNull File dir, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        File[] children;
        if (outputStream == null) {
            ZipUtil.$$$reportNull$$$0(10);
        }
        if (dir == null) {
            ZipUtil.$$$reportNull$$$0(11);
        }
        if (relativePath == null) {
            ZipUtil.$$$reportNull$$$0(12);
        }
        if (jarFile != null && FileUtil.isAncestor(dir, jarFile, false)) {
            return false;
        }
        if (!relativePath.isEmpty()) {
            ZipUtil.addFileToZip(outputStream, dir, relativePath, writtenItemRelativePaths, fileFilter);
        }
        if ((children = dir.listFiles()) != null) {
            for (File child : children) {
                String childRelativePath = (relativePath.isEmpty() ? "" : relativePath + "/") + child.getName();
                ZipUtil.addFileOrDirRecursively(outputStream, jarFile, child, childRelativePath, fileFilter, writtenItemRelativePaths);
            }
        }
        return true;
    }

    public static void extract(@NotNull File file, @NotNull File outputDir, @Nullable FilenameFilter filter) throws IOException {
        if (file == null) {
            ZipUtil.$$$reportNull$$$0(13);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(14);
        }
        new Decompressor.Zip(file).filter(FileFilterAdapter.wrap(outputDir, filter)).extract(outputDir);
    }

    public static void extract(@NotNull File file, @NotNull File outputDir, @Nullable FilenameFilter filter, boolean overwrite) throws IOException {
        if (file == null) {
            ZipUtil.$$$reportNull$$$0(15);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(16);
        }
        new Decompressor.Zip(file).filter(FileFilterAdapter.wrap(outputDir, filter)).overwrite(overwrite).extract(outputDir);
    }

    @NotNull
    public static File newFileForEntry(@NotNull File outputDir, @NotNull String entryName) throws IOException {
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(17);
        }
        if (entryName == null) {
            ZipUtil.$$$reportNull$$$0(18);
        }
        if (entryName.contains("..") && ArrayUtil.contains("..", entryName.split("[/\\\\]"))) {
            throw new IOException("Invalid entry name: " + entryName);
        }
        File file = new File(outputDir, entryName);
        if (file == null) {
            ZipUtil.$$$reportNull$$$0(19);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipContainsFolder(File zip) throws IOException {
        ZipFile zipFile = new ZipFile(zip);
        try {
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry zipEntry = en.nextElement();
                if (zipEntry.getName().indexOf(47) < 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFile(@NotNull File srcFile, @NotNull File zipFile) throws IOException {
        if (srcFile == null) {
            ZipUtil.$$$reportNull$$$0(20);
        }
        if (zipFile == null) {
            ZipUtil.$$$reportNull$$$0(21);
        }
        FileInputStream is = new FileInputStream(srcFile);
        try {
            ZipOutputStream os = new ZipOutputStream(new FileOutputStream(zipFile));
            try {
                os.putNextEntry(new ZipEntry(srcFile.getName()));
                FileUtilRt.copy(is, os);
                os.closeEntry();
            }
            finally {
                os.close();
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    @ApiStatus.ScheduledForRemoval(inVersion="2020")
    public static void extract(@NotNull ZipFile zip, @NotNull File outputDir, @Nullable FilenameFilter filter) throws IOException {
        if (zip == null) {
            ZipUtil.$$$reportNull$$$0(22);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(23);
        }
        new Decompressor.Zip(new File(zip.getName())).filter(FileFilterAdapter.wrap(outputDir, filter)).extract(outputDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.ScheduledForRemoval(inVersion="2020")
    public static void extractEntry(@NotNull ZipEntry entry, @NotNull InputStream inputStream, @NotNull File outputDir, boolean overwrite) throws IOException {
        block10: {
            if (entry == null) {
                ZipUtil.$$$reportNull$$$0(24);
            }
            if (inputStream == null) {
                ZipUtil.$$$reportNull$$$0(25);
            }
            if (outputDir == null) {
                ZipUtil.$$$reportNull$$$0(26);
            }
            File outputFile = ZipUtil.newFileForEntry(outputDir, entry.getName());
            try {
                if (entry.isDirectory()) {
                    FileUtil.createDirectory(outputFile);
                    break block10;
                }
                if (outputFile.exists() && !overwrite) break block10;
                FileUtil.createParentDirs(outputFile);
                FileOutputStream os = new FileOutputStream(outputFile);
                try {
                    FileUtilRt.copy(inputStream, os);
                }
                finally {
                    os.close();
                }
            }
            finally {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.ScheduledForRemoval(inVersion="2019")
    public static boolean isZipContainsEntry(File zip, String relativePath) throws IOException {
        ZipFile zipFile = new ZipFile(zip);
        try {
            boolean bl = zipFile.getEntry(relativePath) != null;
            return bl;
        }
        finally {
            zipFile.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zos";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarOutputStream";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/ZipUtil";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/ZipUtil";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "newFileForEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFileToZip";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addFileOrDirRecursively";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addDirToZipRecursively";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newFileForEntry";
                break;
            }
            case 19: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "compressFile";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "extractEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileFilterAdapter
    implements Condition<String> {
        private final File myOutputDir;
        private final FilenameFilter myFilter;

        private static FileFilterAdapter wrap(File outputDir, FilenameFilter filter) {
            return filter == null ? null : new FileFilterAdapter(outputDir, filter);
        }

        private FileFilterAdapter(File outputDir, FilenameFilter filter) {
            this.myOutputDir = outputDir;
            this.myFilter = filter;
        }

        @Override
        public boolean value(String entryName) {
            File outputFile = new File(this.myOutputDir, entryName);
            return this.myFilter.accept(outputFile.getParentFile(), outputFile.getName());
        }
    }

    public static interface FileContentProcessor {
        public static final FileContentProcessor STANDARD = new FileContentProcessor(){

            @Override
            public InputStream getContent(File file) throws IOException {
                return new FileInputStream(file);
            }
        };

        public InputStream getContent(File var1) throws IOException;
    }
}

