/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Decompressor<Stream> {
    private Condition<String> myFilter = null;
    private boolean myOverwrite = true;
    private Consumer<File> myConsumer;

    public Decompressor<Stream> filter(@Nullable Condition<String> filter) {
        this.myFilter = filter;
        return this;
    }

    public Decompressor<Stream> overwrite(boolean overwrite) {
        this.myOverwrite = overwrite;
        return this;
    }

    public Decompressor<Stream> postprocessor(@Nullable Consumer<File> consumer) {
        this.myConsumer = consumer;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extract(@NotNull File outputDir) throws IOException {
        if (outputDir == null) {
            Decompressor.$$$reportNull$$$0(0);
        }
        Stream stream = this.openStream();
        try {
            Entry entry;
            while ((entry = this.nextEntry(stream)) != null) {
                String name = entry.name;
                if (this.myFilter != null && !this.myFilter.value(name)) continue;
                File outputFile = ZipUtil.newFileForEntry(outputDir, name);
                if (entry.isDirectory) {
                    FileUtil.createDirectory(outputFile);
                } else if (!outputFile.exists() || this.myOverwrite) {
                    InputStream inputStream = this.openEntryStream(stream, entry);
                    try {
                        FileUtil.createParentDirs(outputFile);
                        FileOutputStream outputStream = new FileOutputStream(outputFile);
                        try {
                            FileUtil.copy(inputStream, outputStream);
                        }
                        finally {
                            outputStream.close();
                        }
                    }
                    finally {
                        this.closeEntryStream(inputStream);
                    }
                }
                if (this.myConsumer == null) continue;
                this.myConsumer.consume(outputFile);
            }
        }
        finally {
            this.closeStream(stream);
        }
    }

    protected Decompressor() {
    }

    protected abstract Stream openStream() throws IOException;

    protected abstract Entry nextEntry(Stream var1) throws IOException;

    protected abstract InputStream openEntryStream(Stream var1, Entry var2) throws IOException;

    protected abstract void closeEntryStream(InputStream var1) throws IOException;

    protected abstract void closeStream(Stream var1) throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDir", "com/intellij/util/io/Decompressor", "extract"));
    }

    private static class Entry {
        private final String name;
        private final boolean isDirectory;

        public Entry(String name, boolean isDirectory) {
            this.name = name;
            this.isDirectory = isDirectory;
        }
    }

    public static class Zip
    extends Decompressor<ZipFile> {
        private final File mySource;
        private Enumeration<? extends ZipEntry> myEntries;
        private ZipEntry myEntry;

        public Zip(@NotNull File file) {
            if (file == null) {
                Zip.$$$reportNull$$$0(0);
            }
            this.mySource = file;
        }

        @Override
        protected ZipFile openStream() throws IOException {
            return new ZipFile(this.mySource);
        }

        @Override
        protected Entry nextEntry(ZipFile zip) {
            if (this.myEntries == null) {
                this.myEntries = zip.entries();
            }
            this.myEntry = this.myEntries.hasMoreElements() ? this.myEntries.nextElement() : null;
            return this.myEntry == null ? null : new Entry(this.myEntry.getName(), this.myEntry.isDirectory());
        }

        @Override
        protected InputStream openEntryStream(ZipFile zip, Entry entry) throws IOException {
            return zip.getInputStream(this.myEntry);
        }

        @Override
        protected void closeEntryStream(InputStream stream) throws IOException {
            stream.close();
        }

        @Override
        protected void closeStream(ZipFile zip) throws IOException {
            zip.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/Decompressor$Zip", "<init>"));
        }
    }

    public static class Tar
    extends Decompressor<TarArchiveInputStream> {
        private final Object mySource;

        public Tar(@NotNull File file) {
            if (file == null) {
                Tar.$$$reportNull$$$0(0);
            }
            this.mySource = file;
        }

        public Tar(@NotNull TarArchiveInputStream stream) {
            if (stream == null) {
                Tar.$$$reportNull$$$0(1);
            }
            this.mySource = stream;
        }

        @Override
        protected TarArchiveInputStream openStream() throws IOException {
            return this.mySource instanceof TarArchiveInputStream ? (TarArchiveInputStream)this.mySource : new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream((File)this.mySource)));
        }

        @Override
        protected Entry nextEntry(TarArchiveInputStream tar) throws IOException {
            TarArchiveEntry tarEntry = tar.getNextTarEntry();
            return tarEntry == null ? null : new Entry(tarEntry.getName(), tarEntry.isDirectory());
        }

        @Override
        protected InputStream openEntryStream(TarArchiveInputStream stream, Entry entry) {
            return stream;
        }

        @Override
        protected void closeEntryStream(InputStream stream) {
        }

        @Override
        protected void closeStream(TarArchiveInputStream tar) throws IOException {
            if (this.mySource instanceof File) {
                tar.close();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stream";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/Decompressor$Tar";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

