/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IntIntFunction;
import com.intellij.util.containers.Convertor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectUtils {
    public static final Object NULL = ObjectUtils.sentinel("ObjectUtils.NULL");

    private ObjectUtils() {
    }

    public static Object sentinel(String name) {
        return new Sentinel(name);
    }

    @NotNull
    public static <T> T assertNotNull(@Nullable T t) {
        T t2 = ObjectUtils.notNull(t);
        if (t2 == null) {
            ObjectUtils.$$$reportNull$$$0(0);
        }
        return t2;
    }

    public static <T> void assertAllElementsNotNull(@NotNull T[] array) {
        if (array == null) {
            ObjectUtils.$$$reportNull$$$0(1);
        }
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            if (t != null) continue;
            throw new NullPointerException("Element [" + i + "] is null");
        }
    }

    @Contract(value="!null, _ -> !null; _, !null -> !null; _, _ -> null", pure=true)
    public static <T> T chooseNotNull(@Nullable T t1, @Nullable T t2) {
        return t1 == null ? t2 : t1;
    }

    @Contract(value="!null, _ -> !null; _, !null -> !null; _, _ -> null", pure=true)
    public static <T> T coalesce(@Nullable T t1, @Nullable T t2) {
        return ObjectUtils.chooseNotNull(t1, t2);
    }

    @Contract(value="!null, _, _ -> !null; _, !null, _ -> !null; _, _, !null -> !null; _,_,_ -> null", pure=true)
    public static <T> T coalesce(@Nullable T t1, @Nullable T t2, @Nullable T t3) {
        return t1 != null ? t1 : (t2 != null ? t2 : t3);
    }

    @Nullable
    public static <T> T coalesce(@Nullable Iterable<T> o) {
        if (o == null) {
            return null;
        }
        for (T t : o) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @NotNull
    public static <T> T notNull(@Nullable T value) {
        T t = ObjectUtils.notNull(value, value);
        if (t == null) {
            ObjectUtils.$$$reportNull$$$0(2);
        }
        return t;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T notNull(@Nullable T value, @NotNull T defaultValue) {
        if (defaultValue == null) {
            ObjectUtils.$$$reportNull$$$0(3);
        }
        T t = value == null ? defaultValue : value;
        if (t == null) {
            ObjectUtils.$$$reportNull$$$0(4);
        }
        return t;
    }

    @NotNull
    public static <T> T notNull(@Nullable T value, @NotNull NotNullFactory<T> defaultValue) {
        if (defaultValue == null) {
            ObjectUtils.$$$reportNull$$$0(5);
        }
        T t = value == null ? defaultValue.create() : value;
        if (t == null) {
            ObjectUtils.$$$reportNull$$$0(6);
        }
        return t;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T> T tryCast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (clazz == null) {
            ObjectUtils.$$$reportNull$$$0(7);
        }
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        return null;
    }

    @Nullable
    public static <T, S> S doIfCast(@Nullable Object obj, @NotNull Class<T> clazz, Convertor<T, S> convertor) {
        if (clazz == null) {
            ObjectUtils.$$$reportNull$$$0(8);
        }
        if (clazz.isInstance(obj)) {
            return convertor.convert(obj);
        }
        return null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T, S> S doIfNotNull(@Nullable T obj, @NotNull Function<? super T, ? extends S> function) {
        if (function == null) {
            ObjectUtils.$$$reportNull$$$0(9);
        }
        return obj == null ? null : (S)function.fun((T)obj);
    }

    public static <T> void consumeIfCast(@Nullable Object obj, @NotNull Class<T> clazz, Consumer<T> consumer) {
        if (clazz == null) {
            ObjectUtils.$$$reportNull$$$0(10);
        }
        if (clazz.isInstance(obj)) {
            consumer.consume(obj);
        }
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T> T nullizeByCondition(@Nullable T obj, @NotNull Condition<T> condition) {
        if (condition == null) {
            ObjectUtils.$$$reportNull$$$0(11);
        }
        if (condition.value(obj)) {
            return null;
        }
        return obj;
    }

    public static int binarySearch(int fromIndex, int toIndex, @NotNull IntIntFunction test) {
        if (test == null) {
            ObjectUtils.$$$reportNull$$$0(12);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = test.fun(mid);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ObjectUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "assertNotNull";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ObjectUtils";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "notNull";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "assertAllElementsNotNull";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notNull";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryCast";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doIfCast";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doIfNotNull";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "consumeIfCast";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "nullizeByCondition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "binarySearch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Sentinel {
        private final String myName;

        public Sentinel(String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }
}

