/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.paint;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBUI;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaintUtil {
    /*
     * WARNING - void declaration
     */
    public static ParityMode getParityMode(double usrValue, @NotNull Graphics2D graphics2D) {
        void g;
        if (graphics2D == null) {
            PaintUtil.$$$reportNull$$$0(0);
        }
        return PaintUtil.getParityMode(usrValue, JBUI.ScaleContext.create((Graphics2D)g), null);
    }

    /*
     * WARNING - void declaration
     */
    public static ParityMode getParityMode(double usrValue, @NotNull JBUI.ScaleContext ctx, @Nullable RoundingMode roundingMode) {
        void rm;
        if (ctx == null) {
            PaintUtil.$$$reportNull$$$0(1);
        }
        int devValue = PaintUtil.devValue(usrValue, PaintUtil.getScale(ctx), (RoundingMode)((Object)(rm == null ? RoundingMode.ROUND : rm)));
        return ParityMode.of(devValue);
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull Graphics2D graphics2D) {
        void g;
        if (graphics2D == null) {
            PaintUtil.$$$reportNull$$$0(2);
        }
        return PaintUtil.alignToInt(usrValue, JBUI.ScaleContext.create((Graphics2D)g), null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull Graphics2D g, @Nullable RoundingMode roundingMode) {
        void rm;
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(3);
        }
        return PaintUtil.alignToInt(usrValue, JBUI.ScaleContext.create(g), (RoundingMode)rm, null);
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull Graphics2D g, @Nullable ParityMode parityMode) {
        void pm;
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(4);
        }
        return PaintUtil.alignToInt(usrValue, JBUI.ScaleContext.create(g), null, (ParityMode)pm);
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull JBUI.ScaleContext ctx, @Nullable RoundingMode rm, @Nullable ParityMode parityMode) {
        void pm;
        double scale;
        if (ctx == null) {
            PaintUtil.$$$reportNull$$$0(5);
        }
        if (rm == null) {
            rm = RoundingMode.ROUND;
        }
        if ((scale = PaintUtil.getScale(ctx)) == 0.0) {
            return 0.0;
        }
        int devValue = PaintUtil.devValue(usrValue, scale, pm != null && rm == RoundingMode.ROUND ? RoundingMode.FLOOR : rm);
        if (pm != null && ParityMode.of(devValue) != pm) {
            devValue += rm == RoundingMode.FLOOR ? -1 : 1;
        }
        return (double)devValue / scale;
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull JBUI.ScaleContext scaleContext) {
        void ctx;
        if (scaleContext == null) {
            PaintUtil.$$$reportNull$$$0(6);
        }
        return PaintUtil.alignToInt(usrValue, (JBUI.ScaleContext)ctx, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static double devValue(double usrValue, @NotNull Graphics2D graphics2D) {
        void g;
        if (graphics2D == null) {
            PaintUtil.$$$reportNull$$$0(7);
        }
        return PaintUtil.devValue(usrValue, JBUI.ScaleContext.create((Graphics2D)g));
    }

    /*
     * WARNING - void declaration
     */
    public static double devValue(double usrValue, @NotNull JBUI.ScaleContext scaleContext) {
        void ctx;
        if (scaleContext == null) {
            PaintUtil.$$$reportNull$$$0(8);
        }
        return usrValue * PaintUtil.getScale((JBUI.ScaleContext)ctx);
    }

    private static int devValue(double usrValue, double scale, @Nullable RoundingMode rm) {
        if (rm == null) {
            rm = RoundingMode.ROUND;
        }
        return rm.round(usrValue * scale);
    }

    public static double devPixel(Graphics2D g) {
        return 1.0 / PaintUtil.devValue(1.0, g);
    }

    private static double getScale(JBUI.ScaleContext ctx) {
        double scale;
        double d = scale = ctx.getScale(JBUI.ScaleType.USR_SCALE) == 0.0 ? 0.0 : ctx.getScale(JBUI.ScaleType.PIX_SCALE) / ctx.getScale(JBUI.ScaleType.USR_SCALE);
        if (scale <= 0.0) {
            // empty if block
        }
        return scale;
    }

    public static AffineTransform alignTxToInt(@NotNull Graphics2D g, @Nullable Point2D offset, boolean alignX, boolean alignY, RoundingMode rm) {
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(9);
        }
        try {
            AffineTransform tx = g.getTransform();
            if (PaintUtil.isFractionalScale(tx)) {
                double scaleX = tx.getScaleX();
                double scaleY = tx.getScaleY();
                AffineTransform alignedTx = new AffineTransform();
                double trX = tx.getTranslateX();
                double trY = tx.getTranslateY();
                if (alignX) {
                    double offX = trX + (offset != null ? offset.getX() * scaleX : 0.0);
                    trX += (double)rm.round(offX) - offX;
                }
                if (alignY) {
                    double offY = trY + (offset != null ? offset.getY() * scaleY : 0.0);
                    trY += (double)rm.round(offY) - offY;
                }
                alignedTx.translate(trX, trY);
                alignedTx.scale(scaleX, scaleY);
                assert (tx.getShearX() == 0.0 && tx.getShearY() == 0.0);
                g.setTransform(alignedTx);
                return tx;
            }
        }
        catch (Exception e) {
            Logger.getInstance("#com.intellij.ui.paint.PaintUtil").error(e);
        }
        return null;
    }

    public static Shape alignClipToInt(@NotNull Graphics2D g, boolean alignH, boolean alignV, RoundingMode xyRM, RoundingMode whRM) {
        Shape clip;
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(10);
        }
        if ((clip = g.getClip()) instanceof Rectangle2D && PaintUtil.isFractionalScale(g.getTransform())) {
            Rectangle2D rect = (Rectangle2D)clip;
            double x = rect.getX();
            double y = rect.getY();
            double w = rect.getWidth();
            double h = rect.getHeight();
            if (alignH) {
                x = PaintUtil.alignToInt(rect.getX(), g, xyRM);
                w = PaintUtil.alignToInt(rect.getX() + rect.getWidth(), g, whRM) - x;
            }
            if (alignV) {
                y = PaintUtil.alignToInt(rect.getY(), g, xyRM);
                h = PaintUtil.alignToInt(rect.getY() + rect.getHeight(), g, whRM) - y;
            }
            g.setClip(new Rectangle2D.Double(x, y, w, h));
            return clip;
        }
        return null;
    }

    public static boolean isFractionalScale(@NotNull AffineTransform tx) {
        if (tx == null) {
            PaintUtil.$$$reportNull$$$0(11);
        }
        double scaleX = tx.getScaleX();
        double scaleY = tx.getScaleY();
        return scaleX != (double)((int)scaleX) || scaleY != (double)((int)scaleY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintWithAA(@NotNull Graphics2D g, @NotNull Object valueAA, @NotNull Runnable paint) {
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(12);
        }
        if (valueAA == null) {
            PaintUtil.$$$reportNull$$$0(13);
        }
        if (paint == null) {
            PaintUtil.$$$reportNull$$$0(14);
        }
        if (valueAA == RenderingHints.VALUE_ANTIALIAS_DEFAULT) {
            paint.run();
            return;
        }
        Object key = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, valueAA);
        try {
            paint.run();
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, key);
        }
    }

    @NotNull
    public static Point2D insets2offset(@Nullable Insets in) {
        Point2D.Double double_ = in == null ? new Point2D.Double(0.0, 0.0) : new Point2D.Double(in.left, in.top);
        if (double_ == null) {
            PaintUtil.$$$reportNull$$$0(15);
        }
        return double_;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tx";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueAA";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paint";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/paint/PaintUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/paint/PaintUtil";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "insets2offset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParityMode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "alignToInt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "devValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "alignTxToInt";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "alignClipToInt";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFractionalScale";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "paintWithAA";
                break;
            }
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ParityMode {
        EVEN,
        ODD;


        public boolean even() {
            return this == EVEN;
        }

        public static ParityMode of(int value) {
            return value % 2 == 0 ? EVEN : ODD;
        }

        public static ParityMode invert(ParityMode pm) {
            return pm == EVEN ? ODD : EVEN;
        }
    }

    public static enum RoundingMode {
        FLOOR{

            @Override
            public int round(double value) {
                return (int)Math.floor(value);
            }
        }
        ,
        CEIL{

            @Override
            public int round(double value) {
                return (int)Math.ceil(value);
            }
        }
        ,
        ROUND{

            @Override
            public int round(double value) {
                return (int)Math.round(value);
            }
        }
        ,
        ROUND_FLOOR_BIAS{

            @Override
            public int round(double value) {
                return (int)Math.ceil(value - 0.5);
            }
        };


        public abstract int round(double var1);
    }
}

