/*
 * Decompiled with CFR 0.152.
 */
package com.projity.scripting;

import com.projity.field.InvalidFormulaException;
import com.projity.scripting.ScriptedFormula;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.util.ArrayList;

public class FormulaClass {
    ArrayList formulas = new ArrayList();
    String className;
    private boolean init = false;
    private static final String imports = "";
    private Class groovyClass = null;
    private GroovyObject groovyObject = null;
    private Exception compileException = null;
    Object[] args = new Object[1];

    public FormulaClass(String string) {
        this.className = string;
    }

    void add(ScriptedFormula scriptedFormula) {
        this.formulas.add(scriptedFormula);
        scriptedFormula.setFormulaClass(this);
    }

    public synchronized void compile() {
        if (this.groovyClass == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String string = FormulaClass.this.buildClassText();
                    GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.getClass().getClassLoader());
                    try {
                        FormulaClass.this.groovyClass = groovyClassLoader.parseClass(string);
                        FormulaClass.this.groovyObject = (GroovyObject)FormulaClass.this.groovyClass.newInstance();
                    }
                    catch (Exception exception) {
                        FormulaClass.this.compileException = exception;
                        System.out.println(exception);
                    }
                }
            };
            runnable.run();
        }
    }

    private String buildClassText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(imports);
        stringBuffer.append("class " + this.className + " {");
        for (ScriptedFormula scriptedFormula : this.formulas) {
            stringBuffer.append("\n\tObject " + scriptedFormula.getFormulaName() + "(Object " + scriptedFormula.getVariableName() + ") {");
            stringBuffer.append("\n\t\treturn " + scriptedFormula.getText() + ";\n\t}");
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    public Object evaluate(String string, Object object) throws InvalidFormulaException {
        try {
            if (this.groovyClass == null) {
                this.compile();
            }
            this.args[0] = object;
            return this.groovyObject.invokeMethod(string, this.args);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidFormulaException(exception);
        }
    }
}

