/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.views;

import com.projity.configuration.Dictionary;
import com.projity.graphic.configuration.BarStyles;
import com.projity.grouping.core.model.NodeModel;
import com.projity.help.HelpUtil;
import com.projity.menu.MenuManager;
import com.projity.pm.graphic.frames.DocumentFrame;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projity.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.views.BaseView;
import com.projity.pm.graphic.xbs.Xbs;
import com.projity.pm.task.Project;
import com.projity.undo.UndoController;
import com.projity.workspace.WorkspaceSetting;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.apache.commons.collections.Closure;

public class TreeView
extends JScrollPane
implements BaseView {
    private static final long serialVersionUID = 2390048109591199408L;
    protected Xbs tree;
    protected NodeModel model;
    protected Project project;
    DocumentFrame documentFrame;
    String viewName = null;
    protected NodeModelCache cache;

    public TreeView(DocumentFrame documentFrame, MenuManager menuManager) {
        this.documentFrame = documentFrame;
        this.project = documentFrame.getProject();
    }

    public void init(ReferenceNodeModelCache referenceNodeModelCache, NodeModel nodeModel, String string, Closure closure) {
        this.tree = new Xbs(this.project, string);
        this.viewName = string;
        this.cache = NodeModelCacheFactory.getInstance().createAntiAssignmentFilteredCache(referenceNodeModelCache, string, closure);
        this.tree.setCache(this.cache);
        this.tree.setBarStyles((BarStyles)Dictionary.get("BarStylesCategory", string));
        JViewport jViewport = this.createViewport();
        jViewport.setView(this.tree);
        this.setViewport(jViewport);
        referenceNodeModelCache.update();
        HelpUtil.addDocHelp(this, string == "RBS" ? "RBS_Chart" : "WBS_Chart");
    }

    @Override
    public void cleanUp() {
        this.tree.cleanUp();
        this.tree = null;
        this.model = null;
        this.project = null;
        this.documentFrame = null;
    }

    @Override
    public void zoomIn() {
        this.tree.zoomIn();
    }

    @Override
    public void zoomOut() {
        this.tree.zoomOut();
    }

    @Override
    public boolean canZoomIn() {
        return this.tree.canZoomIn();
    }

    @Override
    public boolean canZoomOut() {
        return this.tree.canZoomOut();
    }

    @Override
    public int getScale() {
        return this.tree.getZoom();
    }

    @Override
    public UndoController getUndoController() {
        if (this.showsTasks()) {
            return this.project.getUndoController();
        }
        return this.project.getResourcePool().getUndoController();
    }

    @Override
    public SpreadSheet getSpreadSheet() {
        return null;
    }

    @Override
    public boolean hasNormalMinWidth() {
        return true;
    }

    @Override
    public String getViewName() {
        return this.viewName;
    }

    @Override
    public boolean showsTasks() {
        return this.viewName == "WBS";
    }

    @Override
    public boolean showsResources() {
        return this.viewName == "RBS";
    }

    @Override
    public void onActivate(boolean bl) {
    }

    @Override
    public boolean isPrintable() {
        return true;
    }

    @Override
    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.tree.restoreWorkspace(workspace.network, n);
    }

    @Override
    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.network = this.tree.createWorkspace(n);
        return workspace;
    }

    @Override
    public boolean canScrollToTask() {
        return false;
    }

    @Override
    public void scrollToTask() {
    }

    @Override
    public NodeModelCache getCache() {
        return this.cache;
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = 7828075902711289247L;
        WorkspaceSetting network;

        public WorkspaceSetting getNetwork() {
            return this.network;
        }

        public void setNetwork(WorkspaceSetting workspaceSetting) {
            this.network = workspaceSetting;
        }
    }
}

