/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.time;

import com.projity.field.Field;
import com.projity.field.FieldContext;
import com.projity.field.FieldParseException;
import com.projity.graphic.configuration.ActionList;
import com.projity.graphic.configuration.CellStyle;
import com.projity.grouping.core.Node;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheetModel;
import com.projity.pm.graphic.spreadsheet.time.FieldArrayEvent;
import com.projity.pm.graphic.spreadsheet.time.FieldArrayListener;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.pm.time.HasStartAndEnd;
import com.projity.timescale.TimeScaleEvent;
import com.projity.timescale.TimeScaleListener;
import com.projity.util.Alert;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class TimeSpreadSheetModel
extends CommonSpreadSheetModel
implements TimeScaleListener {
    protected ArrayList selectedFieldArray;
    protected CoordinatesConverter coord;
    protected ArrayList timeIntervals;
    FieldContext fieldContext = new FieldContext();
    ArrayList fieldArray;
    protected int columnCount = 1;
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public final ArrayList getFieldArray() {
        return this.fieldArray;
    }

    public TimeSpreadSheetModel(NodeModelCache nodeModelCache, ArrayList arrayList, CellStyle cellStyle, ActionList actionList) {
        super(nodeModelCache, null, cellStyle, actionList);
        this.fieldArray = arrayList;
        this.selectedFieldArray = new ArrayList();
        this.timeIntervals = new ArrayList();
        this.resetSelectedFieldArray();
        this.setFieldContext(this.fieldContext);
    }

    public void resetSelectedFieldArray() {
        int n = this.selectedFieldArray.size();
        this.selectedFieldArray.clear();
        if (this.fieldArray.size() > 0) {
            this.selectedFieldArray.add(this.fieldArray.get(0));
        }
        if (n != this.selectedFieldArray.size()) {
            this.fireFieldArrayChanged(this);
            this.fireUpdateAll();
        }
    }

    @Override
    public void setFieldArray(ArrayList arrayList) {
        this.fieldArray = arrayList;
        this.resetSelectedFieldArray();
    }

    public ArrayList getSelectedFieldArray() {
        return this.selectedFieldArray;
    }

    public void setSelectedFieldArray(ArrayList arrayList) {
        int n = this.selectedFieldArray.size();
        this.selectedFieldArray = arrayList;
        if (n != arrayList.size()) {
            this.fireFieldArrayChanged(this);
            this.fireUpdateAll();
        }
    }

    public void selectFieldArray(Field field) {
        int n = this.selectedFieldArray.size();
        if (this.selectedFieldArray.contains(field)) {
            this.selectedFieldArray.remove(field);
            if (this.selectedFieldArray.size() == 0) {
                this.resetSelectedFieldArray();
            }
        } else {
            this.selectedFieldArray.add(this.selectedFieldArray.size(), field);
        }
        if (n != this.selectedFieldArray.size()) {
            this.fireFieldArrayChanged(this);
            this.fireUpdateAll();
        }
    }

    public boolean isComposite(GraphicNode graphicNode) {
        return graphicNode.isComposite();
    }

    @Override
    public int getRowMultiple() {
        return this.selectedFieldArray.size();
    }

    void resetTimeIntervals() {
        this.timeIntervals.clear();
    }

    void addTimeInterval(HasStartAndEnd hasStartAndEnd) {
        this.timeIntervals.add(hasStartAndEnd);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.getFieldInRow(n).toString();
        }
        Node node = this.getNodeInRow(n);
        if (node.isVoid()) {
            return null;
        }
        this.getFieldContext().setInterval((HasStartAndEnd)this.timeIntervals.get(n2 - 1));
        return this.getFieldInRow(n).getValue(node, this.getCache().getWalkersModel(), this.fieldContext);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Object object2 = this.getValueAt(n, n2);
        if (object2 == null && (object == null || "".equals(object))) {
            return;
        }
        if (n2 == 0) {
            return;
        }
        try {
            Node node = this.getNodeInRow(n);
            if (node.isVirtual()) {
                return;
            }
            this.getFieldContext().setInterval((HasStartAndEnd)this.timeIntervals.get(n2 - 1));
            this.getCache().getModel().setFieldValue(this.getFieldInRow(n), node, this, object, this.fieldContext, 3);
            this.fireTableCellUpdated(n, n2);
        }
        catch (FieldParseException fieldParseException) {
            Alert.error(fieldParseException.getMessage());
        }
    }

    public Field getFieldInRow(int n) {
        if (this.selectedFieldArray.size() == 0) {
            return null;
        }
        return (Field)this.selectedFieldArray.get(n % this.getRowMultiple());
    }

    @Override
    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        return null;
    }

    public Class getRowClass(int n) {
        Field field = this.getFieldInRow(n);
        if (field == null) {
            return String.class;
        }
        return field.getDisplayType();
    }

    void incrementColumnCount() {
        ++this.columnCount;
    }

    void decrementColumnCount() {
        --this.columnCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return false;
        }
        Node node = this.getNodeInRow(n);
        if (node.isVoid()) {
            return true;
        }
        this.getFieldContext().setInterval((HasStartAndEnd)this.timeIntervals.get(n2 - 1));
        return !this.getFieldInRow(n).isReadOnly(node, this.getCache().getWalkersModel(), this.fieldContext);
    }

    public CoordinatesConverter getCoord() {
        return this.coord;
    }

    public void setCoord(CoordinatesConverter coordinatesConverter) {
        if (this.coord != null) {
            this.coord.removeTimeScaleListener(this);
        }
        this.coord = coordinatesConverter;
        coordinatesConverter.addTimeScaleListener(this);
    }

    @Override
    public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
    }

    public void addFieldArrayListener(FieldArrayListener fieldArrayListener) {
        this.listenerList.add(FieldArrayListener.class, fieldArrayListener);
    }

    public void removeFieldArrayListener(FieldArrayListener fieldArrayListener) {
        this.listenerList.remove(FieldArrayListener.class, fieldArrayListener);
    }

    public FieldArrayListener[] getFieldArrayListeners() {
        return (FieldArrayListener[])this.listenerList.getListeners(FieldArrayListener.class);
    }

    protected void fireFieldArrayChanged(Object object) {
        Object[] objectArray = this.listenerList.getListenerList();
        FieldArrayEvent fieldArrayEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FieldArrayListener.class) continue;
            if (fieldArrayEvent == null) {
                fieldArrayEvent = new FieldArrayEvent(object, this.getSelectedFieldArray());
            }
            ((FieldArrayListener)objectArray[i + 1]).fieldArrayChanged(fieldArrayEvent);
        }
    }

    public EventListener[] getFieldArrayListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }
}

