/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.renderer;

import com.projity.company.UserUtil;
import com.projity.graphic.configuration.HasResourceIndicators;
import com.projity.pm.graphic.IconManager;
import com.projity.pm.graphic.spreadsheet.renderer.IndicatorsComponent;
import com.projity.strings.Messages;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ResourceIndicatorsComponent
extends IndicatorsComponent {
    private static final long serialVersionUID = 19290101L;
    protected JLabel team;
    protected JLabel userPowerUser;
    protected JLabel userLiteUser;
    protected JLabel userPowerUserExternal;
    protected JLabel userLiteUserExternal;
    protected JLabel userAdmin;
    protected JLabel userInactive;

    @Override
    public void init() {
        this.team = new JLabel(" ", IconManager.getIcon("indicator.team"), 4);
        this.team.setOpaque(false);
        this.userAdmin = new JLabel(" ", IconManager.getIcon("indicator.user.admin"), 4);
        this.userAdmin.setOpaque(false);
        this.userPowerUser = new JLabel(" ", IconManager.getIcon("indicator.user.pm"), 4);
        this.userPowerUser.setOpaque(false);
        this.userLiteUser = new JLabel(" ", IconManager.getIcon("indicator.user.tm"), 4);
        this.userLiteUser.setOpaque(false);
        this.userPowerUserExternal = new JLabel(" ", IconManager.getIcon("indicator.user.external_pm"), 4);
        this.userPowerUserExternal.setOpaque(false);
        this.userLiteUserExternal = new JLabel(" ", IconManager.getIcon("indicator.user.external_tm"), 4);
        this.userLiteUserExternal.setOpaque(false);
        this.userInactive = new JLabel(" ", IconManager.getIcon("indicator.user.inactive"), 4);
        this.userInactive.setOpaque(false);
    }

    @Override
    public boolean acceptValue(Object object) {
        return ResourceIndicatorsComponent.acceptResource(object);
    }

    public static boolean acceptResource(Object object) {
        return object instanceof HasResourceIndicators;
    }

    @Override
    public void setIndicators(Object object, JComponent jComponent, StringBuffer stringBuffer, boolean bl, boolean bl2) {
        HasResourceIndicators hasResourceIndicators = (HasResourceIndicators)object;
        if (hasResourceIndicators.isInTeam()) {
            jComponent.add(this.team);
            this.setLook(this.team, bl, bl2);
            stringBuffer.append(Messages.getString("ResourceIndicatorsComponent.ThisResourceIsOnTheProjectTeam"));
        }
        if (hasResourceIndicators.isUser()) {
            JLabel jLabel;
            int n = hasResourceIndicators.getLicense();
            switch (n) {
                case 1: {
                    jLabel = hasResourceIndicators.isAdministrator() ? this.userAdmin : (hasResourceIndicators.isExternal() ? this.userPowerUserExternal : this.userPowerUser);
                    break;
                }
                case 2: {
                    jLabel = hasResourceIndicators.isExternal() ? this.userLiteUserExternal : this.userLiteUser;
                    break;
                }
                case 0: {
                    jLabel = this.userInactive;
                    break;
                }
                default: {
                    jLabel = null;
                }
            }
            if (jLabel != null) {
                jComponent.add(jLabel);
                this.setLook(jLabel, bl, bl2);
                stringBuffer.append(Messages.getString("ResourceIndicatorsComponent.UserLicense") + UserUtil.licenseToLabel(n) + (hasResourceIndicators.isAdministrator() ? Messages.getString("ResourceIndicatorsComponent.Administrator") : "") + (hasResourceIndicators.isExternal() ? Messages.getString("ResourceIndicatorsComponent.PartnerCustomer") : "") + "<br>");
            }
        }
    }
}

