/*
 * Decompiled with CFR 0.152.
 */
package com.projity.menu;

import com.projectlibre.ui.ribbon.CustomRibbonBandGenerator;
import com.projity.menu.ExtMenuFactory;
import com.projity.menu.ExtRibbonFactory;
import com.projity.menu.ExtToolBarFactory;
import com.projity.menu.HyperLinkToolTip;
import com.projity.pm.graphic.TabbedNavigation;
import com.projity.strings.DirectoryClassLoader;
import com.projity.util.ClassLoaderUtils;
import com.projity.util.Environment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.batik.util.gui.resource.ActionMap;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class MenuManager {
    private static final String MENU_BUNDLE = "com.projity.menu.menu";
    private static final String MENU_INTERNAL_BUNDLE = "com.projity.menu.menuInternal";
    private static final String MENU_BUNDLE_CONF_DIR = "menu";
    public static final String STANDARD_MENU = "StandardMenuBar";
    public static final String MAC_STANDARD_MENU = "MacStandardMenuBar";
    public static final String SERVER_STANDARD_MENU = "ServerStandardMenuBar";
    public static final String SF_MENU = "SFMenuBar";
    public static final String STANDARD_TOOL_BAR = "StandardToolBar";
    public static final String MAC_STANDARD_TOOL_BAR = "MacStandardToolBar";
    public static final String FILE_TOOL_BAR = "FileToolBar";
    public static final String BIG_TOOL_BAR = "BigToolBar";
    public static final String VIEW_TOOL_BAR = "ViewToolBar";
    public static final String VIEW_TOOL_BAR_WITH_NO_SUB_VIEW_OPTION = "ViewToolBarNoSubView";
    public static final String RIBBON_VIEW_BAR = "RibbonViewToolBar";
    public static final String PRINT_PREVIEW_TOOL_BAR = "PrintPreviewToolBar";
    public static final String STANDARD_RIBBON = "StandardRibbon";
    static ResourceBundle[] bundles;
    ExtMenuFactory menuFactory;
    ExtToolBarFactory toolBarFactory;
    ExtRibbonFactory ribbonFactory;
    ActionMap rootActionMap;
    LinkedList tabbedNavigations = new LinkedList();

    public void add(TabbedNavigation tabbedNavigation) {
        this.tabbedNavigations.add(tabbedNavigation);
    }

    private MenuManager(ActionMap actionMap) {
        this.rootActionMap = actionMap;
        ResourceBundle resourceBundle = null;
        ResourceBundle resourceBundle2 = null;
        if (resourceBundle2 == null) {
            try {
                DirectoryClassLoader directoryClassLoader = new DirectoryClassLoader();
                if (directoryClassLoader.isValid()) {
                    resourceBundle2 = ResourceBundle.getBundle(MENU_BUNDLE_CONF_DIR, Locale.getDefault(), directoryClassLoader);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(MENU_INTERNAL_BUNDLE, Locale.getDefault(), ClassLoaderUtils.getLocalClassLoader());
            }
            if (resourceBundle2 == null) {
                resourceBundle2 = ResourceBundle.getBundle(MENU_BUNDLE, Locale.getDefault(), ClassLoaderUtils.getLocalClassLoader());
            }
            bundles = new ResourceBundle[]{resourceBundle, resourceBundle2};
        }
        this.menuFactory = new ExtMenuFactory(actionMap, bundles);
        this.toolBarFactory = new ExtToolBarFactory(actionMap, bundles);
        if (Environment.isRibbonUI()) {
            this.ribbonFactory = new ExtRibbonFactory(actionMap, bundles);
        }
    }

    public static MenuManager getInstance(ActionMap actionMap) {
        return new MenuManager(actionMap);
    }

    public JMenuBar getMenu(String string) {
        return this.menuFactory.createJMenuBar(string);
    }

    public JPopupMenu getPopupMenu(String string) {
        return this.menuFactory.createJPopupMenuBar(string);
    }

    public static String getMenuString(String string) {
        MissingResourceException missingResourceException = null;
        String string2 = null;
        for (ResourceBundle resourceBundle : bundles) {
            try {
                string2 = resourceBundle.getString(string);
                missingResourceException = null;
            }
            catch (MissingResourceException missingResourceException2) {
                missingResourceException = missingResourceException2;
                continue;
            }
            if (string2 != null) break;
        }
        if (missingResourceException != null) {
            throw missingResourceException;
        }
        return string2;
    }

    public String getString(String string) {
        return this.menuFactory.getString(string);
    }

    public String getStringOrNull(String string) {
        try {
            return this.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public String getActionStringFromId(String string) {
        String string2 = this.menuFactory.getActionStringFromId(string);
        if (string2 == null) {
            System.out.println("Invalid item: " + string + " it must be a menu item in the menu properties, even if it's only shown in a toolbar");
        }
        return string2;
    }

    public Action getActionFromId(String string) {
        return this.menuFactory.getActionFromId(string);
    }

    public String getStringFromAction(Action action) {
        return this.menuFactory.getStringFromAction(action);
    }

    public JMenuItem getMenuItemFromId(String string) {
        return this.menuFactory.getMenuItemFromId(string);
    }

    public ArrayList getToolButtonsFromId(String string) {
        return this.ribbonFactory == null ? this.toolBarFactory.getButtonsFromId(string) : this.ribbonFactory.getButtonsFromId(string);
    }

    public final ExtToolBarFactory getToolBarFactory() {
        return this.toolBarFactory;
    }

    public final ExtRibbonFactory getRibbonFactory() {
        return this.ribbonFactory;
    }

    public JToolBar getToolBar(String string) {
        return this.toolBarFactory.createJToolBar(string);
    }

    public void initComponent(String string, JComponent jComponent) {
        this.toolBarFactory.initJComponent(string, jComponent);
    }

    public Collection<RibbonTask> getRibbon(String string, CustomRibbonBandGenerator customRibbonBandGenerator) {
        return this.ribbonFactory.createRibbon(string, customRibbonBandGenerator);
    }

    public Collection<AbstractCommandButton> getTaskBar(String string) {
        return this.ribbonFactory.createTaskBar(string);
    }

    public void setActionEnabled(String string, boolean bl) {
        Object object;
        ArrayList arrayList = this.getToolButtonsFromId(string);
        if (arrayList != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                AbstractButton abstractButton = (AbstractButton)object.next();
                if (abstractButton == null) continue;
                abstractButton.setEnabled(bl);
            }
        }
        if ((object = this.menuFactory.getMenuItemFromId(string)) != null) {
            ((JMenuItem)object).setEnabled(bl);
        }
    }

    public void setActionVisible(String string, boolean bl) {
        Object object;
        ArrayList arrayList = this.getToolButtonsFromId(string);
        if (arrayList != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                AbstractButton abstractButton = (AbstractButton)object.next();
                if (abstractButton == null) continue;
                abstractButton.setVisible(bl);
            }
        }
        if ((object = this.menuFactory.getMenuItemFromId(string)) != null) {
            ((JComponent)object).setVisible(bl);
        }
    }

    public void setActionSelected(String string, boolean bl) {
        Object object;
        Object object2;
        ArrayList arrayList = this.getToolButtonsFromId(string);
        if (arrayList != null) {
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (AbstractButton)object2.next();
                if (object == null) continue;
                ((AbstractButton)object).setSelected(bl);
                if (!(object instanceof JToggleButton)) continue;
            }
        }
        if ((object2 = this.menuFactory.getMenuItemFromId(string)) != null) {
            ((AbstractButton)object2).setSelected(bl);
        }
        object = this.tabbedNavigations.iterator();
        while (object.hasNext()) {
            ((TabbedNavigation)object.next()).setActivatedView(string, bl);
        }
    }

    public void setText(String string, String string2) {
        Object object;
        ArrayList arrayList = this.getToolButtonsFromId(string);
        if (arrayList != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                AbstractButton abstractButton = (AbstractButton)object.next();
                if (abstractButton == null) continue;
                abstractButton.setToolTipText(string2);
            }
        }
        if ((object = this.menuFactory.getMenuItemFromId(string)) != null) {
            ((AbstractButton)object).setText(string2);
        }
    }

    public String getTextForId(String string) {
        return this.menuFactory.getTextForId(string);
    }

    public String getFullTipText(String string) {
        String string2 = this.getStringOrNull(string + ".tooltip");
        if (string2 != null) {
            String string3 = this.getStringOrNull(string + ".help");
            String string4 = this.getStringOrNull(string + ".demo");
            String string5 = this.getStringOrNull(string + ".doc");
            if (string5 != null) {
                string2 = HyperLinkToolTip.helpTipText(string2, string3, string4, string5);
            }
        }
        return string2;
    }
}

