/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog.util;

import com.projity.dialog.util.LookupField;
import com.projity.field.Field;
import com.projity.field.FieldContext;
import com.projity.field.FieldParseException;
import com.projity.field.ObjectRef;
import com.projity.util.Alert;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FieldChangeListener
implements ItemListener,
ChangeListener {
    private FieldContext context = null;
    private Field field;
    private ObjectRef objectRef = null;

    public FieldChangeListener(Field field, ObjectRef objectRef) {
        this.field = field;
        this.objectRef = objectRef;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        Boolean bl = itemEvent.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        try {
            this.field.setValue(this.objectRef, object, (Object)bl, this.context);
        }
        catch (FieldParseException fieldParseException) {
            Alert.error(fieldParseException.getMessage());
            ((JComponent)object).requestFocus();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof LookupField) {
            LookupField lookupField = (LookupField)changeEvent.getSource();
            try {
                this.field.setText(this.objectRef, lookupField.getValue(), this.context);
            }
            catch (FieldParseException fieldParseException) {
                fieldParseException.printStackTrace();
            }
        }
    }
}

