/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.TcpAddress;

public class SshAddress
extends TcpAddress {
    static final long serialVersionUID = 0L;
    private static final LogAdapter logger = LogFactory.getLogger(SshAddress.class);
    private String addressURI;
    private String userName;

    public SshAddress(String addressURI) {
        this.addressURI = addressURI;
        this.parseAddress(addressURI);
    }

    public SshAddress(InetAddress inetAddress, int port) {
        super(inetAddress, port);
        this.addressURI = "" + inetAddress.getHostAddress() + ':' + port;
    }

    public SshAddress(InetAddress inetAddress, int port, String userName) {
        super(inetAddress, port);
        this.userName = userName;
        this.addressURI = userName + '@' + inetAddress.getHostAddress() + ':' + port;
    }

    public String getAddressURI() {
        return this.addressURI;
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public boolean parseAddress(String address) {
        try {
            int firstAtPos;
            String addressString = address;
            String portString = null;
            String userName = null;
            int lastColon = address.lastIndexOf(58);
            if (lastColon >= 0 && lastColon + 1 < address.length()) {
                addressString = address.substring(0, lastColon);
                portString = address.substring(lastColon + 1);
            }
            if ((firstAtPos = addressString.indexOf(64)) > 0 && firstAtPos + 1 < addressString.length()) {
                userName = addressString.substring(0, firstAtPos);
                addressString = addressString.substring(firstAtPos + 1);
            }
            try {
                this.setInetAddress(InetAddress.getByName(addressString));
                this.port = Integer.parseInt(portString);
                this.userName = userName;
            }
            catch (UnknownHostException uhex) {
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            logger.error("Failed to parse address '" + address + "' as SSH address: " + ex.getMessage(), ex);
            return false;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SshAddress that = (SshAddress)o;
        if (!this.getInetAddress().equals(that.getInetAddress())) {
            return false;
        }
        if (!this.addressURI.equals(that.addressURI)) {
            return false;
        }
        return !(this.userName != null ? !this.userName.equals(that.userName) : that.userName != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.addressURI.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "SshAddress[addressURI='" + this.addressURI + '\'' + ']';
    }
}

