/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.TransportProbe;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.npn.ServerSideNegotiator;
import org.glassfish.grizzly.spdy.NextProtoNegSupport;
import org.glassfish.grizzly.spdy.SpdyFramingFilter;
import org.glassfish.grizzly.spdy.SpdyHandlerFilter;
import org.glassfish.grizzly.spdy.SpdyMode;
import org.glassfish.grizzly.spdy.SpdyVersion;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLConnectionContext;
import org.glassfish.grizzly.ssl.SSLUtils;

public class SpdyAddOn
implements AddOn {
    protected static final SpdyVersion[] ALL_SPDY_VERSIONS = new SpdyVersion[]{SpdyVersion.SPDY_3_1, SpdyVersion.SPDY_3};
    private static final Logger LOGGER = Grizzly.logger(SpdyAddOn.class);
    protected final SpdyMode mode;
    protected final SpdyVersion[] supportedSpdyVersions;
    private int maxConcurrentStreams = 100;
    private int initialWindowSize = 65536;
    private int maxFrameLength = 0x1000000;

    public SpdyAddOn() {
        this(SpdyMode.NPN, ALL_SPDY_VERSIONS);
    }

    public SpdyAddOn(SpdyMode mode) {
        this(mode, ALL_SPDY_VERSIONS);
    }

    public SpdyAddOn(SpdyMode mode, SpdyVersion ... supportedSpdyVersions) {
        this.mode = mode;
        this.supportedSpdyVersions = supportedSpdyVersions == null || supportedSpdyVersions.length == 0 ? ALL_SPDY_VERSIONS : Arrays.copyOf(supportedSpdyVersions, supportedSpdyVersions.length);
    }

    @Override
    public void setup(NetworkListener networkListener, FilterChainBuilder builder) {
        TCPNIOTransport transport = networkListener.getTransport();
        if (this.mode == SpdyMode.NPN) {
            if (!networkListener.isSecure()) {
                LOGGER.warning("Can not configure NPN (Next Protocol Negotiation) mode on non-secured NetworkListener. SPDY support will not be enabled.");
                return;
            }
            if (!NextProtoNegSupport.isEnabled()) {
                LOGGER.warning("TLS NPN (Next Protocol Negotiation) support is not available. SPDY support will not be enabled.");
                return;
            }
            this.configureNpn(builder);
            transport.getMonitoringConfig().addProbes((TransportProbe[])new TransportProbe[]{this.getConfigProbe()});
        } else {
            this.updateFilterChain(this.mode, builder);
        }
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    public int getMaxFrameLength() {
        return this.maxFrameLength;
    }

    public void setMaxFrameLength(int maxFrameLength) {
        this.maxFrameLength = maxFrameLength;
    }

    protected TransportProbe getConfigProbe() {
        return new SpdyNpnConfigProbe();
    }

    protected void configureNpn(FilterChainBuilder builder) {
        int idx = builder.indexOfType(SSLBaseFilter.class);
        SSLBaseFilter sslFilter = (SSLBaseFilter)builder.get(idx);
        NextProtoNegSupport.getInstance().configure(sslFilter);
    }

    protected void updateFilterChain(SpdyMode mode, FilterChainBuilder builder) {
        int idx = SpdyAddOn.removeHttpServerCodecFilter(builder);
        this.insertSpdyFilters(mode, builder, idx);
    }

    private static int removeHttpServerCodecFilter(FilterChainBuilder builder) {
        int idx = builder.indexOfType(HttpServerFilter.class);
        builder.remove(idx);
        return idx;
    }

    private void insertSpdyFilters(SpdyMode mode, FilterChainBuilder builder, int idx) {
        SpdyFramingFilter spdyFramingFilter = new SpdyFramingFilter();
        spdyFramingFilter.setMaxFrameLength(this.getMaxFrameLength());
        builder.add(idx, spdyFramingFilter);
        SpdyHandlerFilter spdyHandlerFilter = new SpdyHandlerFilter(mode, this.supportedSpdyVersions);
        spdyHandlerFilter.setInitialWindowSize(this.getInitialWindowSize());
        spdyHandlerFilter.setMaxConcurrentStreams(this.getMaxConcurrentStreams());
        builder.add(idx + 1, spdyHandlerFilter);
    }

    protected static final class ProtocolNegotiator
    implements ServerSideNegotiator {
        private static final String HTTP11 = "http/1.1";
        private final LinkedHashSet<String> supportedProtocols;
        private final FilterChain spdyFilterChain;
        private final SpdyHandlerFilter spdyHandlerFilter;

        public ProtocolNegotiator(FilterChain filterChain, SpdyVersion[] supportedSpdyVersions) {
            this.spdyFilterChain = filterChain;
            this.supportedProtocols = new LinkedHashSet(supportedSpdyVersions.length + 1);
            for (SpdyVersion version : supportedSpdyVersions) {
                this.supportedProtocols.add(version.toString());
            }
            this.supportedProtocols.add(HTTP11);
            int filterIdx = this.spdyFilterChain.indexOfType(SpdyHandlerFilter.class);
            if (filterIdx == -1) {
                throw new IllegalStateException("SpdyHandlerFilter has to be in the SPDY filterchain");
            }
            this.spdyHandlerFilter = (SpdyHandlerFilter)this.spdyFilterChain.get(filterIdx);
        }

        @Override
        public LinkedHashSet<String> supportedProtocols(SSLEngine engine) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "NPN supportedProtocols. Connection={0} sslEngine={1} supportedProtocols={2}", new Object[]{NextProtoNegSupport.getConnection(engine), engine, this.supportedProtocols});
            }
            return this.supportedProtocols;
        }

        @Override
        public void onSuccess(SSLEngine engine, String protocol) {
            SpdyVersion spdyVersion;
            Connection connection = NextProtoNegSupport.getConnection(engine);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "NPN onSuccess. Connection={0} sslEngine={1} protocol={2}", new Object[]{connection, engine, protocol});
            }
            if ((spdyVersion = SpdyVersion.fromString(protocol)) != null) {
                this.spdyHandlerFilter.createSpdySession(spdyVersion, connection, true);
                SSLConnectionContext sslCtx = SSLUtils.getSslConnectionContext(connection);
                sslCtx.setNewConnectionFilterChain(this.spdyFilterChain);
            }
        }

        @Override
        public void onNoDeal(SSLEngine engine) {
            Connection connection = NextProtoNegSupport.getConnection(engine);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "NPN onNoDeal. Connection={0} sslEngine={1}", new Object[]{connection, engine});
            }
            connection.closeSilently();
        }
    }

    private final class SpdyNpnConfigProbe
    extends TransportProbe.Adapter {
        private SpdyNpnConfigProbe() {
        }

        @Override
        public void onBeforeStartEvent(Transport transport) {
            FilterChain transportFilterChain = (FilterChain)transport.getProcessor();
            FilterChainBuilder builder = FilterChainBuilder.stateless();
            builder.addAll(transportFilterChain);
            SpdyAddOn.this.updateFilterChain(SpdyMode.NPN, builder);
            NextProtoNegSupport.getInstance().setServerSideNegotiator(transport, (ServerSideNegotiator)new ProtocolNegotiator(builder.build(), SpdyAddOn.this.supportedSpdyVersions));
        }
    }
}

