/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work.tasks;

import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.compliance.Policy;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceGroup;
import onl.netfishers.netshot.work.Task;
import org.hibernate.CacheMode;
import org.hibernate.Hibernate;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class CheckGroupComplianceTask
extends Task {
    private static Logger logger = LoggerFactory.getLogger(CheckGroupComplianceTask.class);
    private DeviceGroup deviceGroup;

    public CheckGroupComplianceTask() {
    }

    public CheckGroupComplianceTask(DeviceGroup group, String comments, String author) {
        super(comments, group.getName(), author);
        this.deviceGroup = group;
    }

    @Override
    @XmlElement
    @Transient
    public String getTaskDescription() {
        return "Group compliance check";
    }

    @Override
    public void prepare() {
        Hibernate.initialize(this.getDeviceGroup());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public DeviceGroup getDeviceGroup() {
        return this.deviceGroup;
    }

    public void setDeviceGroup(DeviceGroup deviceGroup) {
        this.deviceGroup = deviceGroup;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CheckGroupComplianceTask task = (CheckGroupComplianceTask)super.clone();
        task.setDeviceGroup(this.deviceGroup);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug("Starting check compliance task for group {}.", (Object)this.deviceGroup.getId());
        this.logIt(String.format("Check compliance task for group %s.", this.deviceGroup.getName()), 5);
        try (Session session = Database.getSession();){
            List policies = session.createCriteria(Policy.class).list();
            session.beginTransaction();
            session.createQuery("delete from CheckResult c where c.key.device.id in (select d.id as id from DeviceGroup g1 join g1.cachedDevices d where g1.id = :id)").setLong("id", this.deviceGroup.getId()).executeUpdate();
            for (Policy policy : policies) {
                ScrollableResults devices = session.createQuery("from Device d join fetch d.lastConfig where d.id in (select d.id as id from DeviceGroup g1 join g1.cachedDevices d join d.ownerGroups g2 join g2.appliedPolicies p where g1.id = :id and p.id = :pid)").setLong("id", this.deviceGroup.getId()).setLong("pid", policy.getId()).setCacheMode(CacheMode.IGNORE).scroll(ScrollMode.FORWARD_ONLY);
                while (devices.next()) {
                    Device device = (Device)devices.get(0);
                    policy.check(device, session);
                    session.flush();
                    session.evict(device);
                }
            }
            session.getTransaction().commit();
            this.status = Task.Status.SUCCESS;
        }
    }
}

