/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.work.DebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
@Table(indexes={@Index(name="changeDateIndex", columnList="changeDate"), @Index(name="creationDateIndex", columnList="creationDate"), @Index(name="statusIndex", columnList="status"), @Index(name="executionDateIndex", columnList="executionDate")})
@JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, include=JsonTypeInfo.As.PROPERTY, property="type")
public abstract class Task
implements Cloneable {
    private static Logger logger = LoggerFactory.getLogger(Task.class);
    private static final Set<Class<? extends Task>> TASK_CLASSES = new HashSet<Class<? extends Task>>();
    protected String author = "";
    protected Date changeDate;
    protected String comments = "";
    protected Date creationDate = new Date();
    protected boolean debugEnabled = false;
    protected DebugLog debugLog;
    protected Date executionDate;
    protected long id;
    protected StringBuffer log = new StringBuffer();
    protected Date scheduleReference = new Date();
    protected ScheduleType scheduleType = ScheduleType.ASAP;
    protected Status status = Status.NEW;
    protected String target = "None";
    private int version;

    public static final Set<Class<? extends Task>> getTaskClasses() {
        return TASK_CLASSES;
    }

    protected Task() {
    }

    public Task(String comments, String target, String author, boolean debugEnabled) {
        this.comments = comments;
        this.target = target;
        this.author = author;
        this.debugEnabled = debugEnabled;
    }

    public Task(String comments, String target, String author) {
        this.comments = comments;
        this.target = target;
        this.author = author;
    }

    public Object clone() throws CloneNotSupportedException {
        Task task = (Task)super.clone();
        task.setScheduleReference(this.scheduleReference);
        task.setScheduleType(this.scheduleType);
        task.setId(0L);
        return task;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Task)) {
            return false;
        }
        Task other = (Task)obj;
        return this.id == other.id;
    }

    @XmlElement
    public String getAuthor() {
        return this.author;
    }

    @XmlElement
    public Date getChangeDate() {
        return this.changeDate;
    }

    @XmlElement
    public String getComments() {
        return this.comments;
    }

    @XmlElement
    public Date getCreationDate() {
        return this.creationDate;
    }

    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    public DebugLog getDebugLog() {
        return this.debugLog;
    }

    @XmlElement
    public Date getExecutionDate() {
        return this.executionDate;
    }

    @XmlElement
    @Id
    @GeneratedValue
    public long getId() {
        return this.id;
    }

    @XmlElement
    @Column(name="log", length=100000000)
    public String getLog() {
        return this.log.toString();
    }

    @Transient
    @XmlElement
    public Date getNextExecutionDate() {
        Calendar reference = Calendar.getInstance();
        reference.setTime(this.scheduleReference);
        Calendar target = Calendar.getInstance();
        Calendar inOneMinute = Calendar.getInstance();
        inOneMinute.add(12, 1);
        switch (this.scheduleType) {
            case AT: {
                return this.scheduleReference;
            }
            case DAILY: {
                target.set(11, reference.get(11));
                target.set(12, reference.get(12));
                target.set(13, reference.get(13));
                target.set(14, 0);
                if (target.before(inOneMinute)) {
                    target.add(5, 1);
                }
                return target.getTime();
            }
            case WEEKLY: {
                target.set(11, reference.get(11));
                target.set(12, reference.get(12));
                target.set(13, reference.get(13));
                target.set(14, 0);
                target.set(7, reference.get(7));
                if (target.before(inOneMinute)) {
                    target.add(3, 1);
                }
                return target.getTime();
            }
            case MONTHLY: {
                target.set(11, reference.get(11));
                target.set(12, reference.get(12));
                target.set(13, reference.get(13));
                target.set(14, 0);
                target.set(5, reference.get(5));
                if (target.before(inOneMinute)) {
                    target.add(2, 1);
                }
                return target.getTime();
            }
        }
        return null;
    }

    @XmlElement
    public Date getScheduleReference() {
        return this.scheduleReference;
    }

    @XmlElement
    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    @XmlElement
    public Status getStatus() {
        return this.status;
    }

    @XmlElement
    @Column(length=10000)
    public String getTarget() {
        return this.target;
    }

    @XmlElement
    @Transient
    public abstract String getTaskDescription();

    @Version
    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    @XmlElement
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Transient
    @XmlElement
    public boolean isRepeating() {
        switch (this.scheduleType) {
            case AT: 
            case ASAP: {
                return false;
            }
        }
        return true;
    }

    public void logIt(String log, int level) {
        this.log.append(String.format("[%02d] %s\n", level, log));
    }

    public void onCancel() {
    }

    public void onSchedule() {
    }

    public void prepare() {
    }

    public abstract void run();

    public void schedule(Date reference, ScheduleType type) {
        this.scheduleType = type;
        this.scheduleReference = reference;
    }

    public void schedule(int minutes) {
        this.scheduleType = ScheduleType.AT;
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, minutes);
        this.scheduleReference = calendar.getTime();
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setCancelled() {
        this.status = Status.CANCELLED;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    public void setFailed() {
        this.status = Status.FAILURE;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setLog(String log) {
        this.log = new StringBuffer(log);
    }

    public void setLog(StringBuffer log) {
        this.log = log;
    }

    public void setDebugLog(DebugLog debugLog) {
        this.debugLog = debugLog;
    }

    public void setRunning() {
        this.log = new StringBuffer();
        this.status = Status.RUNNING;
        this.executionDate = new Date();
    }

    public void setScheduled() {
        this.status = Status.SCHEDULED;
    }

    public void setScheduleReference(Date scheduleReference) {
        this.scheduleReference = scheduleReference;
    }

    public void setScheduleType(ScheduleType scheduleType) {
        this.scheduleType = scheduleType;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    static {
        try {
            for (Class<?> clazz : Database.listClassesInPackage("onl.netfishers.netshot.work.tasks")) {
                if (!Task.class.isAssignableFrom(clazz)) continue;
                Class<?> taskClass = clazz;
                TASK_CLASSES.add(taskClass);
            }
        }
        catch (Exception e) {
            logger.error("Error while scanning the task classes.", e);
        }
    }

    public static enum Status {
        CANCELLED,
        FAILURE,
        NEW,
        RUNNING,
        SCHEDULED,
        SUCCESS,
        WAITING;

    }

    public static enum ScheduleType {
        ASAP,
        AT,
        DAILY,
        MONTHLY,
        WEEKLY;

    }
}

