/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.device.NetworkAddress;

@Embeddable
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Network4Address
extends NetworkAddress {
    private int address = 0;
    private int prefixLength = 0;
    private NetworkAddress.AddressUsage addressUsage = NetworkAddress.AddressUsage.PRIMARY;

    public static int dottedMaskToPrefixLength(String mask) throws UnknownHostException {
        int n = Network4Address.ipToInt(mask);
        return (int)Math.round(32.0 - Math.log((n ^= 0xFFFFFFFF) + 1) / Math.log(2.0));
    }

    public static int inetAddressToInt(Inet4Address address) {
        byte[] buffer = address.getAddress();
        return ByteBuffer.wrap(buffer).getInt();
    }

    public static InetAddress intToInetAddress(int address) throws UnknownHostException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(address);
        return InetAddress.getByAddress(buffer.array());
    }

    public static String intToIP(int address) {
        int b1 = address & 0xFF;
        int b2 = address >> 8 & 0xFF;
        int b3 = address >> 16 & 0xFF;
        int b4 = address >> 24 & 0xFF;
        return String.format("%d.%d.%d.%d", b4, b3, b2, b1);
    }

    public static int ipToInt(String address) throws UnknownHostException {
        try {
            InetAddress inetAddress = InetAddress.getByName(address);
            if (inetAddress instanceof Inet4Address) {
                return Network4Address.inetAddressToInt((Inet4Address)inetAddress);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new UnknownHostException("Unable to parse the IPv4 address");
    }

    public static String prefixLengthToDottedMask(int length) {
        return Network4Address.intToIP(Network4Address.prefixLengthToIntAddress(length));
    }

    public static int prefixLengthToIntAddress(int length) {
        return -1 << 32 - length;
    }

    protected Network4Address() {
    }

    public Network4Address(Inet4Address address, int prefixLength) throws UnknownHostException {
        this.address = Network4Address.inetAddressToInt(address);
        if (prefixLength < 0 || prefixLength > 32) {
            throw new UnknownHostException("Invalid prefix length");
        }
        this.prefixLength = prefixLength;
    }

    public Network4Address(String address) throws UnknownHostException {
        this(address, 0);
    }

    public Network4Address(int address, int prefixLength) throws UnknownHostException {
        this.address = address;
        if (prefixLength < 0 || prefixLength > 32) {
            throw new UnknownHostException("Invalid prefix length");
        }
        this.prefixLength = prefixLength;
    }

    public Network4Address(String address, int prefixLength) throws UnknownHostException {
        this.address = Network4Address.ipToInt(address);
        if (prefixLength < 0 || prefixLength > 32) {
            throw new UnknownHostException("Invalid prefix length");
        }
        this.prefixLength = prefixLength;
    }

    public Network4Address(String address, String mask) throws UnknownHostException {
        this.address = Network4Address.ipToInt(address);
        this.prefixLength = Network4Address.dottedMaskToPrefixLength(mask);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Network4Address)) {
            return false;
        }
        Network4Address other = (Network4Address)obj;
        return this.address == other.address && this.prefixLength == other.prefixLength;
    }

    @Column(name="ipv4address")
    public int getAddress() {
        return this.address;
    }

    @Override
    @Transient
    public InetAddress getInetAddress() {
        try {
            return Network4Address.intToInetAddress(this.address);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Transient
    public int getIntAddress() {
        return this.address;
    }

    @Override
    @XmlAttribute
    @Transient
    public String getIp() {
        return Network4Address.intToIP(this.address);
    }

    @Override
    @Transient
    public String getPrefix() {
        return Network4Address.intToIP(this.address) + "/" + this.prefixLength;
    }

    @Override
    @Column(name="ipv4mask")
    @XmlAttribute
    public int getPrefixLength() {
        return this.prefixLength;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.address;
        result = 31 * result + this.prefixLength;
        return result;
    }

    @Transient
    public boolean isBroadcast() {
        return this.address == -1;
    }

    @Transient
    public boolean isLoopback() {
        return (this.address >> 24 & 0xFF) == 127;
    }

    @Transient
    public boolean isMulticast() {
        return (this.address >> 28 & 0x1F) == 31;
    }

    @Transient
    public boolean isNormalUnicast() {
        return !this.isBroadcast() && !this.isLoopback() && !this.isMulticast() && !this.isUndefined();
    }

    @Transient
    public boolean isUndefined() {
        return this.address == 0;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void setPrefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    @Transient
    public int getSubnetMin() {
        return this.getIntAddress() & Network4Address.prefixLengthToIntAddress(this.getPrefixLength());
    }

    @Transient
    public int getSubnetMax() {
        return this.getSubnetMin() | ~Network4Address.prefixLengthToIntAddress(this.getPrefixLength());
    }

    public boolean contains(Network4Address otherAddress) {
        return this.address >> 32 - this.prefixLength == otherAddress.getIntAddress() >> 32 - this.prefixLength;
    }

    @Override
    @XmlElement
    @Column(name="ipv4usage")
    public NetworkAddress.AddressUsage getAddressUsage() {
        return this.addressUsage;
    }

    @Override
    public void setAddressUsage(NetworkAddress.AddressUsage usage) {
        this.addressUsage = usage;
    }
}

