/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.compliance.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.compliance.CheckResult;
import onl.netfishers.netshot.compliance.Policy;
import onl.netfishers.netshot.compliance.Rule;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDataProvider;
import onl.netfishers.netshot.device.DeviceDriver;
import org.hibernate.Session;

@Entity
public class TextRule
extends Rule {
    private String field;
    private String context;
    private String text;
    private boolean regExp = false;
    private boolean invert = false;
    private boolean anyBlock = false;
    private boolean matchAll = false;
    private String deviceDriver;
    private List<Pattern> hierarchy = new ArrayList<Pattern>();
    private boolean prepared = false;
    private boolean valid = false;
    private Pattern pattern = null;

    protected TextRule() {
    }

    public TextRule(String name, Policy policy) {
        super(name, policy);
    }

    @XmlElement
    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    @XmlElement
    @Column(length=10000)
    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    @XmlElement
    @Column(length=100000000)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.text != null) {
            this.text = this.text.replace("\r", "");
        }
    }

    @XmlElement
    public boolean isRegExp() {
        return this.regExp;
    }

    public void setRegExp(boolean regExp) {
        this.regExp = regExp;
    }

    @XmlElement
    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    @XmlElement
    public String getDeviceDriver() {
        return this.deviceDriver;
    }

    @Transient
    @XmlElement
    public String getDeviceDriverDescription() {
        if ("".equals(this.deviceDriver)) {
            return "";
        }
        try {
            DeviceDriver d = DeviceDriver.getDriverByName(this.deviceDriver);
            return d.getDescription();
        }
        catch (Exception e) {
            return "Unknown driver";
        }
    }

    public void setDeviceDriver(String deviceDriver) {
        this.deviceDriver = deviceDriver;
    }

    @XmlElement
    public boolean isAnyBlock() {
        return this.anyBlock;
    }

    public void setAnyBlock(boolean anyBlock) {
        this.anyBlock = anyBlock;
    }

    @XmlElement
    public boolean isMatchAll() {
        return this.matchAll;
    }

    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    private void prepare() {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        if (this.context != null && this.context.length() > 0) {
            String[] lines;
            for (String line : lines = this.context.split("\\r?\\n")) {
                try {
                    this.hierarchy.add(Pattern.compile(line));
                }
                catch (Exception e) {
                    return;
                }
            }
        }
        if (this.text == null || this.field == null) {
            return;
        }
        if (this.regExp) {
            try {
                this.pattern = Pattern.compile(this.text);
            }
            catch (Exception e) {
                return;
            }
        }
        this.valid = true;
    }

    private int findIndent(String line) {
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == ' ') continue;
            return i;
        }
        return line.length();
    }

    private List<String[]> findSections(String lines, Pattern pattern, String where) {
        return this.findSections(lines.split("\\n"), pattern, where);
    }

    private List<String[]> findSections(String[] lines, Pattern pattern, String where) {
        ArrayList<String[]> blocks = new ArrayList<String[]>();
        StringJoiner joiner = new StringJoiner("\n");
        String title = "";
        int indent = -1;
        for (String line : lines) {
            if (indent >= 0) {
                if (this.findIndent(line) > indent) {
                    joiner.add(line);
                } else {
                    blocks.add(new String[]{title, joiner.toString()});
                    indent = -1;
                }
            }
            if (indent >= 0 || !pattern.matcher(line).matches()) continue;
            indent = this.findIndent(line);
            joiner = new StringJoiner("\n");
            String trimmedLine = line.trim();
            title = where.length() > 0 ? where + " > " + trimmedLine : trimmedLine;
        }
        if (indent >= 0) {
            blocks.add(new String[]{title, joiner.toString()});
        }
        return blocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(Device device, Session session) {
        if (!this.isEnabled()) {
            this.setCheckResult(device, CheckResult.ResultOption.DISABLED, "", session);
            return;
        }
        this.prepare();
        if (!this.valid) {
            this.setCheckResult(device, CheckResult.ResultOption.INVALIDRULE, "", session);
            return;
        }
        if (this.deviceDriver != null && !"".equals(this.deviceDriver) && !this.deviceDriver.equals(device.getDriver())) {
            this.setCheckResult(device, CheckResult.ResultOption.NOTAPPLICABLE, "", session);
            return;
        }
        if (device.isExempted(this)) {
            this.setCheckResult(device, CheckResult.ResultOption.EXEMPTED, "", session);
            return;
        }
        DeviceDataProvider provider = new DeviceDataProvider(session, device);
        try {
            String content = provider.get(this.field).toString();
            content = content.replace("\r", "");
            ArrayList<String[]> blocks = new ArrayList<String[]>();
            blocks.add(new String[]{"", content});
            for (Pattern pattern : this.hierarchy) {
                ArrayList<String[]> selectedBlocks = new ArrayList<String[]>();
                for (String[] block : blocks) {
                    selectedBlocks.addAll(this.findSections(block[1], pattern, block[0]));
                }
                blocks = selectedBlocks;
            }
            provider.debug(String.format("Found %d block(s) matching the context.", blocks.size()));
            int b = 1;
            for (String[] block : blocks) {
                boolean doesMatch;
                boolean bl = doesMatch = this.regExp && (this.matchAll && this.pattern.matcher(block[1]).matches() || !this.matchAll && this.pattern.matcher(block[1]).find()) || !this.regExp && (this.matchAll && block[1].equals(this.text) || !this.matchAll && block[1].contains(this.text));
                if (!(doesMatch ^= this.invert)) {
                    provider.debug(String.format("Non matching block, number %d (in [%s])", b++, block[0]));
                    this.setCheckResult(device, CheckResult.ResultOption.NONCONFORMING, "", session);
                    return;
                }
                if (!this.anyBlock) continue;
                provider.debug(String.format("Matching block, number %d (in [%s])", b++, block[0]));
                this.setCheckResult(device, CheckResult.ResultOption.CONFORMING, "", session);
                return;
            }
            this.setCheckResult(device, CheckResult.ResultOption.CONFORMING, "", session);
        }
        catch (Exception e) {
            this.setCheckResult(device, CheckResult.ResultOption.NOTAPPLICABLE, "No such field.", session);
            return;
        }
        finally {
            this.logIt(provider.getLog());
        }
    }
}

