/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.history;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import org.netbeans.modules.git.remote.ui.history.RepositoryRevision;
import org.netbeans.modules.git.remote.ui.history.RevisionNode;
import org.netbeans.modules.git.remote.ui.history.SearchHistoryPanel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

class RevisionNodeChildren
extends Children.Keys<Object>
implements PropertyChangeListener {
    private final RepositoryRevision container;
    private final SearchHistoryPanel master;
    private boolean nodesCreated;
    private final PropertyChangeListener list;

    public RevisionNodeChildren(RepositoryRevision container, SearchHistoryPanel master) {
        this.container = container;
        this.master = master;
        this.list = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)container);
        container.addPropertyChangeListener("eventsChanged", this.list);
    }

    protected void addNotify() {
        this.refreshKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
    }

    private void refreshKeys() {
        if (this.container.expandEvents()) {
            this.setKeys(new Object[]{new Object()});
        } else {
            this.setKeys(this.container.getEvents());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.nodesCreated && "eventsChanged".equals(evt.getPropertyName()) && evt.getSource() == this.container) {
            this.refreshKeys();
        }
    }

    protected Node[] createNodes(Object fn) {
        this.nodesCreated = true;
        AbstractNode node = fn instanceof RepositoryRevision.Event ? new RevisionNode((RepositoryRevision.Event)fn, this.master) : new AbstractNode(Children.LEAF){

            public String getName() {
                return NbBundle.getMessage(RevisionNodeChildren.class, (String)"MSG_RevisionNodeChildren.Loading");
            }
        };
        return new Node[]{node};
    }
}

