/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.fetch;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRemoteConfig;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.ActionProgress;
import org.netbeans.modules.git.remote.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.remote.ui.fetch.Bundle;
import org.netbeans.modules.git.remote.ui.fetch.FetchFromUpstreamAction;
import org.netbeans.modules.git.remote.ui.fetch.FetchUtils;
import org.netbeans.modules.git.remote.ui.fetch.PullAction;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class PullFromUpstreamAction
extends MultipleRepositoryAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/remote/resources/icons/pull.png";

    public PullFromUpstreamAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected RequestProcessor.Task performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        ActionProgress p = this.pull(repository);
        return p == null ? null : p.getActionTask();
    }

    public ActionProgress pull(final VCSFileProxy repository) {
        final ActionProgress[] t = new ActionProgress[1];
        GitProgressSupport.NoOutputLogging supp = new GitProgressSupport.NoOutputLogging(){

            @Override
            protected void perform() {
                RepositoryInfo info = RepositoryInfo.getInstance(repository);
                try {
                    info.refreshRemotes();
                }
                catch (GitException ex) {
                    Logger.getLogger(FetchFromUpstreamAction.class.getName()).log(Level.INFO, null, ex);
                }
                String errorLabel = Bundle.LBL_Pull_pullFromUpstreamFailed();
                GitBranch trackedBranch = GitUtils.getTrackedBranch(info, errorLabel);
                if (trackedBranch == null) {
                    return;
                }
                GitRemoteConfig cfg = FetchUtils.getRemoteConfigForActiveBranch(trackedBranch, info, errorLabel);
                if (cfg == null) {
                    return;
                }
                String uri = (String)cfg.getUris().get(0);
                Utils.logVCSExternalRepository((String)"GIT", (String)uri);
                if (!this.isCanceled()) {
                    t[0] = ((PullAction)SystemAction.get(PullAction.class)).pull(repository, uri, cfg.getFetchRefSpecs(), trackedBranch.getName(), null);
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_PullFromUpstreamAction_preparing()).waitFinished();
        return t[0];
    }
}

