/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.actions;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;

public abstract class SingleRepositoryAction
extends GitAction {
    private static final Logger LOG = Logger.getLogger(SingleRepositoryAction.class.getName());

    protected SingleRepositoryAction() {
        this(null);
    }

    protected SingleRepositoryAction(String iconResource) {
        super(iconResource);
    }

    @Override
    protected final void performContextAction(final Node[] nodes) {
        Utils.postParallel((Runnable)new Runnable(){

            @Override
            public void run() {
                VCSContext context = SingleRepositoryAction.this.getCurrentContext(nodes);
                SingleRepositoryAction.this.performAction(context);
            }
        }, (int)0);
    }

    public final void performAction(VCSContext context) {
        Map.Entry<VCSFileProxy, VCSFileProxy[]> actionRoots = SingleRepositoryAction.getActionRoots(context);
        if (actionRoots != null) {
            GitUtils.logRemoteRepositoryAccess(actionRoots.getKey());
            this.performAction(actionRoots.getKey(), actionRoots.getValue(), context);
        }
    }

    protected abstract void performAction(VCSFileProxy var1, VCSFileProxy[] var2, VCSContext var3);

    protected static Map.Entry<VCSFileProxy, VCSFileProxy[]> getActionRoots(VCSContext context) {
        Set<VCSFileProxy> repositories = GitUtils.getRepositoryRoots(context);
        if (repositories.isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "No repository in the given context: {0}", context.getRootFiles());
            }
            return null;
        }
        AbstractMap.SimpleImmutableEntry<VCSFileProxy, VCSFileProxy[]> actionRoots = GitUtils.getActionRoots(context);
        if (actionRoots != null) {
            VCSFileProxy repository = actionRoots.getKey();
            if (repositories.size() > 1 && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Multiple repositories in the given context: {0}, selected {1}", new Object[]{context.getRootFiles(), repository});
            }
        }
        return actionRoots;
    }
}

