/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.ui.wizard.ProjectWizardPanels;
import org.netbeans.modules.cnd.makeproject.api.ui.wizard.WizardConstants;
import org.netbeans.modules.cnd.makeproject.api.wizards.MakeSampleProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.wizards.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewMakeProjectWizardIterator;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class MakeSampleProjectIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private static final long serialVersionUID = 4L;
    private transient int index = 0;
    private transient WizardDescriptor.Panel<WizardDescriptor> panel;
    private transient TemplateWizard wiz;
    private static ResourceBundle bundle;

    static Object create() {
        return new MakeSampleProjectIterator();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panel;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void initialize(WizardDescriptor wizard) {
        int i = 0;
        this.wiz = (TemplateWizard)wizard;
        String name = this.wiz.getTemplate().getNodeDelegate().getName();
        if (name != null) {
            name = name.replaceAll(" ", "");
        }
        WizardConstants.PROPERTY_NAME.put((WizardDescriptor)this.wiz, name);
        String wizardTitle = MakeSampleProjectIterator.getString("SAMPLE_PROJECT") + name;
        String wizardTitleACSD = MakeSampleProjectIterator.getString("SAMPLE_PROJECT_ACSD");
        this.panel = MakeSampleProjectIterator.getPanel(-1, name, wizardTitle, wizardTitleACSD, false);
        String[] steps = new String[1];
        JComponent jc = (JComponent)this.panel.getComponent();
        steps[i] = ((ProjectWizardPanels.NamedPanel)this.panel).getName();
        jc.putClientProperty("WizardPanel_contentData", steps);
        jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
    }

    public static ProjectWizardPanels.MakeSamplePanel<WizardDescriptor> getPanel(int wizardtype, String name, String wizardTitle, String wizardACSD, boolean fullRemote, String helpCtx) {
        return new PanelConfigureProject(name, wizardtype, wizardTitle, wizardACSD, fullRemote, helpCtx);
    }

    public static ProjectWizardPanels.MakeSamplePanel<WizardDescriptor> getPanel(int wizardtype, String name, String wizardTitle, String wizardACSD, boolean fullRemote) {
        return MakeSampleProjectIterator.getPanel(wizardtype, name, wizardTitle, wizardACSD, fullRemote, null);
    }

    public void uninitialize(WizardDescriptor templateWizard) {
        this.panel = null;
        this.index = -1;
        WizardConstants.PROPERTY_PROJECT_FOLDER.put((WizardDescriptor)this.wiz, null);
        WizardConstants.PROPERTY_NAME.put((WizardDescriptor)this.wiz, null);
    }

    public Set<?> instantiate(ProgressHandle handle) throws IOException {
        try {
            handle.start();
            Set<DataObject> set = this.instantiate();
            return set;
        }
        finally {
            handle.finish();
        }
    }

    public Set<DataObject> instantiate() throws IOException {
        FSPath projectLocation = WizardConstants.PROPERTY_PROJECT_FOLDER.get((WizardDescriptor)this.wiz);
        String name = WizardConstants.PROPERTY_NAME.get((WizardDescriptor)this.wiz);
        String hostUID = WizardConstants.PROPERTY_HOST_UID.get((WizardDescriptor)this.wiz);
        if (WizardConstants.PROPERTY_REMOTE_FILE_SYSTEM_ENV.get((WizardDescriptor)this.wiz) != null) {
            hostUID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        }
        CompilerSet toolchain = WizardConstants.PROPERTY_TOOLCHAIN.get((WizardDescriptor)this.wiz);
        boolean defaultToolchain = Boolean.TRUE.equals(WizardConstants.PROPERTY_TOOLCHAIN_DEFAULT.get((WizardDescriptor)this.wiz));
        ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(name, projectLocation);
        prjParams.setHostToolchain(hostUID, toolchain, defaultToolchain);
        Set resFO = MakeSampleProjectGenerator.createProjectFromTemplate((FileObject)this.wiz.getTemplate().getPrimaryFile(), (ProjectGenerator.ProjectParameters)prjParams);
        HashSet<DataObject> resDO = new HashSet<DataObject>();
        for (FileObject fo : resFO) {
            DataObject dao = DataObject.find((FileObject)fo);
            if (dao == null) continue;
            resDO.add(dao);
        }
        return resDO;
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(NewMakeProjectWizardIterator.class);
        }
        return bundle.getString(s);
    }
}

