/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.makeproject.api.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectLookupProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeLogicalViewModel;
import org.netbeans.modules.cnd.makeproject.ui.BrokenLinks;
import org.netbeans.modules.cnd.makeproject.ui.BrokenViewItemRefreshSupport;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewRootNode;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewRootNodeBroken;
import org.netbeans.modules.cnd.makeproject.ui.MakeTemplateListener;
import org.netbeans.modules.cnd.makeproject.ui.ProjectNodesRefreshSupport;
import org.netbeans.modules.cnd.makeproject.ui.ProjectTabBridge;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.InstanceContent;

public class MakeLogicalViewProvider
implements LogicalViewProvider,
MakeLogicalViewModel {
    private static MakeTemplateListener templateListener;
    private static final String brokenLinkBadgePath = "org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif";
    private static final String brokenProjectBadgePath = "org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif";
    private static final String brokenFolderBadgePath = "org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif";
    private static final String brokenIncludeImgPath = "org/netbeans/modules/cnd/makeproject/ui/resources/brokenIncludeBadge.png";
    static final Image brokenLinkBadge;
    static final Image brokenProjectBadge;
    static final Image brokenFolderBadge;
    static final Image brokenIncludeBadge;
    static final String SUBTYPE = "x-org-netbeans-modules-cnd-makeproject-uidnd";
    static final String SUBTYPE_FOLDER = "x-org-netbeans-modules-cnd-makeproject-uidnd-folder";
    static final String MASK = "mask";
    private final RequestProcessor annotationRP;
    private final MakeProject project;
    private MakeLogicalViewRootNode projectRootNode;
    private final Object lock = new Object();
    private boolean checkVersion = true;
    private final AtomicBoolean findPathMode = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MakeLogicalViewProvider(MakeProject project) {
        this.project = project;
        this.annotationRP = new RequestProcessor("MakeLogicalViewProvider.AnnotationUpdater " + project, 1);
        assert (project != null);
        Class<MakeLogicalViewProvider> clazz = MakeLogicalViewProvider.class;
        synchronized (MakeLogicalViewProvider.class) {
            if (templateListener == null) {
                templateListener = MakeTemplateListener.createInstance();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createLogicalView() {
        if (this.gotMakeConfigurationDescriptor()) {
            MakeConfigurationDescriptor configurationDescriptor = this.getMakeConfigurationDescriptor();
            if (configurationDescriptor == null) {
                return new MakeLogicalViewRootNodeBroken(this.project);
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.projectRootNode == null) {
                    this.createRoot(configurationDescriptor);
                }
                return this.projectRootNode;
            }
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.projectRootNode == null) {
                this.createLoadingRoot();
            }
            return this.projectRootNode;
        }
    }

    RequestProcessor getAnnotationRP() {
        return this.annotationRP;
    }

    private void createRoot(MakeConfigurationDescriptor configurationDescriptor) {
        InstanceContent ic = new InstanceContent();
        Folder logicalFolders = configurationDescriptor.getLogicalFolders();
        ic.add((Object)logicalFolders);
        this.addLookup(ic);
        this.projectRootNode = new MakeLogicalViewRootNode(logicalFolders, this, ic);
    }

    private void createLoadingRoot() {
        InstanceContent ic = new InstanceContent();
        this.addLookup(ic);
        this.projectRootNode = new MakeLogicalViewRootNode(null, this, ic);
    }

    public void reInit(MakeConfigurationDescriptor configurationDescriptor, boolean ignoreFutureVersion) {
        if (ignoreFutureVersion) {
            this.checkVersion = false;
        }
        if (this.projectRootNode != null) {
            this.projectRootNode.reInit(configurationDescriptor);
        }
    }

    public boolean isIncorectVersion() {
        if (this.checkVersion && this.gotMakeConfigurationDescriptor()) {
            int version = this.getMakeConfigurationDescriptor().getVersion();
            return version > 100;
        }
        return false;
    }

    private void addLookup(InstanceContent ic) {
        ic.add((Object)this.getProject());
        SearchInfoDefinition searchInfo = (SearchInfoDefinition)this.project.getLookup().lookup(SearchInfoDefinition.class);
        ic.add((Object)searchInfo);
        ic.add((Object)this.project, (InstanceContent.Convertor)new InstanceContent.Convertor<MakeProject, FileObject>(){

            public FileObject convert(MakeProject obj) {
                return obj.getProjectDirectory();
            }

            public Class<? extends FileObject> type(MakeProject obj) {
                return FileObject.class;
            }

            public String id(MakeProject obj) {
                FileObject fo = obj.getProjectDirectory();
                return fo == null ? "" : fo.getPath();
            }

            public String displayName(MakeProject obj) {
                return obj.toString();
            }
        });
        ic.add((Object)this.project, (InstanceContent.Convertor)new InstanceContent.Convertor<MakeProject, DataObject>(){

            public DataObject convert(MakeProject obj) {
                try {
                    FileObject fo = obj.getProjectDirectory();
                    return fo == null ? null : DataObject.find((FileObject)fo);
                }
                catch (DataObjectNotFoundException ex) {
                    return null;
                }
            }

            public Class<? extends DataObject> type(MakeProject obj) {
                return DataObject.class;
            }

            public String id(MakeProject obj) {
                FileObject fo = obj.getProjectDirectory();
                return fo == null ? "" : fo.getPath();
            }

            public String displayName(MakeProject obj) {
                return obj.toString();
            }
        });
    }

    boolean isFindPathMode() {
        return this.findPathMode.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node findPath(Node root, Object target) {
        Node returnNode = null;
        Project rootProject = (Project)root.getLookup().lookup(Project.class);
        if (rootProject == null) {
            return null;
        }
        if (target instanceof DataObject) {
            target = ((DataObject)target).getPrimaryFile();
        }
        if (!(target instanceof FileObject)) {
            return null;
        }
        FileObject fo = (FileObject)target;
        if (!this.gotMakeConfigurationDescriptor() || !fo.isValid()) {
            return null;
        }
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        Item item = makeConfigurationDescriptor.findItemByFileObject(fo);
        if (item == null && (item = makeConfigurationDescriptor.findExternalItemByPath(fo.getPath())) == null && (item = makeConfigurationDescriptor.findItemByPathSlowly(fo.getPath())) == null) {
            return null;
        }
        if (this.findPathMode.compareAndSet(false, true)) {
            try {
                Node folderNode = MakeLogicalViewProvider.findFolderNode(root, item.getFolder());
                if (folderNode != null) {
                    String checkName;
                    Item nodeItem;
                    Node[] nodes = folderNode.getChildren().getNodes(true);
                    int index = 0;
                    String name = item.getName();
                    for (index = 0; !(index >= nodes.length || (nodeItem = (Item)nodes[index].getValue("Item")) == item || nodeItem != null && name.equals(checkName = nodeItem.getName())); ++index) {
                    }
                    if (nodes.length > 0 && index < nodes.length) {
                        returnNode = nodes[index];
                    }
                }
            }
            finally {
                this.findPathMode.set(false);
            }
        }
        return returnNode;
    }

    private static Node findFolderNode(Node root, Folder folder) {
        if (root.getValue("Folder") == folder) {
            return root;
        }
        Folder parent = folder.getParent();
        if (parent == null) {
            return root;
        }
        Node parentNode = MakeLogicalViewProvider.findFolderNode(root, parent);
        if (parentNode == null) {
            return null;
        }
        Node[] nodes = parentNode.getChildren().getNodes(true);
        String id = folder.getId();
        for (int i = 0; i < nodes.length; ++i) {
            Object folderValue = nodes[i].getValue("Folder");
            if (folderValue == folder) {
                return nodes[i];
            }
            if (folderValue == null || !id.equals(((Folder)folderValue).getId())) continue;
            return nodes[i];
        }
        return null;
    }

    private static Node findItemNode(Node root, Item item) {
        Node parentNode = MakeLogicalViewProvider.findFolderNode(root, item.getFolder());
        if (parentNode != null) {
            Node[] nodes = parentNode.getChildren().getNodes(true);
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i].getValue("Item") != item) continue;
                return nodes[i];
            }
        }
        return null;
    }

    public static void setVisible(Project project, Folder folder) {
        Node rootNode = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
        Node projectRoot = MakeLogicalViewProvider.findProjectNode(rootNode, project);
        if (projectRoot == null) {
            return;
        }
        Node folderNode = MakeLogicalViewProvider.findFolderNode(projectRoot, folder);
        try {
            ProjectTabBridge.getInstance().getExplorerManager().setSelectedNodes(new Node[]{folderNode});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setVisible(Project project, Item[] items) {
        Runnable runnable = () -> SwingUtilities.invokeLater(() -> {
            Node rootNode = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (int i = 0; i < items.length; ++i) {
                Node root = MakeLogicalViewProvider.findProjectNode(rootNode, project);
                if (root == null) continue;
                nodes.add(MakeLogicalViewProvider.findItemNode(root, items[i]));
            }
            try {
                ProjectTabBridge.getInstance().getExplorerManager().setSelectedNodes(nodes.toArray(new Node[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        MakeLogicalViewProvider provider = (MakeLogicalViewProvider)project.getLookup().lookup(MakeLogicalViewProvider.class);
        if (provider != null) {
            provider.getAnnotationRP().post(runnable, 50);
        }
    }

    public void checkForChangedName() {
        MakeLogicalViewProvider.checkForChangedName((Project)this.project);
    }

    private static void checkForChangedName(Project project) {
        if (CndUtils.isStandalone()) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            ProjectInformation pi;
            Node rootNode = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
            Node root = MakeLogicalViewProvider.findProjectNode(rootNode, project);
            if (root != null && (pi = ProjectUtils.getInformation((Project)project)) != null) {
                root.setDisplayName(pi.getDisplayName());
            }
        });
    }

    public void checkForChangedViewItemNodes(ConfigurationDescriptorProvider.Delta delta) {
        MakeLogicalViewProvider.checkForChangedViewItemNodes((Project)this.project, delta);
    }

    private static void checkForChangedViewItemNodes(Project project, ConfigurationDescriptorProvider.Delta delta) {
        if (CndUtils.isStandalone()) {
            return;
        }
        if (delta.getAdded().isEmpty() && delta.getDeleted().isEmpty() && delta.getExcluded().isEmpty() && delta.getIncluded().isEmpty() && delta.getReplaced().isEmpty()) {
            return;
        }
        MakeLogicalViewProvider.refreshProjectNodes(project);
    }

    public void checkForChangedViewItemNodes(Folder folder, Item item) {
        MakeLogicalViewProvider.checkForChangedViewItemNodes((Project)this.project, folder, item);
    }

    private static void checkForChangedViewItemNodes(Project project, Folder folder, Item item) {
        if (CndUtils.isStandalone()) {
            return;
        }
        MakeLogicalViewProvider.refreshProjectNodes(project);
    }

    private static void refreshProjectNodes(Project project) {
        ProjectNodesRefreshSupport.refreshProjectNodes(project);
    }

    public void refreshBrokenItems() {
        MakeLogicalViewProvider.refreshBrokenItems((Project)this.project);
    }

    public static void refreshBrokenItems(Project project) {
        BrokenViewItemRefreshSupport.refreshBrokenItems(project);
    }

    private static Node getRootNode() {
        if (SwingUtilities.isEventDispatchThread()) {
            return ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
        }
        Node[] root = new Node[1];
        try {
            SwingUtilities.invokeAndWait(() -> {
                nodeArray[0] = MakeLogicalViewProvider.getRootNode();
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return root[0];
    }

    private static Node findProjectNode(Node root, Project p) {
        Node[] n = root.getChildren().getNodes(true);
        Lookup.Template t = new Lookup.Template(null, null, (Object)p);
        for (int cntr = 0; cntr < n.length; ++cntr) {
            if (n[cntr].getLookup().lookupItem(t) == null) continue;
            return n[cntr];
        }
        return null;
    }

    public boolean hasBrokenLinks() {
        List<BrokenLinks.BrokenLink> errs = BrokenLinks.getBrokenLinks((Project)this.project);
        return !errs.isEmpty();
    }

    private static Image loadToolTipImage(String imgResouce, String textResource) {
        Image img = ImageUtilities.loadImage((String)imgResouce);
        img = ImageUtilities.assignToolTipToImage((Image)img, (String)("<img src=\"" + MakeLogicalViewRootNode.class.getClassLoader().getResource(imgResouce) + "\">&nbsp;" + NbBundle.getMessage(MakeLogicalViewRootNode.class, (String)textResource)));
        return img;
    }

    static String getShortDescription(MakeProject project) {
        String prjDirDispName = FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory());
        ExecutionEnvironment devHost = project.getDevelopmentHost();
        if (devHost == null || devHost.isLocal()) {
            return NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"HINT_project_root_node", (Object)prjDirDispName);
        }
        return NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"HINT_project_root_node_on_host", (Object)prjDirDispName, (Object)devHost.getDisplayName());
    }

    MakeProject getProject() {
        return this.project;
    }

    MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
        return makeConfigurationDescriptor;
    }

    boolean gotMakeConfigurationDescriptor() {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        return pdp.gotDescriptor();
    }

    static {
        brokenLinkBadge = MakeLogicalViewProvider.loadToolTipImage("org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif", "BrokenLinkTxt");
        brokenProjectBadge = MakeLogicalViewProvider.loadToolTipImage("org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif", "BrokenProjectTxt");
        brokenFolderBadge = MakeLogicalViewProvider.loadToolTipImage("org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif", "BrokenFolderTxt");
        brokenIncludeBadge = MakeLogicalViewProvider.loadToolTipImage(brokenIncludeImgPath, "BrokenIncludeTxt");
    }

    public static class MakeLogicalViewProviderFactory
    implements MakeProjectLookupProvider {
        public void addLookup(MakeProject owner, ArrayList<Object> ic) {
            ic.add(new MakeLogicalViewProvider(owner));
        }
    }
}

