/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.CommitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class StashSaveCommand
extends GitCommand {
    private final boolean includeUntracked;
    private final String message;
    private GitRevisionInfo stash;
    private final ProgressMonitor monitor;

    public StashSaveCommand(JGitRepository repository, GitClassFactory accessor, String message, boolean includeUntracked, ProgressMonitor monitor) {
        super(repository, accessor, monitor);
        this.message = message;
        this.monitor = monitor;
        this.includeUntracked = includeUntracked;
    }

    @Override
    protected void prepare() throws GitException {
        this.setCommandsNumber(2);
        super.prepare();
        this.addArgument(0, "stash");
        this.addArgument(0, "save");
        if (this.includeUntracked) {
            this.addArgument(0, "--include-untracked");
        }
        this.addArgument(0, this.message);
        this.addArgument(1, "log");
        this.addArgument(1, "--raw");
        this.addArgument(1, "--pretty=raw");
        this.addArgument(1, "-1");
        this.addArgument(1, "stash@{0}");
    }

    public GitRevisionInfo getStashedCommit() {
        return this.stash;
    }

    @Override
    protected void run() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                    }
                }.runCLI();
                final GitRevisionInfo.GitRevCommit status = new GitRevisionInfo.GitRevCommit();
                new GitCommand.Runner(canceled, 1){

                    @Override
                    public void outputParser(String output) throws GitException {
                        CommitCommand.parseLog(output, status);
                    }
                }.runCLI();
                this.stash = this.getClassFactory().createRevisionInfo(status, this.getRepository());
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }
}

