/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.IgnoreRule;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.IgnoreUnignoreCommand;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public class IgnoreCommand
extends IgnoreUnignoreCommand {
    public IgnoreCommand(JGitRepository repository, GitClassFactory gitFactory, VCSFileProxy[] files, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, files, monitor, listener);
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "ignoring");
        this.addFiles(0, this.files);
    }

    @Override
    protected IgnoreUnignoreCommand.MatchResult addStatement(List<IgnoreRule> ignoreRules, VCSFileProxy gitIgnore, String path, boolean isDirectory, boolean rootIgnore, boolean writableIgnoreFile) throws IOException {
        IgnoreUnignoreCommand.MatchResult result = IgnoreUnignoreCommand.MatchResult.CHECK_PARENT;
        boolean changed = false;
        String escapedPath = IgnoreCommand.escapeChars(path);
        ListIterator<IgnoreRule> it = ignoreRules.listIterator(ignoreRules.size());
        while (it.hasPrevious()) {
            IgnoreRule rule = it.previous();
            if (!rule.isMatch(path, isDirectory)) continue;
            if (rule.getResult()) {
                if (result == IgnoreUnignoreCommand.MatchResult.NOT_IGNORED && escapedPath.equals(rule.getPattern(true))) {
                    if (!writableIgnoreFile) continue;
                    it.remove();
                    changed = true;
                    continue;
                }
                if (result == IgnoreUnignoreCommand.MatchResult.NOT_IGNORED) continue;
                result = IgnoreUnignoreCommand.MatchResult.IGNORED;
                continue;
            }
            if (escapedPath.equals(rule.getPattern(true))) {
                if (!writableIgnoreFile) continue;
                it.remove();
                changed = true;
                continue;
            }
            if (result == IgnoreUnignoreCommand.MatchResult.IGNORED) continue;
            result = IgnoreUnignoreCommand.MatchResult.NOT_IGNORED;
        }
        if (writableIgnoreFile && !result.equals((Object)IgnoreUnignoreCommand.MatchResult.IGNORED) && (result.equals((Object)IgnoreUnignoreCommand.MatchResult.NOT_IGNORED) || rootIgnore)) {
            if (escapedPath.startsWith("!")) {
                escapedPath = "\\" + escapedPath;
            }
            ignoreRules.add(new IgnoreRule(escapedPath));
            changed = true;
            result = IgnoreUnignoreCommand.MatchResult.IGNORED;
        }
        if (changed) {
            this.save(gitIgnore, ignoreRules);
        }
        return result;
    }

    @Override
    protected boolean handleAdditionalIgnores(String path, boolean directory) throws IOException {
        return this.checkExcludeFile(path, directory) != IgnoreUnignoreCommand.MatchResult.IGNORED && this.checkGlobalExcludeFile(path, directory) != IgnoreUnignoreCommand.MatchResult.IGNORED;
    }
}

