/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.util;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.openide.util.Parameters;

public class SourceUtils {
    private final CompilationController controller;
    private TypeElement typeElement;
    private ClassTree classTree;

    SourceUtils(CompilationController controller, TypeElement typeElement) {
        this.controller = controller;
        this.typeElement = typeElement;
    }

    SourceUtils(CompilationController controller, ClassTree classTree) {
        this.controller = controller;
        this.classTree = classTree;
    }

    public static SourceUtils newInstance(CompilationController controller, TypeElement typeElement) {
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        Parameters.notNull((CharSequence)"typeElement", (Object)typeElement);
        return new SourceUtils(controller, typeElement);
    }

    public static SourceUtils newInstance(CompilationController controller, ClassTree classTree) {
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        Parameters.notNull((CharSequence)"classTree", (Object)classTree);
        return new SourceUtils(controller, classTree);
    }

    public static SourceUtils newInstance(CompilationController controller) throws IOException {
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        ClassTree classTree = SourceUtils.findPublicTopLevelClass(controller);
        if (classTree != null) {
            return SourceUtils.newInstance(controller, classTree);
        }
        return null;
    }

    static ClassTree findPublicTopLevelClass(CompilationController controller) throws IOException {
        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        String mainElementName = controller.getFileObject().getName();
        CompilationUnitTree cunittree = controller.getCompilationUnit();
        if (cunittree != null) {
            for (Tree tree : cunittree.getTypeDecls()) {
                ClassTree classTree;
                if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(classTree = (ClassTree)tree).getSimpleName().contentEquals(mainElementName) || !classTree.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
                return classTree;
            }
        }
        return null;
    }

    public TypeElement getTypeElement() {
        if (this.typeElement == null) {
            assert (this.classTree != null);
            TreePath classTreePath = this.controller.getTrees().getPath(this.getCompilationController().getCompilationUnit(), this.classTree);
            this.typeElement = (TypeElement)this.controller.getTrees().getElement(classTreePath);
        }
        return this.typeElement;
    }

    public ClassTree getClassTree() {
        if (this.classTree == null) {
            assert (this.typeElement != null);
            this.classTree = this.controller.getTrees().getTree(this.typeElement);
        }
        return this.classTree;
    }

    public boolean isSubtype(String type) {
        Parameters.notNull((CharSequence)"type", (Object)type);
        TypeMirror typeMirror = this.getCompilationController().getTreeUtilities().parseType(type, this.getTypeElement());
        if (typeMirror != null) {
            return this.getCompilationController().getTypes().isSubtype(this.getTypeElement().asType(), typeMirror);
        }
        return false;
    }

    CompilationController getCompilationController() {
        return this.controller;
    }

    ExecutableElement getNoArgConstructor() throws IOException {
        this.controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        ElementUtilities elementUtils = this.controller.getElementUtilities();
        for (Element element : this.getTypeElement().getEnclosedElements()) {
            ExecutableElement constructor;
            if (element.getKind() != ElementKind.CONSTRUCTOR || (constructor = (ExecutableElement)element).getParameters().size() != 0 || elementUtils.isSynthetic((Element)constructor)) continue;
            return constructor;
        }
        return null;
    }
}

