/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Dialog;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.spi.features.AdvancedSecurityFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ClientDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ServiceDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ValidatorsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.MutualCertificates;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBase;
import org.netbeans.modules.websvc.wsitconf.util.DefaultSettings;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class MutualCertificatesProfile
extends ProfileBase
implements SecureConversationFeature,
ClientDefaultsFeature,
ServiceDefaultsFeature,
ValidatorsFeature,
AdvancedSecurityFeature {
    @Override
    public int getId() {
        return 20;
    }

    @Override
    public String getDisplayName() {
        return ComboConstants.PROF_MUTUALCERT;
    }

    @Override
    public String getDescription() {
        return ComboConstants.PROF_MUTUALCERT_INFO;
    }

    @Override
    public boolean isCurrentProfile(WSDLComponent component) {
        return this.getDisplayName().equals(ProfilesModelHelper.getWSITSecurityProfile(component));
    }

    @Override
    public void displayConfig(WSDLComponent component, UndoManager undoManager) {
        UndoCounter undoCounter = new UndoCounter();
        WSDLModel model = component.getModel();
        model.addUndoableEditListener((UndoableEditListener)undoCounter);
        MutualCertificates profConfigPanel = new MutualCertificates(component, this);
        DialogDescriptor dlgDesc = new DialogDescriptor((Object)profConfigPanel, this.getDisplayName());
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);
        dlg.setVisible(true);
        if (dlgDesc.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!undoManager.canUndo()) continue;
                undoManager.undo();
            }
        }
        model.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }

    @Override
    public void setServiceDefaults(WSDLComponent component, Project p) {
        ProprietarySecurityPolicyModelHelper.clearValidators(component);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, true, false);
        String storeLoc = ServerUtils.getStoreLocation(p, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, storeLoc, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreType(component, "JKS", false, false);
        ProprietarySecurityPolicyModelHelper.setStorePassword(component, DefaultSettings.getDefaultPassword(p), false, false);
        ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(component, "xws-security-server", false);
    }

    @Override
    public void setClientDefaults(WSDLComponent component, WSDLComponent serviceBinding, Project p) {
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, true, true);
        ProprietarySecurityPolicyModelHelper.removeCallbackHandlerConfiguration((Binding)component);
        String kstoreLoc = ServerUtils.getStoreLocation(p, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, kstoreLoc, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreType(component, "JKS", false, true);
        ProprietarySecurityPolicyModelHelper.setStorePassword(component, DefaultSettings.getDefaultPassword(p), false, true);
        String tstoreLoc = ServerUtils.getStoreLocation(p, true, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, tstoreLoc, true, true);
        ProprietarySecurityPolicyModelHelper.setStoreType(component, "JKS", true, true);
        ProprietarySecurityPolicyModelHelper.setStorePassword(component, DefaultSettings.getDefaultPassword(p), true, true);
        ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(component, "xws-security-client", true);
        ProprietarySecurityPolicyModelHelper.setTrustPeerAlias(component, "xws-security-server", true);
    }

    @Override
    public boolean isClientDefaultSetupUsed(WSDLComponent component, Binding serviceBinding, Project p) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(component)) {
            return false;
        }
        String keyAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(component, false);
        String trustAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(component, true);
        String trustPasswd = ProprietarySecurityPolicyModelHelper.getStorePassword(component, true);
        String keyPasswd = ProprietarySecurityPolicyModelHelper.getStorePassword(component, false);
        String keyLoc = ProprietarySecurityPolicyModelHelper.getStoreLocation(component, false);
        String trustLoc = ProprietarySecurityPolicyModelHelper.getStoreLocation(component, true);
        return Util.isEqual("xws-security-client", keyAlias) && Util.isEqual("xws-security-server", trustAlias) && Util.isEqual(DefaultSettings.getDefaultPassword(p), keyPasswd) && Util.isEqual(DefaultSettings.getDefaultPassword(p), trustPasswd) && Util.isEqual(ServerUtils.getStoreLocation(p, true, true), trustLoc) && Util.isEqual(ServerUtils.getStoreLocation(p, false, true), keyLoc);
    }

    @Override
    public boolean isServiceDefaultSetupUsed(WSDLComponent component, Project p) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(component)) {
            return false;
        }
        String storeAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(component, false);
        String storeLoc = ProprietarySecurityPolicyModelHelper.getStoreLocation(component, false);
        String storePasswd = ProprietarySecurityPolicyModelHelper.getStorePassword(component, false);
        if ("xws-security-server".equals(storeAlias)) {
            String defPassword = DefaultSettings.getDefaultPassword(p);
            String defLocation = ServerUtils.getStoreLocation(p, false, false);
            if (defPassword != null && defLocation != null && defPassword.equals(storePasswd) && defLocation.equals(storeLoc)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSecureConversation(WSDLComponent component) {
        ExtensibilityElement topSecBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(component);
        WSDLComponent protTokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)topSecBinding, ProtectionToken.class);
        WSDLComponent protToken = SecurityTokensModelHelper.getTokenTypeElement(protTokenKind);
        return protToken instanceof SecureConversationToken;
    }

    @Override
    public void enableSecureConversation(WSDLComponent component, boolean enable) {
        ProfilesModelHelper pmh = ProfilesModelHelper.getInstance(PolicyModelHelper.getConfigVersion(component));
        pmh.setSecureConversation(component, enable);
    }

    @Override
    public boolean isValidatorSupported(ConfigVersion cfgVersion, String validatorType) {
        return true;
    }
}

