/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.JUnitReportWriter;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class VerifyJNLP
extends Task {
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private File report;
    private boolean failOnError = true;

    public void addConfiguredFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void setReport(File report) {
        this.report = report;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void execute() throws BuildException {
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        for (FileSet fs : this.filesets) {
            DirectoryScanner s = fs.getDirectoryScanner(this.getProject());
            File basedir = s.getBasedir();
            for (String incl : s.getIncludedFiles()) {
                this.validate(new File(basedir, incl), results);
            }
        }
        JUnitReportWriter.writeReport(this, null, this.failOnError ? null : this.report, results);
    }

    private static void error(File jnlp, Map<String, String> results, String key, String message) {
        results.put(jnlp + "/test" + key, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(File jnlp, Map<String, String> results) {
        URI base;
        Document doc;
        this.log("Validating: " + jnlp);
        try {
            doc = XMLUtil.parse(new InputSource(jnlp.toURI().toString()), true, false, new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    this.fatalError(exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    this.fatalError(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw new SAXException("parse or validation error:\n" + exception.getSystemId() + ":" + exception.getLineNumber() + ": " + exception.getMessage());
                }
            }, new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if ("-//Sun Microsystems, Inc//DTD JNLP Descriptor 6.0//EN".equals(publicId)) {
                        return new InputSource(VerifyJNLP.class.getResource("JNLP-6.0.dtd").toString());
                    }
                    return null;
                }
            });
        }
        catch (Exception x) {
            VerifyJNLP.error(jnlp, results, "Parse", x.getMessage());
            return;
        }
        String codebase = doc.getDocumentElement().getAttribute("codebase");
        if (codebase.equals("$$codebase")) {
            base = jnlp.getParentFile().toURI();
        } else {
            try {
                base = new URI(codebase);
                if (!base.isAbsolute()) {
                    VerifyJNLP.error(jnlp, results, "Codebase", "non-absolute codebase " + base);
                    return;
                }
                if (!"file".equals(base.getScheme())) {
                    base = jnlp.getParentFile().toURI();
                }
            }
            catch (URISyntaxException x) {
                VerifyJNLP.error(jnlp, results, "Codebase", "invalid codebase " + codebase + "': " + x);
                return;
            }
        }
        Object[] existingCertificates = null;
        File existingSignedJar = null;
        NodeList nl = doc.getElementsByTagName("*");
        block13: for (int i = 0; i < nl.getLength(); ++i) {
            URI u;
            Element el = (Element)nl.item(i);
            String href = el.getAttribute("href");
            if (href.length() <= 0) continue;
            try {
                u = base.resolve(new URI(href));
            }
            catch (URISyntaxException x) {
                VerifyJNLP.error(jnlp, results, "Href", "invalid href '" + href + "': " + x);
                continue;
            }
            assert (u.isAbsolute()) : u + " not absolute as " + href + " resolved against " + base;
            if ("file".equals(u.getScheme())) {
                File f = new File(u);
                if (!f.isFile()) {
                    if (el.getTagName().equals("icon")) {
                        this.log(jnlp + ": warning: no such file " + f, 1);
                    } else if (!f.exists() && f.getName().startsWith("locale")) {
                        this.log("Localization file " + f + " is referenced, but cannot be found. Skipping.", 1);
                    } else {
                        VerifyJNLP.error(jnlp, results, "Href", "no such file " + f);
                        continue;
                    }
                }
                if (el.getTagName().equals("extension")) {
                    this.validate(f, results);
                    continue;
                }
                if (!el.getTagName().equals("jar") || !f.exists()) continue;
                try (JarFile jf = new JarFile(f, true);){
                    Enumeration<JarEntry> entries = jf.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (entry.getName().startsWith("META-INF/") || entry.getSize() < 1L) continue;
                        InputStream is = jf.getInputStream(entry);
                        int read = 0;
                        while (read != -1) {
                            read = is.read();
                        }
                        Object[] certs = entry.getCertificates();
                        if (existingSignedJar != null && !Arrays.equals(certs, existingCertificates)) {
                            VerifyJNLP.error(jnlp, results, "Signatures", "different signatures (or signing status) between " + existingSignedJar + " and " + f);
                            continue block13;
                        }
                        existingCertificates = certs;
                        existingSignedJar = f;
                        continue block13;
                    }
                }
                catch (IOException x) {
                    VerifyJNLP.error(jnlp, results, "Signatures", "error examining signatures in " + f + ": " + x);
                }
                continue;
            }
            try {
                u.toURL().openStream().close();
                continue;
            }
            catch (IOException x) {
                this.log(jnlp + ": could not open network URL " + u, 1);
            }
        }
    }
}

