/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2me.project.ui.customizer.AddAttributePanel;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEProjectProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class J2MEAttributesPanel
extends JPanel {
    private final JTable table;
    private final StorableTableModel tableModel;
    private final Map<String, Map<String, String>> configs;
    private final J2MEProjectProperties uiProperties;
    private final ListSelectionListener listSelectionListener;
    private final ActionListener actionListener;
    private JButton bAdd;
    private JButton bEdit;
    private JButton bRemove;
    private ButtonGroup buttonGroupModel;
    private JComboBox configCombo;
    private JButton configDel;
    private JLabel configLabel;
    private JButton configNew;
    private JPanel configPanel;
    private JCheckBox jCheckBoxOverride;
    private JLabel jLabelExpl;
    private JLabel jLabelModel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButtonLIBlet;
    private JRadioButton jRadioButtonSuite;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextField jTextFieldURL;
    private JLabel lTable;
    private JScrollPane scrollPane;

    public J2MEAttributesPanel(J2MEProjectProperties uiProperties) {
        this.uiProperties = uiProperties;
        this.initComponents();
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2MEAttributesPanel.class, (String)"ACSN_Jad"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2MEAttributesPanel.class, (String)"ACSD_Jad"));
        this.tableModel = this.uiProperties.ATTRIBUTES_TABLE_MODEL;
        this.table = new JTable(this.tableModel);
        this.scrollPane.setViewportView(this.table);
        this.table.setSelectionMode(0);
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                int row = J2MEAttributesPanel.this.table.getSelectedRow();
                boolean enabled = J2MEAttributesPanel.this.table.isEnabled() && row >= 0;
                J2MEAttributesPanel.this.bEdit.setEnabled(enabled);
                J2MEAttributesPanel.this.bRemove.setEnabled(enabled && !J2MEAttributesPanel.this.tableModel.containsInMandatory((String)J2MEAttributesPanel.this.tableModel.getValueAt(row, 1)));
            }
        };
        this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    J2MEAttributesPanel.this.bEditActionPerformed(null);
                }
            }
        });
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                J2MEAttributesPanel.this.jTextFieldURL.setEditable(J2MEAttributesPanel.this.jCheckBoxOverride.isSelected());
            }
        };
        this.jCheckBoxOverride.addActionListener(this.actionListener);
        this.configs = uiProperties.RUN_CONFIGS;
        this.configChanged(uiProperties.activeConfig);
        this.configCombo.setRenderer(new ConfigListCellRenderer());
        this.configCombo.setModel(uiProperties.CONFIGS_MODEL);
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.uiProperties.DEPLOYMENT_OVERRIDE_JARURL_MODEL.setMnemonic(this.jCheckBoxOverride.getMnemonic());
        this.jCheckBoxOverride.setModel(this.uiProperties.DEPLOYMENT_OVERRIDE_JARURL_MODEL);
        this.jTextFieldURL.setDocument(this.uiProperties.DEPLOYMENT_JARURL_MODEL);
        String liblet = this.uiProperties.getProject().evaluator().getProperty("manifest.is.liblet");
        this.jRadioButtonSuite.setSelected(liblet == null || liblet != null && liblet.equals(this.jRadioButtonSuite.getActionCommand()));
        this.jRadioButtonLIBlet.setSelected(liblet != null && liblet.equals(this.jRadioButtonLIBlet.getActionCommand()));
        this.tableModel.initManifestModel(this.jRadioButtonLIBlet.isSelected());
        this.tableModel.setDataDelegates(this.loadPropertyValues());
        this.table.setBackground(UIManager.getDefaults().getColor("Table.background"));
        this.tableModel.switchManifestModel(this.jRadioButtonLIBlet.isSelected());
        this.listSelectionListener.valueChanged(null);
        this.actionListener.actionPerformed(null);
    }

    private HashMap<String, String[]> loadPropertyValues() {
        String[] propertyNames = this.uiProperties.ATTRIBUTES_PROPERTY_NAMES;
        HashMap<String, String[]> values2configs = new HashMap<String, String[]>();
        for (Map.Entry<String, Map<String, String>> entry : this.uiProperties.RUN_CONFIGS.entrySet()) {
            String configName = entry.getKey();
            Map<String, String> configValues = entry.getValue();
            if (configValues == null) continue;
            String[] values = new String[propertyNames.length];
            values2configs.put(configName, values);
            for (int i = 0; i < values.length; ++i) {
                values[i] = configValues.get(propertyNames[i]);
                if (i != 0 || configName == null || values[i] != null && !values[i].isEmpty()) continue;
                values[i] = values2configs.get(null)[i];
            }
        }
        return values2configs;
    }

    private void initComponents() {
        this.buttonGroupModel = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabelModel = new JLabel();
        this.jRadioButtonSuite = new JRadioButton();
        this.jRadioButtonLIBlet = new JRadioButton();
        this.scrollPane = new JScrollPane();
        this.bRemove = new JButton();
        this.bEdit = new JButton();
        this.lTable = new JLabel();
        this.bAdd = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabelExpl = new JLabel();
        this.jTextFieldURL = new JTextField();
        this.jCheckBoxOverride = new JCheckBox();
        this.configPanel = new JPanel();
        this.configLabel = new JLabel();
        this.configCombo = new JComboBox();
        this.configNew = new JButton();
        this.configDel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabelModel, (String)NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MEAttributesPanel.jLabelModel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.jLabelModel, gridBagConstraints);
        this.buttonGroupModel.add(this.jRadioButtonSuite);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonSuite, (String)NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MEAttributesPanel.jRadioButtonSuite.text"));
        this.jRadioButtonSuite.setActionCommand(NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MEAttributesPanel.jRadioButtonSuite.actionCommand"));
        this.jRadioButtonSuite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEAttributesPanel.this.jRadioButtonSuiteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.jRadioButtonSuite, gridBagConstraints);
        this.buttonGroupModel.add(this.jRadioButtonLIBlet);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonLIBlet, (String)NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MEAttributesPanel.jRadioButtonLIBlet.text"));
        this.jRadioButtonLIBlet.setActionCommand(NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MEAttributesPanel.jRadioButtonLIBlet.actionCommand"));
        this.jRadioButtonLIBlet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEAttributesPanel.this.jRadioButtonLIBletActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.jRadioButtonLIBlet, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 8, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MEAttributesPanel.bRemove.text"));
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEAttributesPanel.this.bRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 12, 0, 8);
        this.add((Component)this.bRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bEdit, (String)NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MEAttributesPanel.bEdit.text"));
        this.bEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEAttributesPanel.this.bEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 12, 11, 8);
        this.add((Component)this.bEdit, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lTable, (String)NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MEAttributesPanel.lTable.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 8, 0, 4);
        this.add((Component)this.lTable, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bAdd, (String)NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MEAttributesPanel.bAdd.text"));
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEAttributesPanel.this.bAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 12, 11, 8);
        this.add((Component)this.bAdd, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabelExpl, (String)NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MEAttributesPanel.jLabelExpl.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.jLabelExpl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        this.jPanel2.add((Component)this.jTextFieldURL, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxOverride, (String)NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MEAttributesPanel.jCheckBoxOverride.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        this.jPanel2.add((Component)this.jCheckBoxOverride, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(0, 8, 8, 8);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.configPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MEAttributesPanel.configLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.configPanel.add((Component)this.configLabel, gridBagConstraints);
        this.configCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"<default>"}));
        this.configCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEAttributesPanel.this.configComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.configNew, (String)NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MEAttributesPanel.configNew.text"));
        this.configNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEAttributesPanel.this.configNewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configNew, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.configDel, (String)NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MEAttributesPanel.configDel.text"));
        this.configDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEAttributesPanel.this.configDelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configDel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 120;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 8, 0, 8);
        this.add((Component)this.configPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.jSeparator2, gridBagConstraints);
    }

    private void bRemoveActionPerformed(ActionEvent evt) {
        int i = this.table.getSelectedRow();
        if (i < 0) {
            return;
        }
        this.tableModel.removeRow(i);
        int max = this.tableModel.getRowCount();
        if (max <= 0) {
            this.table.getSelectionModel().clearSelection();
        } else if (i < max) {
            this.table.getSelectionModel().setSelectionInterval(i, i);
        } else {
            this.table.getSelectionModel().setSelectionInterval(max - 1, max - 1);
        }
    }

    private void bEditActionPerformed(ActionEvent evt) {
        final int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        final String key = (String)this.tableModel.getValueAt(row, 1);
        String value = (String)this.tableModel.getValueAt(row, 2);
        final AddAttributePanel add = new AddAttributePanel();
        add.init(true, this.tableModel, this.tableModel.getKeys(), key, value);
        DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(J2MEAttributesPanel.class, (String)"TITLE_EditAttribute"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx("org.netbeans.modules.j2me.project.ui.customizer.J2MEAttributesPanel"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotifyDescriptor.OK_OPTION.equals(e.getSource())) {
                    if (key == null || !key.equals(add.getKey())) {
                        if (key != null) {
                            J2MEAttributesPanel.this.tableModel.removeKey(key);
                        }
                        int newrow = J2MEAttributesPanel.this.tableModel.addRow(add.getKey(), add.getValue(), add.getPlacement());
                        J2MEAttributesPanel.this.table.getSelectionModel().setSelectionInterval(newrow, newrow);
                    } else {
                        J2MEAttributesPanel.this.tableModel.editRow(add.getKey(), add.getValue(), add.getPlacement());
                        J2MEAttributesPanel.this.table.getSelectionModel().setSelectionInterval(row, row);
                    }
                }
            }
        });
        add.setDialogDescriptor(dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
    }

    private void jRadioButtonSuiteActionPerformed(ActionEvent evt) {
        this.tableModel.switchManifestModel(this.jRadioButtonLIBlet.isSelected());
        this.uiProperties.putAdditionalProperty("manifest.is.liblet", Boolean.toString(this.jRadioButtonLIBlet.isSelected()));
    }

    private void jRadioButtonLIBletActionPerformed(ActionEvent evt) {
        this.tableModel.switchManifestModel(this.jRadioButtonLIBlet.isSelected());
        this.uiProperties.putAdditionalProperty("manifest.is.liblet", Boolean.toString(this.jRadioButtonLIBlet.isSelected()));
    }

    private void bAddActionPerformed(ActionEvent evt) {
        final AddAttributePanel add = new AddAttributePanel();
        add.init(false, this.tableModel, this.tableModel.getKeys(), null, null);
        DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(J2MEAttributesPanel.class, (String)"TITLE_AddAttribute"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx("org.netbeans.modules.j2me.project.ui.customizer.AddAttributePanel"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotifyDescriptor.OK_OPTION.equals(e.getSource())) {
                    int row = J2MEAttributesPanel.this.tableModel.addRow(add.getKey(), add.getValue(), add.getPlacement());
                    J2MEAttributesPanel.this.table.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        });
        add.setDialogDescriptor(dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
    }

    private void configComboActionPerformed(ActionEvent evt) {
        String config = (String)this.configCombo.getSelectedItem();
        if (config.length() == 0) {
            config = null;
        }
        this.configChanged(config);
        this.uiProperties.activeConfig = config;
    }

    private void configNewActionPerformed(ActionEvent evt) {
        this.createNewConfiguration();
    }

    private void configDelActionPerformed(ActionEvent evt) {
        String config = (String)this.configCombo.getSelectedItem();
        assert (config != null);
        this.configs.put(config, null);
        this.configChanged(null);
        this.uiProperties.activeConfig = null;
    }

    private void createNewConfiguration() {
        NotifyDescriptor.InputLine d = new NotifyDescriptor.InputLine(NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MERunPanel.input.prompt"), NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MERunPanel.input.title"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        String name = d.getInputText();
        String config = name.replaceAll("[^a-zA-Z0-9_.-]", "_");
        if (config.trim().length() == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MERunPanel.input.empty", (Object)config), 2));
            return;
        }
        if (this.configs.get(config) != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2MEAttributesPanel.class, (String)"J2MERunPanel.input.duplicate", (Object)config), 2));
            return;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        if (!name.equals(config)) {
            m.put("$label", name);
        }
        this.configs.put(config, m);
        this.configChanged(config);
        this.uiProperties.activeConfig = config;
    }

    private void configChanged(String activeConfig) {
        this.uiProperties.CONFIGS_MODEL = new DefaultComboBoxModel();
        this.uiProperties.CONFIGS_MODEL.addElement("");
        TreeSet<String> alphaConfigs = new TreeSet<String>(new Comparator<String>(){
            Collator coll = Collator.getInstance();

            @Override
            public int compare(String s1, String s2) {
                return this.coll.compare(this.label(s1), this.label(s2));
            }

            private String label(String c) {
                Map m = (Map)J2MEAttributesPanel.this.configs.get(c);
                String label = (String)m.get("$label");
                return label != null ? label : c;
            }
        });
        for (Map.Entry<String, Map<String, String>> entry : this.configs.entrySet()) {
            String config = entry.getKey();
            if (config == null || entry.getValue() == null) continue;
            alphaConfigs.add(config);
        }
        for (String c : alphaConfigs) {
            this.uiProperties.CONFIGS_MODEL.addElement(c);
        }
        this.configCombo.setModel(this.uiProperties.CONFIGS_MODEL);
        this.configCombo.setSelectedItem(activeConfig != null ? activeConfig : "");
        Map<String, String> m = this.configs.get(activeConfig);
        if (m != null) {
            this.uiProperties.storeAttributesToRunConfigs();
            this.tableModel.CONFIG = activeConfig;
            this.tableModel.setDataDelegates(this.loadPropertyValues());
        }
        this.configDel.setEnabled(activeConfig != null);
    }

    private final class ConfigListCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ConfigListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String label;
            this.setName("ComboBox.listRenderer");
            String config = (String)value;
            if (config == null) {
                label = null;
            } else if (config.length() > 0) {
                Map m = (Map)J2MEAttributesPanel.this.configs.get(config);
                String string = label = m != null ? (String)m.get("$label") : null;
                if (label == null) {
                    label = config;
                }
            } else {
                label = NbBundle.getBundle((String)"org.netbeans.modules.java.j2seproject.Bundle").getString("J2SEConfigurationProvider.default.label");
            }
            this.setText(label);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    static class StorableTableModel
    extends AbstractTableModel {
        public String CONFIG;
        private final HashMap<String, HashMap<String, String>> othersMap;
        private final HashMap<String, HashMap<String, String>> jadMap;
        private final HashMap<String, HashMap<String, String>> manifestMap;
        private final ArrayList<String> items = new ArrayList();
        private boolean isLIBlet;
        private String[] additionalAttributes = null;
        private static final String NAME = "MIDlet-Name";
        private static final String VENDOR = "MIDlet-Vendor";
        private static final String VERSION = "MIDlet-Version";
        private static final String ICON = "MIDlet-Icon";
        private static final String DESCRIPTION = "MIDlet-Description";
        private static final String INFOURL = "MIDlet-Info-URL";
        private static final String DATASIZE = "MIDlet-Data-Size";
        private static final String MECONFIG = "MicroEdition-Configuration";
        private static final String MEPROFILE = "MicroEdition-Profile";
        private static final String INSTALL = "MIDlet-Install-Notify";
        private static final String DELETE = "MIDlet-Delete-Notify";
        private static final String CONFIRM = "MIDlet-Delete-Confirm";
        private static final String FONT = "MIDlet-Font";
        private static final String MINCANVAS = "MIDlet-Minimum-Canvas-Size";
        private static final String MAXCANVAS = "MIDlet-Maximum-Canvas-Size";
        private static final String SPLASH = "MIDlet-Splash-Screen-Image";
        private static final String USERDENIED = "MIDlet-UserDenied";
        private static final String UPDATEURL = "MIDlet-Update-URL";
        private static final String IPVERSION = "MIDlet-Required-IP-Version";
        private static final String SCICON = "MIDlet-Scalable-Icon";
        private static final String LNAME = "LIBlet-Name";
        private static final String LVENDOR = "LIBlet-Vendor";
        private static final String LVERSION = "LIBlet-Version";
        private static final String LDESCRIPTION = "LIBlet-Description";
        private static final String LNONSHAREDDATA = "LIBlet-NonShared-Data-Size";
        private static final String LSHAREDDATA = "LIBlet-Shared-Data-Size";
        private static final String LINSTALL = "LIBlet-Install-Notify";
        private static final String LICON = "LIBlet-Icon";
        private static final String LDELETE = "LIBlet-Delete-Notify";
        private static final String LFONT = "LIBlet-Font";
        private static final String[][] mandatoryProperties = new String[][]{{"LIBlet-Name", "LIBlet-Vendor", "LIBlet-Version"}, {"MIDlet-Name", "MIDlet-Vendor", "MIDlet-Version"}};
        private static final String[][] nonmandatoryProperties = new String[][]{{"LIBlet-Description", "LIBlet-NonShared-Data-Size", "LIBlet-Shared-Data-Size", "LIBlet-Install-Notify", "LIBlet-Icon", "LIBlet-Delete-Notify", "LIBlet-Font"}, {"MIDlet-Icon", "MIDlet-Description", "MIDlet-Info-URL", "MIDlet-Data-Size", "MIDlet-Install-Notify", "MIDlet-Delete-Notify", "MIDlet-Delete-Confirm", "MicroEdition-Configuration", "MicroEdition-Profile"}, {"MIDlet-Icon", "MIDlet-Description", "MIDlet-Info-URL", "MIDlet-Data-Size", "MIDlet-Install-Notify", "MIDlet-Delete-Notify", "MIDlet-Delete-Confirm", "MicroEdition-Configuration", "MicroEdition-Profile"}, {"MIDlet-Icon", "MIDlet-Description", "MIDlet-Info-URL", "MIDlet-Data-Size", "MIDlet-Install-Notify", "MIDlet-Delete-Notify", "MIDlet-Delete-Confirm", "MIDlet-Font", "MIDlet-Minimum-Canvas-Size", "MIDlet-Maximum-Canvas-Size", "MIDlet-Splash-Screen-Image", "MIDlet-UserDenied", "MIDlet-Update-URL", "MIDlet-Required-IP-Version", "MIDlet-Scalable-Icon", "MicroEdition-Configuration", "MicroEdition-Profile"}};
        private static final String[] riskyProperties = new String[]{"MicroEdition-Configuration", "MicroEdition-Profile"};
        private static final long serialVersionUID = -2195421895353167160L;
        private final J2MEProjectProperties uiProperties;
        private boolean dataDelegatesWereSet = false;

        public StorableTableModel(J2MEProjectProperties uiProperties) {
            this.uiProperties = uiProperties;
            this.othersMap = new HashMap();
            this.jadMap = new HashMap();
            this.manifestMap = new HashMap();
            this.CONFIG = uiProperties.activeConfig;
        }

        public void initManifestModel(boolean isLIBlet) {
            this.isLIBlet = isLIBlet;
        }

        public HashSet<String> getKeys() {
            return new HashSet<String>(this.items);
        }

        @Override
        public int getRowCount() {
            return this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return NbBundle.getMessage(J2MEAttributesPanel.class, (String)"LBL_Jad_Column_Type");
                }
                case 1: {
                    return NbBundle.getMessage(J2MEAttributesPanel.class, (String)"LBL_Jad_Column_Key");
                }
                case 2: {
                    return NbBundle.getMessage(J2MEAttributesPanel.class, (String)"LBL_Jad_Column_Value");
                }
            }
            return null;
        }

        public void switchManifestModel(boolean toLIBlet) {
            this.uiProperties.LIBLET_PACKAGING = this.isLIBlet = toLIBlet;
            String FROM = toLIBlet ? "MIDlet-" : "LIBlet-";
            String TO = toLIBlet ? "LIBlet-" : "MIDlet-";
            for (int i = 0; i < this.items.size(); ++i) {
                String key = this.items.get(i);
                if (!key.startsWith(FROM)) continue;
                String newKey = TO + key.substring(FROM.length());
                if (!StorableTableModel.contains(this.getMandatory(), newKey) && !StorableTableModel.contains(this.getNonMandatory(), newKey)) continue;
                this.items.set(i, newKey);
                this.fireTableRowsUpdated(i, i);
            }
            for (String configName : this.manifestMap.keySet()) {
                HashSet<String> allKeys = new HashSet<String>(this.manifestMap.get(configName).keySet());
                allKeys.addAll(this.othersMap.get(configName).keySet());
                allKeys.addAll(this.jadMap.get(configName).keySet());
                for (String key : allKeys) {
                    if (!key.startsWith(FROM)) continue;
                    String newKey = TO + key.substring(FROM.length());
                    if (!StorableTableModel.contains(this.getMandatory(), newKey) && !StorableTableModel.contains(this.getNonMandatory(), newKey)) continue;
                    String v = this.othersMap.get(configName).remove(key);
                    if (v != null) {
                        this.othersMap.get(configName).put(newKey, v);
                    }
                    if ((v = this.jadMap.get(configName).remove(key)) != null) {
                        this.jadMap.get(configName).put(newKey, v);
                    }
                    if ((v = this.manifestMap.get(configName).remove(key)) == null) continue;
                    this.manifestMap.get(configName).put(newKey, v);
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return null;
        }

        public synchronized HashMap[] getDataDelegates() {
            if (!this.dataDelegatesWereSet) {
                String[] propertyNames = this.uiProperties.ATTRIBUTES_PROPERTY_NAMES;
                HashMap<String, String[]> values2configs = new HashMap<String, String[]>();
                for (Map.Entry<String, Map<String, String>> entry : this.uiProperties.RUN_CONFIGS.entrySet()) {
                    String configName = entry.getKey();
                    Map<String, String> configValues = entry.getValue();
                    String[] values = new String[propertyNames.length];
                    values2configs.put(configName, values);
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = configValues.get(propertyNames[i]);
                        if (configName == null || values[i] != null && !values[i].isEmpty()) continue;
                        values[i] = values2configs.get(null)[i];
                    }
                }
                this.setDataDelegates(values2configs);
            }
            this.updateMapsFromItems();
            return new HashMap[]{this.othersMap, this.jadMap, this.manifestMap};
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            assert (rowIndex < this.items.size());
            switch (columnIndex) {
                case 0: {
                    String value;
                    String item = this.items.get(rowIndex);
                    if (this.containsInMandatory(item)) {
                        value = NbBundle.getMessage(J2MEAttributesPanel.class, (String)"LBL_CustomJad_Required");
                    } else if (this.containsInRisky(item)) {
                        value = NbBundle.getMessage(J2MEAttributesPanel.class, (String)"LBL_CustomJad_Risky");
                    } else if (this.containsInNonMandatory(item)) {
                        value = NbBundle.getMessage(J2MEAttributesPanel.class, (String)"LBL_CustomJad_Optional");
                    } else {
                        Boolean b = this.getPlacement(item);
                        value = NbBundle.getMessage(J2MEAttributesPanel.class, (String)("LBL_CustomJad_Custom" + (b == null ? "" : (b != false ? "_J" : "_M"))));
                    }
                    return value;
                }
                case 1: {
                    return this.items.get(rowIndex);
                }
                case 2: {
                    String value = this.othersMap.get(this.CONFIG).get(this.items.get(rowIndex));
                    if (value == null) {
                        value = this.jadMap.get(this.CONFIG).get(this.items.get(rowIndex));
                    }
                    if (value == null) {
                        value = this.manifestMap.get(this.CONFIG).get(this.items.get(rowIndex));
                    }
                    if (value == null) {
                        value = "";
                    }
                    return value;
                }
            }
            return null;
        }

        public synchronized void setDataDelegates(HashMap<String, String[]> values2configs) {
            assert (values2configs != null);
            for (Map.Entry<String, String[]> entry : values2configs.entrySet()) {
                String configName = entry.getKey();
                String[] data = entry.getValue();
                this.othersMap.put(configName, data[0] == null ? new HashMap() : (HashMap)this.uiProperties.decode(data[0]));
                this.jadMap.put(configName, data[1] == null ? new HashMap() : (HashMap)this.uiProperties.decode(data[1]));
                this.manifestMap.put(configName, data[2] == null ? new HashMap() : (HashMap)this.uiProperties.decode(data[2]));
            }
            this.updateItemsFromMaps();
            this.fireTableDataChanged();
            this.dataDelegatesWereSet = true;
        }

        public synchronized void updateItemsFromMaps() {
            String liblet = this.uiProperties.getProject().evaluator().getProperty("manifest.is.liblet");
            if (liblet != null && Boolean.valueOf(liblet).booleanValue()) {
                this.switchManifestModel(true);
            }
            this.items.clear();
            ArrayList<String> keys = new ArrayList<String>(this.othersMap.get(this.CONFIG).keySet());
            keys.addAll(this.jadMap.get(this.CONFIG).keySet());
            keys.addAll(this.manifestMap.get(this.CONFIG).keySet());
            for (String mandatory : this.getMandatory()) {
                this.items.add(mandatory);
                keys.remove(mandatory);
            }
            Object[] strKeys = keys.toArray(new String[keys.size()]);
            Arrays.sort(strKeys);
            this.items.addAll(Arrays.asList(strKeys));
        }

        public synchronized void updateMapsFromItems() {
            HashMap<String, String> res1 = new HashMap<String, String>();
            HashMap<String, String> res2 = new HashMap<String, String>();
            HashMap<String, String> res3 = new HashMap<String, String>();
            for (int a = 0; a < this.items.size(); ++a) {
                String key = this.items.get(a);
                String value = this.manifestMap.get(this.CONFIG).get(key);
                if (value != null) {
                    res3.put(key, value);
                    continue;
                }
                value = this.jadMap.get(this.CONFIG).get(key);
                if (value != null) {
                    res2.put(key, value);
                    continue;
                }
                value = this.othersMap.get(this.CONFIG).get(key);
                res1.put(key, value == null ? "" : value);
            }
            this.othersMap.put(this.CONFIG, res1);
            this.jadMap.put(this.CONFIG, res2);
            this.manifestMap.put(this.CONFIG, res3);
        }

        private static boolean contains(String[] array, String item) {
            for (String array1 : array) {
                if (!array1.equals(item)) continue;
                return true;
            }
            return false;
        }

        public String[] getMandatory() {
            return mandatoryProperties[this.isLIBlet ? 0 : 1];
        }

        public String[] getNonMandatory() {
            if (this.additionalAttributes == null) {
                this.additionalAttributes = this.loadAdditionalAttributes();
            }
            return this.mergeAttributes(nonmandatoryProperties[this.isLIBlet ? 0 : 1], this.additionalAttributes);
        }

        public String[] getAllAttrs() {
            return this.mergeAttributes(this.getMandatory(), this.getNonMandatory());
        }

        public boolean containsInMandatory(String item) {
            return StorableTableModel.contains(this.getMandatory(), item);
        }

        public boolean containsInRisky(String item) {
            return StorableTableModel.contains(riskyProperties, item);
        }

        public boolean containsInNonMandatory(String item) {
            return StorableTableModel.contains(this.getNonMandatory(), item);
        }

        public boolean containsInAllAttrs(String item) {
            return StorableTableModel.contains(this.getAllAttrs(), item);
        }

        public boolean isAcceptable(String key) {
            if (key == null) {
                return false;
            }
            if (!key.startsWith("MIDlet-") && !key.startsWith("LIBlet-")) {
                return true;
            }
            return this.containsInAllAttrs(key);
        }

        public int addRow(String key, String value, Boolean placement) {
            if (key == null || this.items.contains(key)) {
                return -1;
            }
            int row = this.items.size();
            this.othersMap.get(this.CONFIG).remove(key);
            this.jadMap.get(this.CONFIG).remove(key);
            this.manifestMap.get(this.CONFIG).remove(key);
            if (placement == null) {
                this.othersMap.get(this.CONFIG).put(key, value);
            } else if (placement.booleanValue()) {
                this.jadMap.get(this.CONFIG).put(key, value);
            } else {
                this.manifestMap.get(this.CONFIG).put(key, value);
            }
            this.items.add(key);
            this.fireTableRowsInserted(row, row);
            return row;
        }

        public void editRow(String key, String value, Boolean placement) {
            int row = this.items.indexOf(key);
            if (row < 0) {
                return;
            }
            this.othersMap.get(this.CONFIG).remove(key);
            this.jadMap.get(this.CONFIG).remove(key);
            this.manifestMap.get(this.CONFIG).remove(key);
            if (placement == null) {
                this.othersMap.get(this.CONFIG).put(key, value);
            } else if (placement.booleanValue()) {
                this.jadMap.get(this.CONFIG).put(key, value);
            } else {
                this.manifestMap.get(this.CONFIG).put(key, value);
            }
            this.fireTableRowsUpdated(row, row);
        }

        public Boolean getPlacement(String key) {
            if (this.jadMap.containsKey(key)) {
                return Boolean.TRUE;
            }
            if (this.manifestMap.containsKey(key)) {
                return Boolean.FALSE;
            }
            return null;
        }

        public void removeRow(int row) {
            assert (row < this.items.size());
            if (this.containsInMandatory(this.items.get(row))) {
                return;
            }
            this.items.remove(row);
            this.fireTableRowsDeleted(row, this.items.size() + 1);
        }

        public void removeKey(String key) {
            int row = this.items.indexOf(key);
            if (row < 0) {
                return;
            }
            this.removeRow(row);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] loadAdditionalAttributes() {
            ArrayList<String> attrs = new ArrayList<String>();
            FileObject xml = FileUtil.getConfigFile((String)"Buildsystem/ApplicationDescriptor/Attributes");
            if (xml == null) {
                return new String[0];
            }
            FileObject[] entries = xml.getChildren();
            for (FileObject fileObject : Arrays.asList(entries)) {
                InputStream is = null;
                try {
                    is = fileObject.getInputStream();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                        String s;
                        while ((s = reader.readLine()) != null) {
                            if (attrs.contains(s = s.trim()) || s.length() == 0) continue;
                            attrs.add(s);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return attrs.toArray(new String[attrs.size()]);
        }

        private String[] mergeAttributes(String[] a, String[] b) {
            String[] s = new String[a.length + b.length];
            System.arraycopy(a, 0, s, 0, a.length);
            System.arraycopy(b, 0, s, a.length, b.length);
            return s;
        }
    }
}

