/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli.commands;

import java.io.IOException;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;

public class PropertySetCommand
extends SvnCommand {
    private final PropType type;
    private final VCSFileProxy file;
    private final String propName;
    private final String propValue;
    private final VCSFileProxy propFile;
    private final boolean recursivelly;

    public PropertySetCommand(FileSystem fileSystem, String propName, String propValue, VCSFileProxy file, boolean recursivelly) {
        super(fileSystem);
        this.file = file;
        this.propName = propName;
        this.propValue = propValue;
        this.recursivelly = recursivelly;
        this.propFile = null;
        this.type = PropType.string;
    }

    public PropertySetCommand(FileSystem fileSystem, String propName, VCSFileProxy propFile, VCSFileProxy file, boolean recursivelly) {
        super(fileSystem);
        this.file = file;
        this.propName = propName;
        this.propFile = propFile;
        this.recursivelly = recursivelly;
        this.propValue = null;
        this.type = PropType.file;
    }

    @Override
    protected ISVNNotifyListener.Command getCommand() {
        return ISVNNotifyListener.Command.PROPSET;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("propset");
        if (this.recursivelly) {
            arguments.add("-R");
        }
        switch (this.type) {
            case string: {
                arguments.add(this.propName);
                String propFileName = this.createTempCommandFile(this.propValue);
                arguments.add("-F");
                arguments.add(propFileName);
                arguments.add(this.file);
                break;
            }
            case file: {
                arguments.add(this.propName);
                arguments.add("-F");
                arguments.add(this.propFile);
                arguments.add(this.file);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal proptype: " + (Object)((Object)this.type));
            }
        }
    }

    private static enum PropType {
        string,
        file;

    }
}

