/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.versioning.util;

import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.filesystems.FileObject;

public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());

    public static VCSFileProxy getProjectFile(VCSContext context) {
        return Utils.getProjectFile(Utils.getProject(context));
    }

    public static VCSFileProxy getProjectFile(Project project) {
        if (project == null) {
            return null;
        }
        return VCSFileProxy.createFileProxy((FileObject)project.getProjectDirectory());
    }

    public static Project getProject(VCSContext context) {
        if (context == null) {
            return null;
        }
        return Utils.getProject(context.getRootFiles().toArray(new VCSFileProxy[context.getRootFiles().size()]));
    }

    public static Project getProject(VCSFileProxy[] files) {
        for (VCSFileProxy file : files) {
            FileObject fo;
            if (!file.exists()) {
                file = file.getParentFile();
            }
            if ((fo = file.toFileObject()) == null) {
                LOG.log(Level.FINE, "Utils.getProjectFile(): No FileObject for {0}", file);
                continue;
            }
            Project p = FileOwnerQuery.getOwner((FileObject)fo);
            if (p != null) {
                return p;
            }
            LOG.log(Level.FINE, "Utils.getProjectFile(): No project for {0}", file);
        }
        return null;
    }

    public static VCSFileProxy[] getProjectRootFiles(Project project) {
        if (project == null) {
            return null;
        }
        HashSet<VCSFileProxy> set = new HashSet<VCSFileProxy>();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
        for (int j = 0; j < sourceGroups.length; ++j) {
            SourceGroup sourceGroup = sourceGroups[j];
            FileObject srcRootFo = sourceGroup.getRootFolder();
            VCSFileProxy rootFile = VCSFileProxy.createFileProxy((FileObject)srcRootFo);
            set.add(rootFile);
        }
        return set.toArray(new VCSFileProxy[set.size()]);
    }
}

