/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.ModelUtils;
import org.netbeans.modules.cnd.highlight.semantic.ReferenceCollector;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntity;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.NamedOption;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class SemanticEntitiesProvider {
    private final List<SemanticEntity> list;

    public List<SemanticEntity> get() {
        return this.list;
    }

    private SemanticEntitiesProvider() {
        if (HighlighterBase.MINIMAL) {
            this.list = new ArrayList<SemanticEntity>();
            this.list.add((SemanticEntity)((Object)Lookup.getDefault().lookup(SemanticEntity.class)));
        } else {
            this.list = new ArrayList<SemanticEntity>(Lookup.getDefault().lookupAll(SemanticEntity.class));
        }
    }

    public static SemanticEntitiesProvider instance() {
        return Instantiator.instance;
    }

    private static class Instantiator {
        static SemanticEntitiesProvider instance = new SemanticEntitiesProvider();

        private Instantiator() {
        }
    }

    private static abstract class AbstractSemanticEntity
    extends SemanticEntity {
        private final ConcurrentHashMap<String, AttributeSet> color = new ConcurrentHashMap();
        private final FontColorProvider.Entity entity;
        private static final AttributeSet cleanUp = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Underline, null, StyleConstants.StrikeThrough, null, StyleConstants.Background, null, EditorStyleConstants.WaveUnderlineColor, null, EditorStyleConstants.Tooltip, null});

        public AbstractSemanticEntity() {
            this.entity = null;
        }

        public AbstractSemanticEntity(FontColorProvider.Entity entity) {
            this.entity = entity;
        }

        protected AttributeSet getColor(String mimeType) {
            return this.color.get(mimeType);
        }

        @Override
        public void updateFontColors(FontColorProvider provider) {
            assert (this.entity != null);
            this.color.put(provider.getMimeType(), AbstractSemanticEntity.getFontColor(provider, this.entity));
        }

        protected static AttributeSet getFontColor(FontColorProvider provider, FontColorProvider.Entity entity) {
            AttributeSet attributes = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{provider.getColor(entity), cleanUp});
            return attributes;
        }

        @Override
        public AttributeSet getAttributes(CsmOffsetable obj, String mimeType) {
            return this.color.get(mimeType);
        }

        @Override
        public ReferenceCollector getCollector(Document doc, Interrupter interrupter) {
            return null;
        }

        public NamedOption.OptionKind getKind() {
            return NamedOption.OptionKind.Boolean;
        }

        public Object getDefaultValue() {
            return true;
        }
    }

    public static final class UnusedVariablesCodeProvider
    extends AbstractSemanticEntity {
        private final ConcurrentHashMap<String, AttributeSet> unusedToolTipColors = new ConcurrentHashMap();
        private final AttributeSet UNUSED_TOOLTIP = AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"UNUSED_VARIABLE_TOOLTIP")});

        public UnusedVariablesCodeProvider() {
            super(FontColorProvider.Entity.UNUSED_VARIABLES);
        }

        public String getName() {
            return "unused-variables";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-unused-variables");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-unused-variables-AD");
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile, Document doc, Interrupter interrupter) {
            if (doc.getProperty("macro-expansion-view-document") == null) {
                return ModelUtils.collect(csmFile, doc, this.getCollector(doc, interrupter), interrupter);
            }
            return Collections.emptyList();
        }

        @Override
        public ReferenceCollector getCollector(Document doc, Interrupter interrupter) {
            return new ModelUtils.UnusedVariableCollector(interrupter);
        }

        @Override
        protected AttributeSet getColor(String mimeType) {
            return this.unusedToolTipColors.get(mimeType);
        }

        @Override
        public void updateFontColors(FontColorProvider provider) {
            super.updateFontColors(provider);
            this.unusedToolTipColors.put(provider.getMimeType(), AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{this.UNUSED_TOOLTIP, super.getColor(provider.getMimeType())}));
        }

        @Override
        public boolean isCsmFileBased() {
            return false;
        }
    }

    public static final class TypedefsCodeProvider
    extends AbstractSemanticEntity {
        public TypedefsCodeProvider() {
            super(FontColorProvider.Entity.TYPEDEF);
        }

        public String getName() {
            return "typedefs";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-typedefs");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-typedefs-AD");
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile, Document doc, Interrupter interrupter) {
            return ModelUtils.collect(csmFile, doc, this.getCollector(doc, interrupter), interrupter);
        }

        @Override
        public ReferenceCollector getCollector(Document doc, Interrupter interrupter) {
            return new ModelUtils.TypedefReferenceCollector(interrupter);
        }

        @Override
        public boolean isCsmFileBased() {
            return false;
        }
    }

    public static final class MacrosCodeProvider
    extends AbstractSemanticEntity {
        static final String NAME = "macros";
        private Map<String, AttributeSet> sysMacroColors = new HashMap<String, AttributeSet>();
        private Map<String, AttributeSet> userMacroColors = new HashMap<String, AttributeSet>();

        public MacrosCodeProvider() {
            super(FontColorProvider.Entity.DEFINED_MACRO);
        }

        public String getName() {
            return NAME;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-macros");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-macros-AD");
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile, Document doc, Interrupter interrupter) {
            if (doc.getProperty("macro-expansion-view-document") == null) {
                return ModelUtils.getMacroBlocks(csmFile, doc, interrupter);
            }
            return Collections.emptyList();
        }

        @Override
        public AttributeSet getAttributes(CsmOffsetable obj, String mimePath) {
            CsmMacro macro = (CsmMacro)((CsmReference)obj).getReferencedObject();
            if (macro == null) {
                return this.getColor(mimePath);
            }
            switch (macro.getKind()) {
                case USER_SPECIFIED: {
                    return this.userMacroColors.get(mimePath);
                }
                case COMPILER_PREDEFINED: 
                case POSITION_PREDEFINED: {
                    return this.sysMacroColors.get(mimePath);
                }
                case DEFINED: {
                    return this.getColor(mimePath);
                }
            }
            throw new IllegalArgumentException("unexpected macro kind:" + macro.getKind() + " in macro:" + macro);
        }

        @Override
        public void updateFontColors(FontColorProvider provider) {
            super.updateFontColors(provider);
            this.sysMacroColors.put(provider.getMimeType(), MacrosCodeProvider.getFontColor(provider, FontColorProvider.Entity.SYSTEM_MACRO));
            this.userMacroColors.put(provider.getMimeType(), MacrosCodeProvider.getFontColor(provider, FontColorProvider.Entity.USER_MACRO));
        }

        @Override
        public boolean isCsmFileBased() {
            return true;
        }
    }

    public static final class FunctionsCodeProvider
    extends AbstractSemanticEntity {
        private Map<String, AttributeSet> funUsageColors = new HashMap<String, AttributeSet>();

        public FunctionsCodeProvider() {
            super(FontColorProvider.Entity.FUNCTION);
        }

        public String getName() {
            return "functions-names";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-functions-names");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-functions-names-AD");
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile, Document doc, Interrupter interrupter) {
            return ModelUtils.collect(csmFile, doc, this.getCollector(doc, interrupter), interrupter);
        }

        @Override
        public ReferenceCollector getCollector(Document doc, Interrupter interrupter) {
            return new ModelUtils.FunctionReferenceCollector(interrupter);
        }

        @Override
        public AttributeSet getAttributes(CsmOffsetable obj, String mimePath) {
            CsmReference ref = (CsmReference)obj;
            if (ref == null || CsmReferenceResolver.getDefault().isKindOf(ref, CsmReferenceKind.FUNCTION_DECLARATION_KINDS)) {
                return this.getColor(mimePath);
            }
            return this.funUsageColors.get(mimePath);
        }

        @Override
        public void updateFontColors(FontColorProvider provider) {
            super.updateFontColors(provider);
            this.funUsageColors.put(provider.getMimeType(), FunctionsCodeProvider.getFontColor(provider, FontColorProvider.Entity.FUNCTION_USAGE));
        }

        @Override
        public boolean isCsmFileBased() {
            return false;
        }
    }

    public static final class FastFunctionsCodeProvider
    extends AbstractSemanticEntity {
        private Map<String, AttributeSet> funUsageColors = new HashMap<String, AttributeSet>();

        public FastFunctionsCodeProvider() {
            super(FontColorProvider.Entity.FUNCTION);
        }

        public String getName() {
            return "fast-functions-names";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-fast-functions-names");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-fast-functions-names-AD");
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile, Document doc, Interrupter interrupter) {
            Collection references = CsmReferenceResolver.getDefault().getReferences(csmFile);
            ArrayList<CsmReference> res = new ArrayList<CsmReference>();
            for (CsmReference ref : references) {
                if (interrupter.cancelled()) break;
                if (!CsmKindUtilities.isFunction((CsmObject)ref.getReferencedObject())) continue;
                res.add(ref);
            }
            return res;
        }

        @Override
        public ReferenceCollector getCollector(Document doc, Interrupter interrupter) {
            return null;
        }

        @Override
        public AttributeSet getAttributes(CsmOffsetable obj, String mimePath) {
            CsmReference ref = (CsmReference)obj;
            if (ref == null || CsmReferenceResolver.getDefault().isKindOf(ref, CsmReferenceKind.FUNCTION_DECLARATION_KINDS)) {
                return this.getColor(mimePath);
            }
            return this.funUsageColors.get(mimePath);
        }

        @Override
        public void updateFontColors(FontColorProvider provider) {
            super.updateFontColors(provider);
            this.funUsageColors.put(provider.getMimeType(), FastFunctionsCodeProvider.getFontColor(provider, FontColorProvider.Entity.FUNCTION_USAGE));
        }

        @Override
        public boolean isCsmFileBased() {
            return true;
        }
    }

    public static final class FieldCodeProvider
    extends AbstractSemanticEntity {
        public FieldCodeProvider() {
            super(FontColorProvider.Entity.CLASS_FIELD);
        }

        public String getName() {
            return "class-fields";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-class-fields");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-class-fields-AD");
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile, Document doc, Interrupter interrupter) {
            return ModelUtils.collect(csmFile, doc, this.getCollector(doc, interrupter), interrupter);
        }

        @Override
        public ReferenceCollector getCollector(Document doc, Interrupter interrupter) {
            return new ModelUtils.FieldReferenceCollector(interrupter);
        }

        @Override
        public boolean isCsmFileBased() {
            return false;
        }
    }

    public static final class FastFieldCodeProvider
    extends AbstractSemanticEntity {
        public FastFieldCodeProvider() {
            super(FontColorProvider.Entity.CLASS_FIELD);
        }

        public String getName() {
            return "fast-class-fields";
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile, Document doc, Interrupter interrupter) {
            Collection references = CsmReferenceResolver.getDefault().getReferences(csmFile);
            ArrayList<CsmReference> res = new ArrayList<CsmReference>();
            for (CsmReference ref : references) {
                if (interrupter.cancelled()) break;
                if (!CsmKindUtilities.isField((CsmObject)ref.getReferencedObject())) continue;
                res.add(ref);
            }
            return res;
        }

        @Override
        public ReferenceCollector getCollector(Document doc, Interrupter interrupter) {
            return null;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-fast-class-fields");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-fast-class-fields-AD");
        }

        @Override
        public boolean isCsmFileBased() {
            return true;
        }
    }

    public static final class InactiveCodeProvider
    extends AbstractSemanticEntity {
        static final String INACTIVE_NAME = "inactive";

        public InactiveCodeProvider() {
            super(FontColorProvider.Entity.INACTIVE_CODE);
        }

        public String getName() {
            return INACTIVE_NAME;
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile, Document doc, Interrupter interrupter) {
            if (doc.getProperty("macro-expansion-view-document") == null) {
                return ModelUtils.getInactiveCodeBlocks(csmFile, doc, interrupter);
            }
            return Collections.emptyList();
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-inactive");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-inactive-AD");
        }

        @Override
        public boolean isCsmFileBased() {
            return true;
        }
    }
}

