/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.hints;

import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.analysis.api.AnalyzerResponse;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.syntaxerr.AbstractCodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditFactory;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfoHintProvider;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.highlight.hints.ErrorInfoImpl;
import org.netbeans.modules.cnd.highlight.hints.MissingGuardBlock;
import org.netbeans.modules.cnd.highlight.hints.NonVirtualDestructor;
import org.netbeans.modules.cnd.highlight.hints.SafeFix;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class NotFirstInclude
extends AbstractCodeAudit {
    private final String message;

    private NotFirstInclude(String id, String name, String description, String defaultSeverity, boolean defaultEnabled, AuditPreferences myPreferences, String message) {
        super(id, name, description, defaultSeverity, defaultEnabled, myPreferences);
        this.message = message;
    }

    public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
        return kind == CsmErrorProvider.EditorEvent.FileBased;
    }

    public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        CsmFile file = request.getFile();
        if (file.isSourceFile()) {
            String name = file.getFileObject().getName();
            int i = 0;
            int insertionPoint = -1;
            for (CsmInclude incl : file.getIncludes()) {
                String headerName;
                CsmFile inc;
                if (request.isCancelled()) {
                    return;
                }
                if (i == 0) {
                    insertionPoint = incl.getStartOffset();
                }
                if ((inc = incl.getIncludeFile()) != null && name.equals(headerName = inc.getFileObject().getName())) {
                    if (i <= 0) break;
                    if (response instanceof AnalyzerResponse) {
                        String decoratedText = this.getID() + "\n" + NbBundle.getMessage(NotFirstInclude.class, (String)this.message, (Object)NotFirstInclude.getIncludeText(incl));
                        ((AnalyzerResponse)response).addError(AnalyzerResponse.AnalyzerSeverity.DetectedError, null, file.getFileObject(), (CsmErrorInfo)new MoveIncludeErrorInfoImpl(request.getDocument(), "General", this.getID(), decoratedText, NotFirstInclude.toSeverity((String)this.minimalSeverity()), incl.getStartOffset(), incl.getEndOffset(), insertionPoint));
                        break;
                    }
                    String decoratedText = NbBundle.getMessage(NotFirstInclude.class, (String)this.message, (Object)NotFirstInclude.getIncludeText(incl));
                    response.addError((CsmErrorInfo)new MoveIncludeErrorInfoImpl(request.getDocument(), "General", this.getID(), decoratedText, NotFirstInclude.toSeverity((String)this.minimalSeverity()), incl.getStartOffset(), incl.getEndOffset(), insertionPoint));
                    break;
                }
                ++i;
            }
        }
    }

    private static String getIncludeText(CsmInclude incl) {
        if (incl.isSystem()) {
            return "<" + incl.getIncludeName() + ">";
        }
        return "\"" + incl.getIncludeName() + "\"";
    }

    private static final class MoveIncludeFix
    extends SafeFix {
        private final BaseDocument doc;
        private final Position start;
        private final Position end;
        private final Position isertionPoint;

        public MoveIncludeFix(BaseDocument doc, int startOffset, int endOffset, int insertionPoint) throws BadLocationException {
            this.doc = doc;
            this.start = NbDocument.createPosition((Document)doc, (int)(startOffset - 1), (Position.Bias)Position.Bias.Forward);
            this.end = NbDocument.createPosition((Document)doc, (int)endOffset, (Position.Bias)Position.Bias.Backward);
            this.isertionPoint = NbDocument.createPosition((Document)doc, (int)insertionPoint, (Position.Bias)Position.Bias.Backward);
        }

        public String getText() {
            return NbBundle.getMessage(NonVirtualDestructor.class, (String)"NotFirstInclude.fix");
        }

        @Override
        public ChangeInfo performFix() throws BadLocationException, Exception {
            this.doc.runAtomicAsUser(new Runnable(){

                @Override
                public void run() {
                    try {
                        String text = MoveIncludeFix.this.doc.getText(MoveIncludeFix.this.start.getOffset() + 1, MoveIncludeFix.this.end.getOffset() - MoveIncludeFix.this.start.getOffset() - 1) + "\n";
                        MoveIncludeFix.this.doc.remove(MoveIncludeFix.this.start.getOffset(), MoveIncludeFix.this.end.getOffset() - MoveIncludeFix.this.start.getOffset());
                        MoveIncludeFix.this.doc.insertString(MoveIncludeFix.this.isertionPoint.getOffset(), text, null);
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace(System.err);
                    }
                }
            });
            return null;
        }
    }

    public static final class MoveIncludeFixProvider
    extends CsmErrorInfoHintProvider {
        protected List<Fix> doGetFixes(CsmErrorInfo info, List<Fix> alreadyFound) {
            if (info instanceof MoveIncludeErrorInfoImpl) {
                alreadyFound.addAll(this.createFixes((MoveIncludeErrorInfoImpl)info));
            }
            return alreadyFound;
        }

        private List<? extends Fix> createFixes(MoveIncludeErrorInfoImpl info) {
            try {
                return Collections.singletonList(new MoveIncludeFix(info.doc, info.getStartOffset(), info.getEndOffset(), info.insertionPoint));
            }
            catch (BadLocationException ex) {
                return Collections.emptyList();
            }
        }
    }

    private static final class MoveIncludeErrorInfoImpl
    extends ErrorInfoImpl {
        private final BaseDocument doc;
        private final int insertionPoint;

        public MoveIncludeErrorInfoImpl(Document doc, String providerName, String audutName, String message, CsmErrorInfo.Severity severity, int startOffset, int endOffset, int insertionPoint) {
            super(providerName, audutName, message, severity, startOffset, endOffset);
            this.doc = (BaseDocument)doc;
            this.insertionPoint = insertionPoint;
        }
    }

    public static final class Factory
    implements CodeAuditFactory {
        public AbstractCodeAudit create(AuditPreferences preferences) {
            String id = NbBundle.getMessage(MissingGuardBlock.class, (String)"NotFirstInclude.name");
            String description = NbBundle.getMessage(MissingGuardBlock.class, (String)"NotFirstInclude.description");
            String message = "NotFirstInclude.message";
            return new NotFirstInclude(id, id, description, "warning", false, preferences, message);
        }
    }
}

