/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BetweenExpressionStateObject
extends AbstractStateObject {
    private StateObject lowerBoundStateObject;
    private boolean not;
    private StateObject stateObject;
    private StateObject upperBoundStateObject;
    public static final String LOWER_STATE_OBJECT_PROPERTY = "lowerBoundStateObject";
    public static final String NOT_PROPERTY = "not";
    public static final String STATE_OBJECT_PROPERTY = "stateObject";
    public static final String UPPER_STATE_OBJECT_PROPERTY = "upperBoundStateObject";

    public BetweenExpressionStateObject(StateObject parent) {
        super(parent);
    }

    public BetweenExpressionStateObject(StateObject parent, StateObject stateObject, boolean not, StateObject lowerBound, StateObject upperBound) {
        super(parent);
        this.not = not;
        this.stateObject = this.parent(stateObject);
        this.lowerBoundStateObject = this.parent(lowerBound);
        this.upperBoundStateObject = this.parent(upperBound);
    }

    public BetweenExpressionStateObject(StateObject parent, StateObject stateObject, StateObject lowerBound, StateObject upperBound) {
        this(parent, stateObject, false, lowerBound, upperBound);
    }

    public BetweenExpressionStateObject(StateObject parent, String jpqlFragment, boolean not, String lowerBoundJpqlFragment, String upperBoundJpqlFragment) {
        super(parent);
        this.not = not;
        this.parse(jpqlFragment);
        this.parseLowerBound(lowerBoundJpqlFragment);
        this.parseUpperBound(upperBoundJpqlFragment);
    }

    public BetweenExpressionStateObject(StateObject parent, String jpqlFragment, String lowerBoundJpqlFragment, String upperBoundJpqlFragment) {
        this(parent, jpqlFragment, false, lowerBoundJpqlFragment, upperBoundJpqlFragment);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        if (this.stateObject != null) {
            children.add(this.stateObject);
        }
        if (this.lowerBoundStateObject != null) {
            children.add(this.lowerBoundStateObject);
        }
        if (this.upperBoundStateObject != null) {
            children.add(this.upperBoundStateObject);
        }
    }

    public BetweenExpressionStateObject addNot() {
        if (!this.not) {
            this.setNot(true);
        }
        return this;
    }

    @Override
    public BetweenExpression getExpression() {
        return (BetweenExpression)super.getExpression();
    }

    public StateObject getLowerBound() {
        return this.lowerBoundStateObject;
    }

    public StateObject getStateObject() {
        return this.stateObject;
    }

    public StateObject getUpperBound() {
        return this.upperBoundStateObject;
    }

    public boolean hasLowerBound() {
        return this.lowerBoundStateObject != null;
    }

    public boolean hasNot() {
        return this.not;
    }

    public boolean hasStateObject() {
        return this.stateObject != null;
    }

    public boolean hasUpperBound() {
        return this.upperBoundStateObject != null;
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            BetweenExpressionStateObject between = (BetweenExpressionStateObject)stateObject;
            return this.not == between.not && this.areEquivalent(stateObject, between.stateObject) && this.areEquivalent(this.lowerBoundStateObject, between.lowerBoundStateObject) && this.areEquivalent(this.upperBoundStateObject, between.upperBoundStateObject);
        }
        return false;
    }

    public void parse(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, "internal_between_expression");
        this.setStateObject((StateObject)stateObject);
    }

    public void parseLowerBound(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, "internal_between_expression");
        this.setLowerBound((StateObject)stateObject);
    }

    public void parseUpperBound(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, "internal_between_expression");
        this.setUpperBound((StateObject)stateObject);
    }

    public void removeNot() {
        if (this.not) {
            this.setNot(false);
        }
    }

    public void setExpression(BetweenExpression expression) {
        super.setExpression(expression);
    }

    public void setLowerBound(StateObject lowerBound) {
        StateObject oldLowerBoundStateObject = this.lowerBoundStateObject;
        this.lowerBoundStateObject = this.parent(lowerBound);
        this.firePropertyChanged(LOWER_STATE_OBJECT_PROPERTY, oldLowerBoundStateObject, this.lowerBoundStateObject);
    }

    public void setNot(boolean not) {
        boolean oldNot = this.not;
        this.not = not;
        this.firePropertyChanged(NOT_PROPERTY, oldNot, not);
    }

    public void setStateObject(StateObject stateObject) {
        StateObject oldStateObject = this.stateObject;
        this.stateObject = this.parent(stateObject);
        this.firePropertyChanged(STATE_OBJECT_PROPERTY, oldStateObject, stateObject);
    }

    public void setUpperBound(StateObject upperBound) {
        StateObject oldUpperBoundStateObject = this.upperBoundStateObject;
        this.upperBoundStateObject = this.parent(upperBound);
        this.firePropertyChanged(UPPER_STATE_OBJECT_PROPERTY, oldUpperBoundStateObject, this.upperBoundStateObject);
    }

    public void toggleNot() {
        this.setNot(!this.not);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        if (this.stateObject != null) {
            this.stateObject.toString(writer);
            writer.append(' ');
        }
        writer.append(this.not ? "NOT BETWEEN" : "BETWEEN");
        if (this.lowerBoundStateObject != null) {
            writer.append(' ');
            this.lowerBoundStateObject.toString(writer);
        }
        writer.append(' ');
        writer.append("AND");
        if (this.upperBoundStateObject != null) {
            writer.append(' ');
            this.upperBoundStateObject.toString(writer);
        }
    }
}

